/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.util.Map;

public class HttpFactoryConfig {
    private static final TraceComponent tc = Tr.register(HttpFactoryConfig.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private long msgSizeLimit = -1L;
    private long msgSizeLargeBuffer = -1L;

    public HttpFactoryConfig(Map props) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Parsing config for factory");
        }
        if (null != props) {
            this.parseMsgSize(props);
            this.parseMsgLargeBuffer(props);
        }
    }

    private void parseMsgSize(Map props) {
        block5: {
            String value = (String)props.get("MessageSizeLimit");
            if (null != value) {
                try {
                    this.msgSizeLimit = Long.parseLong(value);
                    if (-1L > this.getMessageSize()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            Tr.event(tc, "Config: Invalid size, setting to unlimited");
                        }
                        this.msgSizeLimit = -1L;
                    }
                }
                catch (NumberFormatException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block5;
                    Tr.event(tc, "Config: Invalid maximum message size; " + value);
                }
            }
        }
    }

    public long getMessageSize() {
        return this.msgSizeLimit;
    }

    public boolean areMessagesLimited() {
        return -1L != this.getMessageSize();
    }

    private void parseMsgLargeBuffer(Map props) {
        block6: {
            if (!this.areMessagesLimited()) {
                return;
            }
            String value = (String)props.get("LargeMessageSize");
            if (null != value) {
                try {
                    long limit = Long.parseLong(value);
                    if (limit < this.getMessageSize() || -1L > limit) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Config: Invalid large buffer limit: " + limit);
                        }
                        limit = this.getMessageSize();
                    }
                    this.msgSizeLargeBuffer = limit;
                }
                catch (NumberFormatException e) {
                    if (!tc.isEventEnabled()) break block6;
                    Tr.event(tc, "Config: Non-numeric large buffer size; " + value);
                }
            }
        }
    }

    public long getLargerBufferSize() {
        return this.msgSizeLargeBuffer;
    }
}

