/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.http.HttpResponse;
import com.ibm.ws.io.Stream;
import com.ibm.ws.io.WriteStream;
import com.ibm.ws.util.Buffer;
import java.io.IOException;

public class ResponseStream
extends Stream {
    public static byte[] CRLF = new byte[]{13, 10};
    static byte[] CONTINUE = "HTTP/1.1 100 Continue\r\n\r\n".getBytes();
    static byte[] EXTENDED_HANDSHAKE = "HTTP/1.1 200 OK\r\n\r\n".getBytes();
    protected HttpResponse response;
    protected WriteStream next;
    protected boolean chunkedEncoding;
    protected Buffer head;
    protected Buffer tail;
    protected int chunkLength;
    protected int bufferSize;
    protected int numBytesWritten;
    protected boolean flushToWire;
    protected boolean isClosed;
    protected boolean noBody;
    private static TraceComponent tc = Tr.register(ResponseStream.class.getName(), "HTTP_Transport");
    private byte[] chunkBuf = new byte[16];

    public void init(HttpResponse rsp, WriteStream os) {
        this.response = rsp;
        this.next = os;
    }

    void start() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "start");
        }
        this.chunkedEncoding = false;
        this.response.headersWritten = false;
        this.chunkLength = 0;
        this.bufferSize = 8192;
        if (this.head != null) {
            this.head.clear();
        }
        this.tail = this.head;
        this.numBytesWritten = 0;
        this.setFlushMode(true);
        this.isClosed = false;
        this.noBody = false;
    }

    public void setNoBody() {
        this.noBody = true;
        this.bufferSize = 0;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setNoBody");
        }
    }

    public int getNumBytesWritten() {
        return this.numBytesWritten;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int size) {
        int chunk = Buffer.SIZE;
        this.bufferSize = chunk * ((size + chunk - 1) / chunk);
        if (this.bufferSize <= 0) {
            this.bufferSize = 0;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setBufferSize", "requested: " + size + "; actual: " + this.bufferSize);
        }
    }

    public boolean isCommitted() {
        boolean rtn;
        boolean bl = rtn = this.response.headersWritten || this.isClosed;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isCommitted", new Boolean(rtn));
        }
        return rtn;
    }

    public void clear() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "clear");
        }
        if (this.head != null) {
            Buffer.freeAll(this.head.getNext());
            this.head.clear();
        }
        this.tail = this.head;
        this.chunkLength = 0;
        this.numBytesWritten = 0;
    }

    public void write(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "write", "length=" + length + "; isEnd=" + isEnd);
        }
        if (this.noBody || this.isClosed) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "write", "noBody or closed");
            }
            return;
        }
        if (length > 0) {
            this.numBytesWritten += length;
        }
        if (isEnd) {
            this.flushBuffer(true);
            this.writeChunk(buf, offset, length);
            return;
        }
        while (length > 0 && !this.isClosed) {
            if (this.head == null) {
                this.head = this.tail = Buffer.allocate();
            } else if (this.tail.getLength() >= Buffer.SIZE) {
                if (this.chunkLength + length > this.bufferSize - Buffer.SIZE) {
                    this.flushBuffer(isEnd);
                } else {
                    Buffer tBuf = Buffer.allocate();
                    this.tail.setNext(tBuf);
                    this.tail = tBuf;
                }
            }
            int sublen = this.tail.write(buf, offset, length);
            offset += sublen;
            length -= sublen;
            this.chunkLength += sublen;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "write");
        }
    }

    public void finish(boolean close, boolean flush) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "finish", "close=" + close + "; flush=" + flush);
        }
        if (this.next == null || this.isClosed) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "finish", "closed");
            }
            return;
        }
        this.flushBuffer(true);
        this.isClosed = true;
        try {
            if (this.chunkedEncoding) {
                this.next.write(48);
                this.next.write(CRLF);
                this.next.write(CRLF);
            }
            if (close) {
                this.next.close();
                this.next = null;
            } else if (flush) {
                this.next.flush();
            }
        }
        catch (IOException ioe) {
            this.clear();
            throw ioe;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "finish");
        }
    }

    public void flushBuffer(boolean isEnd) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "flushBuffer", new Boolean(isEnd));
        }
        if (this.isClosed) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "flushBuffer", "closed");
            }
            return;
        }
        this.writeHeaders(isEnd ? this.numBytesWritten : -1);
        while (this.head != null) {
            this.writeChunk(this.head.getBuffer(), 0, this.head.getLength());
            Buffer ptr = this.head.getNext();
            if (ptr == null) break;
            Buffer.free(this.head);
            this.head = ptr;
        }
        this.tail = this.head;
        if (this.head != null) {
            this.head.clear();
        }
        this.chunkLength = 0;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "flushBuffer");
        }
    }

    private void writeHeaders(int length) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeHeaders");
        }
        if (this.response.headersWritten || this.isClosed) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "writeHeaders", "closed");
            }
            return;
        }
        this.chunkedEncoding = this.response.writeHeaders(this.next, length);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeHeaders");
        }
    }

    private void writeChunk(byte[] buf, int offset, int length) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeChunk", "length=" + length);
        }
        if (length <= 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "writeChunk", "no length");
            }
            return;
        }
        if (this.next == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "writeChunk", "no next");
            }
            return;
        }
        if (this.noBody) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "writeChunk", "noBody");
            }
            return;
        }
        try {
            if (!this.chunkedEncoding) {
                this.next.write(buf, offset, length);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "writeChunk", "not chunked");
                }
                return;
            }
            int off = this.chunkBuf.length;
            this.chunkBuf[--off] = 10;
            this.chunkBuf[--off] = 13;
            for (int count = length; count > 0; count >>= 4) {
                int digit = count & 0xF;
                this.chunkBuf[--off] = digit <= 9 ? (byte)(48 + digit) : (byte)(97 + digit - 10);
            }
            this.next.write(this.chunkBuf, off, this.chunkBuf.length - off);
            this.next.write(buf, offset, length);
            this.next.write(this.chunkBuf, this.chunkBuf.length - 2, 2);
        }
        catch (IOException ioe) {
            this.clear();
            throw ioe;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeChunk");
        }
    }

    public void flush() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "flush");
        }
        if (this.flushToWire && !this.isClosed) {
            this.flushBuffer(false);
            try {
                this.next.flush();
            }
            catch (IOException ioe) {
                this.clear();
                throw ioe;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "flush");
        }
    }

    public void close() throws IOException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "close");
        }
    }

    void sendContinue() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendContinue");
        }
        try {
            this.next.write(CONTINUE);
            this.next.flush();
        }
        catch (IOException ioe) {
            this.clear();
            throw ioe;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendContinue");
        }
    }

    void sendExtendedHandshake() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendExtendedHandshake");
        }
        try {
            this.next.write(EXTENDED_HANDSHAKE);
            this.next.flush();
            this.isClosed = true;
        }
        catch (IOException ioe) {
            this.clear();
            throw ioe;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendExtendedHandshake");
        }
    }

    public void setFlushMode(boolean flushToWire) {
        this.flushToWire = flushToWire;
    }
}

