/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.models.config.ipc.Transport;
import com.ibm.websphere.product.WASProduct;
import com.ibm.ws.http.HttpConnection;
import com.ibm.ws.http.HttpServer;
import com.ibm.ws.http.Logger;
import com.ibm.ws.ssl.core.Constants;
import com.ibm.ws.util.TransportLogger;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Properties;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLServerSocket;

public class HttpTransport
implements Runnable {
    public static final String HOST = "Host";
    public static final String PORT = "Port";
    public static final String MAX_CONNECT_BACKLOG = "MaxConnectBacklog";
    public static final String TCP_NO_DELAY = "TcpNoDelay";
    public static final String KEEP_ALIVE_ENABLE = "KeepAliveEnabled";
    public static final String SERVER_HEADER_VALUE = "ServerHeaderValue";
    public static final String REMOVE_SERVER_HEADER = "RemoveServerHeader";
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static TraceComponent tc = Tr.register(HttpTransport.class.getName(), "HTTP_Transport");
    private boolean removeServerHeader;
    private String serverHeader;
    private HttpServer httpServer;
    private String host;
    private int port;
    private int maxBacklog;
    private boolean tcpNoDelay;
    InetAddress ia;
    Logger logger;
    HttpServer httpserver;
    private ServerSocket serverSocket;
    private boolean alive;
    private String scheme;
    private boolean isSecure;
    private Thread acceptThread;
    private boolean prevAcceptError;
    private int AcceptErrCnt;
    private int maxKeepAliveRequests;
    private int connectionIOTimeout;
    private int connectionKeepAliveTimeout;
    private boolean isKeepAlive;

    public HttpTransport() {
        block4: {
            this.removeServerHeader = false;
            this.httpServer = null;
            this.host = null;
            this.port = -1;
            this.maxBacklog = 511;
            this.tcpNoDelay = true;
            this.ia = null;
            this.scheme = HTTP;
            this.isSecure = false;
            this.acceptThread = null;
            this.prevAcceptError = false;
            this.AcceptErrCnt = 0;
            this.isKeepAlive = true;
            this.maxKeepAliveRequests = 100;
            this.connectionKeepAliveTimeout = 5000;
            this.connectionIOTimeout = 5000;
            String timeout = System.getProperty("com.ibm.ws.http.ConnectionIOTimeout");
            if (timeout != null) {
                try {
                    this.connectionIOTimeout = Integer.parseInt(timeout);
                    if (HttpServer.debugEnabled) {
                        Logger.log(4, "HttpTransport: ctor: setting connectionIOTimeout to " + timeout);
                    }
                }
                catch (NumberFormatException e) {
                    if (!HttpServer.debugEnabled) break block4;
                    Logger.log(4, "HttpTransport: ctor: " + timeout + " is an invalid value for connectionIOTimeout");
                }
            }
        }
        WASProduct wasproduct = new WASProduct();
        this.serverHeader = "WebSphere Application Server/" + wasproduct.getPlatform().getVersion();
    }

    public void reinitialize(Properties sslProperties) throws Exception {
        block19: {
            if (!HttpServer.errorLogDisable) {
                Logger.log(3, "HTTP0101I Reinitializing . . .");
            }
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "reinitialize");
            }
            try {
                this.shutdown(true);
                for (int count = 0; !this.serverSocket.isClosed() || count >= 5; ++count) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Waiting for server socket to close.");
                    }
                    Thread.sleep(200L);
                }
                this.alive = true;
                ServerSocketFactory ssf = this.getSSLServerSocketFactory(sslProperties);
                this.serverSocket = ssf.createServerSocket(this.port, this.maxBacklog, this.ia);
                if (this.serverSocket != null) {
                    if (!HttpServer.errorLogDisable) {
                        Logger.log(3, "HTTP0200I  SSL is enabled for port " + this.port);
                    }
                    if (HttpServer.debugEnabled) {
                        Logger.log(4, "HttpTransport: Socket has be opened for port " + this.port + " with Security Enabled");
                    }
                    if (sslProperties != null) {
                        boolean clientAuthRequiredBoolean;
                        String clientAuthSupported = sslProperties.getProperty("com.ibm.ssl.clientAuthenticationSupported");
                        boolean clientAuthSupportedBoolean = clientAuthSupported != null && clientAuthSupported.equals("true");
                        String clientAuthRequired = sslProperties.getProperty("com.ibm.ssl.clientAuthentication");
                        boolean bl = clientAuthRequiredBoolean = clientAuthRequired != null && clientAuthRequired.equals("true");
                        if (clientAuthRequiredBoolean) {
                            ((SSLServerSocket)this.serverSocket).setNeedClientAuth(clientAuthRequiredBoolean);
                        } else if (clientAuthSupportedBoolean) {
                            ((SSLServerSocket)this.serverSocket).setWantClientAuth(clientAuthSupportedBoolean);
                        }
                        String[] enabledCiphers = this.parseEnabledCiphers(sslProperties.getProperty("com.ibm.ssl.enabledCipherSuites"));
                        if (enabledCiphers != null && enabledCiphers.length > 0) {
                            ((SSLServerSocket)this.serverSocket).setEnabledCipherSuites(enabledCiphers);
                        } else {
                            String[] supportedCiphers = ((SSLServerSocket)this.serverSocket).getSupportedCipherSuites();
                            String securityLevel = sslProperties.getProperty("com.ibm.ssl.securityLevel");
                            if (supportedCiphers != null && securityLevel != null) {
                                supportedCiphers = HttpTransport.adjustSupportedCiphersToSecurityLevel(supportedCiphers, securityLevel);
                            }
                            if (supportedCiphers != null && supportedCiphers.length > 0) {
                                ((SSLServerSocket)this.serverSocket).setEnabledCipherSuites(supportedCiphers);
                            }
                        }
                    }
                    this.acceptThread = new Thread((Runnable)this, this.serverSocket.toString());
                    this.acceptThread.setDaemon(true);
                    this.acceptThread.start();
                }
            }
            catch (Exception e) {
                Tr.error(tc, e.toString());
                Manager.Ffdc.log(e, this, "com.ibm.ws.http.HttpTransport.reinitialize", "169", this);
                if (!tc.isDebugEnabled()) break block19;
                Tr.debug(tc, "Exception reinitialization SOAP server socket.", new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reinitialize");
        }
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpTransport: Reinitialization has completed");
        }
    }

    public void initialize(HttpServer httpServer, Transport transport) throws Exception {
        this.initialize(httpServer, transport, new Properties());
    }

    public void initialize(HttpServer httpServer, boolean sslEnabled, Properties sslProperties) throws Exception {
        if (!HttpServer.errorLogDisable) {
            Logger.log(3, "HTTP0101I Initializing . . .");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        this.httpServer = httpServer;
        this.alive = true;
        if (this.host != null && this.host.length() != 0 && !this.host.equals("*")) {
            this.ia = InetAddress.getByName(this.host);
            if (HttpServer.debugEnabled) {
                Logger.log(4, "HttpTransport: Determined Internet Address " + this.ia + "from host " + this.host);
            }
        }
        if (sslEnabled) {
            this.scheme = HTTPS;
            this.isSecure = true;
            if (this.port == -1) {
                this.port = 443;
            }
            ServerSocketFactory ssf = this.getSSLServerSocketFactory(sslProperties);
            this.serverSocket = ssf.createServerSocket(this.port, this.maxBacklog, this.ia);
            if (this.serverSocket != null) {
                if (!HttpServer.errorLogDisable) {
                    Logger.log(3, "HTTP0200I  SSL is enabled for port " + this.port);
                }
                if (HttpServer.debugEnabled) {
                    Logger.log(4, "HttpTransport: Socket has be opened for port " + this.port + " with Security Enabled");
                }
                if (sslProperties != null) {
                    boolean clientAuthRequiredBoolean;
                    String clientAuthSupported = sslProperties.getProperty("com.ibm.ssl.clientAuthenticationSupported");
                    boolean clientAuthSupportedBoolean = clientAuthSupported != null && clientAuthSupported.equals("true");
                    String clientAuthRequired = sslProperties.getProperty("com.ibm.ssl.clientAuthentication");
                    boolean bl = clientAuthRequiredBoolean = clientAuthRequired != null && clientAuthRequired.equals("true");
                    if (clientAuthRequiredBoolean) {
                        ((SSLServerSocket)this.serverSocket).setNeedClientAuth(clientAuthRequiredBoolean);
                    } else if (clientAuthSupportedBoolean) {
                        ((SSLServerSocket)this.serverSocket).setWantClientAuth(clientAuthSupportedBoolean);
                    }
                    String[] enabledCiphers = this.parseEnabledCiphers(sslProperties.getProperty("com.ibm.ssl.enabledCipherSuites"));
                    if (enabledCiphers != null && enabledCiphers.length > 0) {
                        ((SSLServerSocket)this.serverSocket).setEnabledCipherSuites(enabledCiphers);
                    } else {
                        String[] supportedCiphers = ((SSLServerSocket)this.serverSocket).getSupportedCipherSuites();
                        String securityLevel = sslProperties.getProperty("com.ibm.ssl.securityLevel");
                        if (supportedCiphers != null && securityLevel != null) {
                            supportedCiphers = HttpTransport.adjustSupportedCiphersToSecurityLevel(supportedCiphers, securityLevel);
                        }
                        if (supportedCiphers != null && supportedCiphers.length > 0) {
                            ((SSLServerSocket)this.serverSocket).setEnabledCipherSuites(supportedCiphers);
                        }
                    }
                }
            }
        } else {
            String socketPropName;
            String socketPropFile;
            if (this.port == -1) {
                this.port = 80;
            }
            if ((socketPropFile = System.getProperty(socketPropName = "com.ibm.ws.http.socketProps." + this.port)) != null) {
                Properties props = new Properties();
                props.load(new FileInputStream(socketPropFile));
                this.serverSocket = com.ibm.ws.util.ServerSocketFactory.getInstance(this.port, this.maxBacklog, this.ia, this, props);
                if (this.serverSocket != null && !HttpServer.errorLogDisable) {
                    Logger.log(3, "HTTP0201I  SSL is not enabled for port " + this.port);
                }
                if (HttpServer.debugEnabled) {
                    Logger.log(4, "HttpTransport: Socket has been opened for port " + this.port);
                }
            } else {
                this.serverSocket = new ServerSocket(this.port, this.maxBacklog, this.ia);
                if (this.serverSocket != null && !HttpServer.errorLogDisable) {
                    Logger.log(3, "HTTP0202I  SSL is not enabled for port " + this.port);
                }
                if (HttpServer.debugEnabled) {
                    Logger.log(4, "HttpTransport: Socket has been opened for port " + this.port);
                }
            }
        }
        this.acceptThread = new Thread((Runnable)this, this.serverSocket.toString());
        this.acceptThread.setDaemon(true);
        this.acceptThread.start();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpTransport: Initialization has completed");
        }
    }

    public void initialize(HttpServer httpServer, Transport transport, Properties sslProperties) throws Exception {
        if (transport != null) {
            this.initialize(httpServer, transport.isSslEnabled(), sslProperties);
        } else {
            this.initialize(httpServer, false, sslProperties);
        }
    }

    private String[] parseEnabledCiphers(String enabledCiphers) {
        if (enabledCiphers != null) {
            return enabledCiphers.split("\\s");
        }
        return null;
    }

    public static String[] adjustSupportedCiphersToSecurityLevel(String[] supportedCiphers, String securityLevel) {
        return Constants.adjustSupportedCiphersToSecurityLevel(supportedCiphers, securityLevel);
    }

    public static String convertCipherListToString(String[] cipherList) {
        return Constants.convertCipherListToString(cipherList);
    }

    private ServerSocketFactory getSSLServerSocketFactory(Properties sslProperties) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSSLServerSocketFactory");
        }
        Class<?> JSSEHelperClass = Class.forName("com.ibm.websphere.ssl.JSSEHelper");
        Object JSSEHelperObject = JSSEHelperClass.newInstance();
        Method getSSLServerSocketMethod = JSSEHelperClass.getMethod("getSSLServerSocketFactory", Properties.class);
        Object ret = getSSLServerSocketMethod.invoke(JSSEHelperObject, sslProperties);
        if (ret != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSSLServerSocketFactory");
            }
            return (ServerSocketFactory)ret;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSSLServerSocketFactory");
        }
        throw new IllegalArgumentException("Could not get the server socket factory.");
    }

    public void shutdown(boolean force) {
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "shutdown");
            }
            this.alive = false;
            try {
                InetAddress myHost = this.serverSocket.getInetAddress();
                try {
                    if (myHost != null) {
                        Socket s = new Socket(myHost, this.serverSocket.getLocalPort());
                    } else {
                        Socket s = new Socket("127.0.0.1", this.serverSocket.getLocalPort());
                    }
                }
                catch (Exception ex) {
                    if (!HttpServer.errorLogDisable) {
                        Logger.log(0, "HTTP0104C Local Connection Failed");
                    }
                    Manager.Ffdc.log(ex, this, "com.ibm.ws.http.HttpTransport.run", "125");
                    this.acceptThread.interrupt();
                }
                this.acceptThread.join(10000L);
            }
            catch (InterruptedException ie) {
                Manager.Ffdc.log(ie, this, "com.ibm.ws.http.HttpTransport.run", "134");
                if (!tc.isDebugEnabled()) break block10;
                Tr.debug(tc, "shutdown", ie);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "shutdown");
        }
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpTransport: Shutdown has completed");
        }
    }

    public boolean isAlive() {
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpTransport: Determine if socket is alive");
        }
        return this.alive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block34: {
            if (HttpServer.debugEnabled) {
                Logger.log(4, "HttpTransport: Running Thread");
            }
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "run");
            }
            while (this.alive) {
                Socket socket;
                block33: {
                    socket = null;
                    try {
                        socket = this.serverSocket.accept();
                        this.prevAcceptError = false;
                        if (HttpServer.debugEnabled) {
                            Logger.log(4, "HttpTransport: Accept Socket");
                        }
                    }
                    catch (IOException ioe) {
                        Manager.Ffdc.log(ioe, this, "com.ibm.ws.http.HttpTransport.run", "153");
                        if (!this.alive) break block33;
                        if (!HttpServer.errorLogDisable) {
                            Logger.log(1, "HTTP0102E Server Socket Accept Failed");
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "server socket accept failure", ioe);
                        }
                        if (this.prevAcceptError) {
                            if (++this.AcceptErrCnt > 50) {
                                try {
                                    Thread.sleep(3000L);
                                    this.AcceptErrCnt = 1;
                                }
                                catch (InterruptedException ie) {}
                            }
                        }
                        this.prevAcceptError = true;
                        this.AcceptErrCnt = 1;
                    }
                }
                if (socket == null) continue;
                if (this.alive) {
                    HttpConnection conn = null;
                    int remotePort = -1;
                    String remoteAddress = "unknown";
                    if (TransportLogger.debugEnabled()) {
                        remotePort = socket.getPort();
                        remoteAddress = socket.getInetAddress().getHostAddress();
                        TransportLogger.debug("HttpTransport.run():  accept: remotePort=[" + remotePort + "] remoteAddress=[" + remoteAddress + "]");
                    }
                    try {
                        conn = this.httpServer.allocateConnection();
                        conn.init(this, socket);
                        HttpConnection httpConnection = conn;
                        synchronized (httpConnection) {
                            try {
                                this.httpServer.handleConnection(conn);
                            }
                            catch (Throwable th) {
                                conn.setAborted(true);
                                conn.cleanup();
                                throw th;
                            }
                        }
                    }
                    catch (Throwable t) {
                        Manager.Ffdc.log(t, this, "com.ibm.ws.http.HttpTransport.run", "175");
                        if (TransportLogger.debugEnabled()) {
                            TransportLogger.debug("HttpTransport.run(): error handling the connection " + t.getMessage() + " remotePort=[" + remotePort + "] remoteAddress=[" + remoteAddress + "]");
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "failure handling connection", t);
                        }
                        if (!HttpServer.errorLogDisable) {
                            Logger.log(1, "HTTP0103E Could not handle Connection");
                        }
                        try {
                            socket.close();
                        }
                        catch (IOException ex) {
                            if (HttpServer.errorLogDisable) continue;
                            Logger.log(1, "HTTP0104E Could not close Socket");
                        }
                        continue;
                    }
                }
                try {
                    socket.close();
                }
                catch (IOException ex) {
                    if (HttpServer.errorLogDisable) continue;
                    Logger.log(1, "HTTP0105E Could not close Socket");
                }
            }
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException ioe) {
                    Manager.Ffdc.log(ioe, this, "com.ibm.ws.http.HttpTransport.run", "198");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "error closing server socket", ioe);
                    }
                    if (HttpServer.errorLogDisable) break block34;
                    Logger.log(1, "HTTP0106E Could not close Socket");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "run");
        }
    }

    public boolean isSecure() {
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpTransport: Determine if is secure Connection");
        }
        return this.isSecure;
    }

    public String getScheme() {
        return this.scheme;
    }

    public HttpServer getHttpServer() {
        return this.httpServer;
    }

    public void setHttpServer(HttpServer httpServer) {
        this.httpServer = httpServer;
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpTransport: Setting HttpServer");
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = Integer.parseInt(port);
    }

    public int getMaxBacklog() {
        return this.maxBacklog;
    }

    public void setMaxBacklog(String max) {
        this.maxBacklog = Integer.parseInt(max);
    }

    public boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(String noDelay) {
        this.tcpNoDelay = this.getBooleanValue(TCP_NO_DELAY, noDelay, true);
    }

    private boolean getBooleanValue(String name, String value, boolean defValue) {
        if (value.equalsIgnoreCase("true")) {
            Tr.debug(tc, name + " set to true");
            if (HttpServer.debugEnabled) {
                Logger.log(4, "HttpTransport: " + name + " set to true");
            }
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            Tr.debug(tc, name + " set to false");
            if (HttpServer.debugEnabled) {
                Logger.log(4, "HttpTransport: " + name + " set to false");
            }
            return false;
        }
        Tr.warning(tc, "invalid value for " + name + ": '" + value + "'; setting to " + defValue);
        if (!HttpServer.errorLogDisable) {
            Logger.log(2, "HTTP0309W invalid value for " + name + ": '" + value + "'; setting to " + defValue);
        }
        return defValue;
    }

    public int getConnectionIOTimeout() {
        return this.connectionIOTimeout;
    }

    public int getConnectionKeepAliveTimeout() {
        return this.connectionKeepAliveTimeout;
    }

    public int getMaxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    public void setConnectionIOTimeout(int connectionIOTimeout) {
        this.connectionIOTimeout = connectionIOTimeout * 1000;
    }

    public void setConnectionKeepAliveTimeout(int connectionKeepAliveTimeout) {
        this.connectionKeepAliveTimeout = connectionKeepAliveTimeout * 1000;
    }

    public void setMaxKeepAliveRequests(int maxKeepAliveRequests) {
        this.maxKeepAliveRequests = maxKeepAliveRequests;
    }

    public boolean isKeepAlive() {
        return this.isKeepAlive;
    }

    public void setIsKeepAlive(boolean isKeepAlive) {
        this.isKeepAlive = isKeepAlive;
    }

    public String getServerHeader() {
        return this.serverHeader;
    }

    public void setServerHeader(String serverHeader) {
        if (serverHeader != null) {
            this.serverHeader = serverHeader;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setServerHeader: " + serverHeader);
        }
    }

    public void setRemoveServerHeader(boolean YesNo) {
        this.removeServerHeader = YesNo;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setRemoveServerHeader: " + YesNo);
        }
    }

    public boolean isRemoveServerHeader() {
        return this.removeServerHeader;
    }
}

