/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.http.HttpConnection;
import com.ibm.ws.http.HttpTransport;
import com.ibm.ws.http.Logger;
import com.ibm.ws.util.ObjectPool;
import com.ibm.ws.util.ThreadPool;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Properties;

public class HttpServer {
    public static final String MAX_KEEP_ALIVE_CONNECTIONS = "MaxKeepAliveConnections";
    public static final String MAX_KEEP_ALIVE_REQUESTS = "MaxKeepAliveRequests";
    public static final String CONNECTION_IO_TIMEOUT = "ConnectionIOTimeOut";
    public static final String CONNECTION_KEEP_ALIVE_TIMEOUT = "ConnectionKeepAliveTimeOut";
    public static final String ERROR_LOG = "ErrorLog";
    public static final String LOG_LEVEL = "LogLevel";
    public static final String ERROR_LOG_DISABLE = "ErrorLogDisable";
    public static final String ACCESS_LOG_DISABLE = "AccessLogDisable";
    public static final String ACCESS_LOG = "AccessLog";
    public static final String TRACE_NAME = "HTTP_Transport";
    private static TraceComponent tc = Tr.register(HttpServer.class.getName(), "HTTP_Transport");
    private ThreadPool threadPool = null;
    private ObjectPool connectionPool = null;
    private int maxKeepAliveConnections;
    private boolean maxKeepAliveConnectionsSet = false;
    private int connectionKeepAliveCnt;
    public static String errorLog = "http.log";
    public static String logLevel = "warn";
    public static String accessLog = "http_access.log";
    public static PrintWriter accessPw;
    public static PrintWriter errorPw;
    public static boolean errorLogDisable;
    public static boolean accessLogDisable;
    public static boolean debugEnabled;
    public static final int access = 5;
    public static final int debug = 4;
    public static final int info = 3;
    public static final int warn = 2;
    public static final int error = 1;
    public static final int crit = 0;
    private ArrayList transports = new ArrayList();

    public HttpServer(ThreadPool threadPool) {
        this.threadPool = threadPool;
        int maxThreads = threadPool.getMaximumPoolSize();
        if (debugEnabled) {
            Logger.log(4, "HttpServer: Maximum number of threads is " + maxThreads);
        }
        this.connectionPool = new ObjectPool("HTTP connection", maxThreads){

            protected Object createObject() {
                return HttpServer.this.createHttpConnection();
            }
        };
        this.maxKeepAliveConnections = maxThreads * 9 / 10;
        this.connectionKeepAliveCnt = 0;
    }

    public void addTransport(HttpTransport transport) {
        if (debugEnabled) {
            Logger.log(4, "HttpServer: Adding Transport");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addTransport");
        }
        this.transports.add(transport);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addTransport");
        }
    }

    public void shutdown() {
        if (debugEnabled) {
            Logger.log(4, "HttpServer: Shutting Down Transport");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "shutdown");
        }
        while (!this.transports.isEmpty()) {
            HttpTransport transport = (HttpTransport)this.transports.remove(0);
            transport.shutdown(true);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "shutdown");
        }
    }

    public void handleConnection(HttpConnection c) {
        if (debugEnabled) {
            Logger.log(4, "HttpServer: Handling Connection");
        }
        try {
            this.threadPool.execute(c);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpConnection allocateConnection() throws Exception {
        for (int x = 0; x < 100; ++x) {
            HttpConnection c;
            HttpConnection httpConnection = c = (HttpConnection)this.connectionPool.remove();
            synchronized (httpConnection) {
                if (c.isAllocated()) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "HttpConnection.allocateConnection: object in invalid state [" + c + "]");
                    }
                } else {
                    c.setAllocated(true);
                    return c;
                }
                continue;
            }
        }
        throw new Exception("allocateConnection failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean freeConnection(HttpConnection conn) {
        HttpConnection httpConnection = conn;
        synchronized (httpConnection) {
            if (!conn.isAllocated()) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "HttpConnection.freeConnection: object in invalid state [" + conn + "]");
                }
                return true;
            }
            conn.setAllocated(false);
            return !this.connectionPool.add(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allocateKeepAlive() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "allocateKeepAlive: max=" + this.maxKeepAliveConnections);
        }
        if (this.connectionKeepAliveCnt < this.maxKeepAliveConnections) {
            HttpServer httpServer = this;
            synchronized (httpServer) {
                if (this.connectionKeepAliveCnt < this.maxKeepAliveConnections) {
                    ++this.connectionKeepAliveCnt;
                    if (debugEnabled) {
                        Logger.log(4, "HttpServer: Allocate KeepAlive is set to true");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "allocateKeepAlive: count=" + this.connectionKeepAliveCnt);
                    }
                    return true;
                }
            }
        }
        if (debugEnabled) {
            Logger.log(4, "HttpServer: Allocate KeepAlive is set to false");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "allocateKeepAlive: exceeded");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeKeepAlive() {
        if (debugEnabled) {
            Logger.log(4, "HttpServer: Freeing KeepAlive connections");
        }
        HttpServer httpServer = this;
        synchronized (httpServer) {
            --this.connectionKeepAliveCnt;
            if (debugEnabled) {
                Logger.log(4, "HttpServer: Keep Alive Connections = " + new Integer(this.connectionKeepAliveCnt));
            }
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "connectionKeepAliveCnt: count=" + this.connectionKeepAliveCnt);
            }
        }
    }

    public void setThreadPool(ThreadPool threadPool) {
        if (debugEnabled) {
            Logger.log(4, "HttpServer: Setting TreadPool" + threadPool);
        }
        this.threadPool = threadPool;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public int getMaxKeepAliveConnections() {
        return this.maxKeepAliveConnections;
    }

    public void setMaxKeepAliveConnections(String max) {
        if (this.maxKeepAliveConnectionsSet) {
            Tr.warning(tc, "MaxKeepAliveConnections is already set to " + this.maxKeepAliveConnections + "; ignoring " + max);
            if (!errorLogDisable) {
                Logger.log(2, "HTTP0300W MaxKeepAliveConnections is already set to " + this.maxKeepAliveConnections + "; ignoring" + max);
            }
            return;
        }
        this.maxKeepAliveConnections = Integer.parseInt(max);
        if (debugEnabled) {
            Logger.log(4, "HttpServer: Setting Maximum KeepAlive Connections - MaxKeepAliveConnections = " + this.maxKeepAliveConnections);
        }
        this.maxKeepAliveConnectionsSet = true;
    }

    public String getErrorLog() {
        return errorLog;
    }

    public void setErrorLog(String errorlog) {
        errorLog = errorlog;
        if (debugEnabled) {
            Logger.log(4, "HttpServer: Setting ErrorLog - ErrorLog = " + errorLog);
        }
    }

    public String getLogLevel() {
        return logLevel;
    }

    public void setLogLevel(String loglevel) {
        logLevel = loglevel;
        if (debugEnabled) {
            Logger.log(4, "HttpServer: Setting LogLevel - LogLevel = " + logLevel);
        }
    }

    public boolean errorlogdisable() {
        return errorLogDisable;
    }

    public void setErrorLogDisable(boolean errorlogdisable) {
        errorLogDisable = errorlogdisable;
        if (!errorLogDisable) {
            errorPw = Logger.openFile(2);
        }
    }

    public boolean accesslogdisable() {
        return accessLogDisable;
    }

    public void setAccessLogDisable(boolean accesslogdisable) {
        accessLogDisable = accesslogdisable;
        if (!accessLogDisable) {
            accessPw = Logger.openFile(5);
        }
    }

    public String getAccessLog() {
        return accessLog;
    }

    public void setAccessLog(String accesslog) {
        accessLog = accesslog;
        if (debugEnabled) {
            Logger.log(4, "HttpServer: Setting AccessLog - AccessLog = " + accessLog);
        }
    }

    protected HttpConnection createHttpConnection() {
        if (!errorLogDisable) {
            Logger.log(3, "HTTP0100I Creating HTTP Connection");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createHttpConnection");
        }
        return new HttpConnection();
    }

    public static void main(String[] args) {
        Properties httpServerProps = new Properties();
        Properties httpTransportProps = new Properties();
        httpTransportProps.put("type", "HTTP");
        httpTransportProps.put("port", "80");
        try {
            HttpServer httpServer = new HttpServer(new ThreadPool("HttpServer", 5, 20));
            HttpTransport transport = new HttpTransport();
            transport.initialize(httpServer, null);
        }
        catch (Exception e) {
            if (!errorLogDisable) {
                Logger.log(0, "HTTP0102C Could not initialize");
            }
            e.printStackTrace();
        }
    }

    static {
        errorLogDisable = true;
        accessLogDisable = true;
        debugEnabled = false;
    }
}

