/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.util.CharBuffer;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class HttpInputStream
extends FilterInputStream {
    private static final int defaultBufferSize = 2048;
    private static TraceComponent tc = Tr.register(HttpInputStream.class.getName(), "HTTP_Transport");
    protected byte[] buf;
    protected int count;
    protected int pos;
    protected int markpos = -1;
    protected int marklimit;

    public HttpInputStream(InputStream in) {
        this(in, 2048);
    }

    public HttpInputStream(InputStream in, int size) {
        super(in);
        this.buf = new byte[size];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "size of input stream", new Integer(size));
        }
    }

    public HttpInputStream() {
        this(null);
    }

    public void init(InputStream is) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "init");
        }
        this.in = is;
        this.pos = 0;
        this.markpos = -1;
        this.marklimit = 0;
    }

    public void destroy() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "destroy");
        }
        this.in = null;
    }

    private boolean fill() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fill");
        }
        if (this.markpos < 0) {
            this.pos = 0;
        } else if (this.pos >= this.buf.length) {
            if (this.markpos > 0) {
                int sz = this.pos - this.markpos;
                System.arraycopy(this.buf, this.markpos, this.buf, 0, sz);
                this.pos = sz;
                this.markpos = 0;
            } else if (this.buf.length >= this.marklimit) {
                this.markpos = -1;
                this.pos = 0;
            } else {
                int nsz = this.pos * 2;
                if (nsz > this.marklimit) {
                    nsz = this.marklimit;
                }
                byte[] nbuf = new byte[nsz];
                System.arraycopy(this.buf, 0, nbuf, 0, this.pos);
                this.buf = nbuf;
            }
        }
        this.count = this.pos;
        int n = this.in.read(this.buf, this.pos, this.buf.length - this.pos);
        if (n > 0) {
            this.count = n + this.pos;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fill", new Integer(n));
        }
        return n > 0;
    }

    public int read() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "read");
        }
        if (this.pos >= this.count) {
            this.fill();
            if (this.pos >= this.count && tc.isEntryEnabled()) {
                Tr.exit(tc, "read", new Integer(-1));
            }
            return -1;
        }
        int rtn = this.buf[this.pos++] & 0xFF;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "read", new Integer(rtn));
        }
        return rtn;
    }

    private int read1(byte[] b, int off, int len) throws IOException {
        int avail = this.count - this.pos;
        if (avail <= 0) {
            if (len >= this.buf.length && this.markpos < 0) {
                return this.in.read(b, off, len);
            }
            this.fill();
            avail = this.count - this.pos;
            if (avail <= 0) {
                return -1;
            }
        }
        int cnt = avail < len ? avail : len;
        System.arraycopy(this.buf, this.pos, b, off, cnt);
        this.pos += cnt;
        return cnt;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int n1;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "read");
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "read", new Integer(0));
            }
            return 0;
        }
        int n = this.read1(b, off, len);
        if (n <= 0) {
            return n;
        }
        while (n < len && this.in.available() > 0 && (n1 = this.read1(b, off + n, len - n)) > 0) {
            n += n1;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "read", new Integer(n));
        }
        return n;
    }

    public long skip(long n) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "skip", new Long(n));
        }
        if (n <= 0L) {
            return 0L;
        }
        long avail = this.count - this.pos;
        if (avail <= 0L) {
            if (this.markpos < 0) {
                return this.in.skip(n);
            }
            this.fill();
            avail = this.count - this.pos;
            if (avail <= 0L) {
                return 0L;
            }
        }
        long skipped = avail < n ? avail : n;
        this.pos = (int)((long)this.pos + skipped);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "skip", new Long(skipped));
        }
        return skipped;
    }

    public int available() throws IOException {
        int rtn = this.count - this.pos + this.in.available();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "available", new Integer(rtn));
        }
        return rtn;
    }

    public void mark(int readlimit) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "mark", new Integer(readlimit));
        }
        this.marklimit = readlimit;
        this.markpos = this.pos;
    }

    public void reset() throws IOException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "reset");
        }
        if (this.markpos < 0) {
            throw new IOException("Resetting to invalid mark");
        }
        this.pos = this.markpos;
    }

    public boolean markSupported() {
        return true;
    }

    public void close() throws IOException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "close");
        }
        this.in.close();
        this.in = null;
        this.buf = null;
    }

    public void unread(int ch) throws IOException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "unread", new Integer(ch));
        }
        if (this.pos == 0) {
            throw new IOException("Buffer is full");
        }
        this.buf[--this.pos] = (byte)ch;
    }

    public boolean readLine(CharBuffer cbuf, int maxLength, boolean fold) throws IOException, ArrayIndexOutOfBoundsException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readLine", new Object[]{new Integer(maxLength), new Boolean(fold)});
        }
        int capacity = cbuf.capacity();
        int offset = cbuf.length();
        char[] cBuffer = cbuf.getValue();
        while (true) {
            int sublen;
            if ((sublen = this.count - this.pos) > capacity - offset) {
                sublen = capacity - offset;
            }
            while (sublen > 0) {
                int ch;
                if ((ch = this.buf[this.pos++] & 0xFF) == 10) {
                    if (offset > 0 && cBuffer[offset - 1] == '\r') {
                        cbuf.setLength(offset - 1);
                    } else {
                        cbuf.setLength(offset);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "readLine", "true");
                    }
                    return true;
                }
                cBuffer[offset++] = (char)ch;
                --sublen;
            }
            if (this.pos >= this.count && !this.fill()) {
                cbuf.setLength(offset);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "readLine", new Integer(offset));
                }
                return offset > 0;
            }
            if (offset < capacity) continue;
            cbuf.setLength(offset + 1);
            capacity = cbuf.capacity();
            cBuffer = cbuf.getValue();
        }
    }
}

