/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.http.HttpConnection;
import com.ibm.ws.io.Stream;
import java.io.IOException;
import java.io.InputStream;

public class ContentLengthInputStream
extends Stream {
    protected int length;
    private int remaining = -1;
    private HttpConnection conn = null;
    private static TraceComponent tc = Tr.register(ContentLengthInputStream.class.getName(), "HTTP_Transport");

    public ContentLengthInputStream(HttpConnection c) {
        this.conn = c;
    }

    public void init(InputStream is, int len) {
        super.init(is, null);
        this.remaining = this.length = len;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "init", new Integer(len));
        }
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        int len = 0;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "read", new Object[]{new Integer(offset), new Integer(length)});
        }
        if (length > this.length) {
            length = this.length;
        }
        if (length <= 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "read", "-1");
            }
            return -1;
        }
        try {
            len = this.is.read(buffer, offset, length);
            if (len > 0) {
                this.length -= len;
                this.remaining -= len;
            } else {
                this.length = -1;
            }
        }
        catch (IOException ioe) {
            this.conn.setshouldStayAlive(false);
            throw ioe;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "read", new Integer(len));
        }
        return len;
    }

    public int available() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "available", new Integer(this.length));
        }
        return this.length;
    }

    public void close() throws IOException {
        byte[] buffer = null;
        if (this.remaining > 0) {
            buffer = new byte[8192];
        }
        while (this.remaining > 0) {
            int len = this.is.read(buffer);
            if (len <= 0) continue;
            this.remaining -= len;
        }
        super.close();
    }
}

