/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.http.HttpRequest;
import com.ibm.ws.io.Stream;
import java.io.IOException;
import java.io.InputStream;

public class ChunkedInputStream
extends Stream {
    protected HttpRequest request;
    protected int chunkSize;
    private static TraceComponent tc = Tr.register(ChunkedInputStream.class.getName(), "HTTP_Transport");

    public void init(HttpRequest req, InputStream in) {
        super.init(in, null);
        this.request = req;
        this.chunkSize = 0;
    }

    public int read(byte[] buf, int offset, int len) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "read", new Object[]{buf, new Integer(offset), new Integer(len)});
        }
        try {
            if (this.chunkSize > 0) {
                if (this.chunkSize < len) {
                    len = this.chunkSize;
                }
                if ((len = this.is.read(buf, offset, len)) > 0) {
                    this.chunkSize -= len;
                }
            } else if (this.chunkSize == 0) {
                this.chunkSize = this.readChunkLength();
                if (this.chunkSize > 0) {
                    if (this.chunkSize < len) {
                        len = this.chunkSize;
                    }
                    if ((len = this.is.read(buf, offset, len)) > 0) {
                        this.chunkSize -= len;
                    }
                } else {
                    this.chunkSize = -1;
                    len = -1;
                }
            } else {
                len = -1;
            }
        }
        catch (IOException ioe) {
            this.request.getHttpConnection().setshouldStayAlive(false);
            throw ioe;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "read", new Integer(len));
        }
        return len;
    }

    private int readChunkLength() throws IOException {
        int ch;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readChunkLength");
        }
        int length = 0;
        while ((ch = this.is.read()) == 13 || ch == 10) {
        }
        while (ch > 0 && ch != 13 && ch != 10 && ch != 59) {
            if (ch >= 48 && ch <= 57) {
                length = 16 * length + ch - 48;
            } else if (ch >= 97 && ch <= 102) {
                length = 16 * length + ch - 97 + 10;
            } else if (ch >= 65 && ch <= 70) {
                length = 16 * length + ch - 65 + 10;
            } else if (ch != 32 && ch != 9) {
                throw new IOException("HTTP/1.1 protocol error: bad chunk");
            }
            ch = this.is.read();
        }
        if (ch == 13) {
            ch = this.is.read();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readChunkLength", new Integer(length));
        }
        return length;
    }

    public void close() throws IOException {
        byte[] buffer = null;
        if (this.chunkSize != -1) {
            buffer = new byte[8192];
        }
        while (this.chunkSize != -1) {
            int len = buffer.length;
            if (this.chunkSize < len) {
                len = this.chunkSize;
            }
            if ((len = this.is.read(buffer)) > 0) {
                this.chunkSize -= len;
            }
            if (this.chunkSize != 0) continue;
            this.chunkSize = this.readChunkLength();
        }
        super.close();
    }

    public int available() throws IOException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "available", new Integer(this.chunkSize));
        }
        return this.chunkSize;
    }
}

