/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.genericbnf.impl;

public class Normalizer {
    public static final int NORMALIZE_OFF = 0;
    public static final int NORMALIZE_UPPER = 1;
    public static final int NORMALIZE_LOWER = 2;
    private int normalizeFlag = 0;

    public Normalizer(int flag) {
        if (0 != flag && 1 != flag && 2 != flag) {
            throw new IllegalArgumentException("Unable to create Normalizer using identifier " + flag);
        }
        this.normalizeFlag = flag;
    }

    public final int getNormalization() {
        return this.normalizeFlag;
    }

    public String normalize(String path) {
        if (0 == this.getNormalization() || null == path) {
            return path;
        }
        String normalizedString = path;
        int len = path.length();
        if (0 != len) {
            char[] buf = new char[len];
            path.getChars(0, len, buf, 0);
            for (int index = 0; index < len; ++index) {
                buf[index] = this.normalize(buf[index]);
            }
            normalizedString = new String(buf, 0, len);
        }
        return normalizedString;
    }

    public String normalize(byte[] data) {
        if (null == data) {
            return null;
        }
        if (0 == data.length) {
            return "";
        }
        if (0 == this.getNormalization()) {
            return new String(data);
        }
        char[] buf = new char[data.length];
        for (int index = 0; index < data.length; ++index) {
            buf[index] = this.normalize((char)data[index]);
        }
        return new String(buf, 0, buf.length);
    }

    public char normalize(char currentChar) {
        if (1 == this.getNormalization()) {
            return Normalizer.toUpper(currentChar);
        }
        if (2 == this.getNormalization()) {
            return Normalizer.toLower(currentChar);
        }
        return currentChar;
    }

    private static char toUpper(char c) {
        if (c >= 'a' && c <= 'z') {
            c = (char)(c - 97 + 65);
        }
        return c;
    }

    private static char toLower(char c) {
        if (c >= 'A' && c <= 'Z') {
            c = (char)(c - 65 + 97);
        }
        return c;
    }

    public static String normalize(byte[] data, int format) {
        if (null == data) {
            return null;
        }
        if (0 == data.length) {
            return "";
        }
        if (0 == format) {
            return new String(data);
        }
        char[] buf = new char[data.length];
        for (int index = 0; index < data.length; ++index) {
            buf[index] = Normalizer.normalize((char)data[index], format);
        }
        return new String(buf, 0, buf.length);
    }

    public static char normalize(char input, int format) {
        if (2 == format) {
            return Normalizer.toLower(input);
        }
        if (1 == format) {
            return Normalizer.toUpper(input);
        }
        return input;
    }

    public static String normalize(String path, int format) {
        if (0 == format || null == path) {
            return path;
        }
        String normalizedString = path;
        int len = path.length();
        if (0 != len) {
            char[] buf = new char[len];
            path.getChars(0, len, buf, 0);
            for (int index = 0; index < len; ++index) {
                buf[index] = Normalizer.normalize(buf[index], format);
            }
            normalizedString = new String(buf, 0, len);
        }
        return normalizedString;
    }
}

