/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.genericbnf.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.genericbnf.impl.Normalizer;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.genericbnf.HeaderStorage;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderHandler {
    private static final TraceComponent tc = Tr.register(HeaderHandler.class, "GenericBNF", "com.ibm.ws.genericbnf.resources.genericbnfMessages");
    private char mySep = (char)44;
    private int num_items = 0;
    private Map<String, List<String>> values = new Hashtable<String, List<String>>(5);
    private List<String> genericValues = new LinkedList<String>();
    private String headerName = null;

    public HeaderHandler(HeaderStorage msg, char sep, String name) {
        this.headerName = name;
        this.mySep = sep;
        int count = msg.getNumberOfHeaderInstances(name);
        for (int i = 0; i < count; ++i) {
            this.parse(msg.getHeaderAsString(name, i));
        }
    }

    public HeaderHandler(HeaderStorage msg, char sep, HeaderKeys name) {
        this.headerName = name.getName();
        this.mySep = sep;
        int count = msg.getNumberOfHeaderInstances(name);
        for (int i = 0; i < count; ++i) {
            this.parse(msg.getHeaderAsString(name, i));
        }
    }

    private void addElement(String value) {
        if (null == value) {
            return;
        }
        ++this.num_items;
        this.genericValues.add(value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "addElement: " + value + " num: " + this.num_items);
        }
    }

    private void addElement(String key, String value) {
        ++this.num_items;
        List<String> vals = this.values.get(key);
        if (null == vals) {
            vals = new LinkedList<String>();
        }
        if (null == value) {
            vals.add("\"\"");
        } else {
            vals.add(value);
        }
        this.values.put(key, vals);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "addElement: " + key + "=" + value + " num: " + this.num_items);
        }
    }

    private void parse(String input) {
        char[] data = input.toCharArray();
        int start = 0;
        int hard_stop = data.length - 1;
        block0: while (start < data.length) {
            if (this.mySep == data[start]) {
                ++start;
                continue;
            }
            int end = start;
            String key = null;
            boolean insideQuotes = false;
            while (end < data.length) {
                boolean extract = false;
                if ('\"' == data[end]) {
                    insideQuotes = !insideQuotes;
                } else if (this.mySep == data[end]) {
                    extract = true;
                    --end;
                } else if ('=' == data[end]) {
                    key = this.extractString(data, start, end - 1);
                    start = ++end;
                    continue;
                }
                if (end == hard_stop) {
                    extract = true;
                }
                if (extract) {
                    String value = this.extractString(data, start, end);
                    if (null == key) {
                        this.addElement(value);
                    } else {
                        this.addElement(key, value);
                    }
                    start = end += 2;
                    if (insideQuotes) continue;
                    continue block0;
                }
                ++end;
            }
        }
    }

    private String extractString(char[] data, int start, int end) {
        while (start < end && (' ' == data[start] || '\t' == data[start] || '\"' == data[start])) {
            ++start;
        }
        while (end >= start && (' ' == data[end] || '\t' == data[end] || '\"' == data[end])) {
            --end;
        }
        if (end < start) {
            return null;
        }
        int len = end - start + 1;
        String rc = Normalizer.normalize(new String(data, start, len), 2);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "extractString: [" + rc + "]");
        }
        return rc;
    }

    public boolean add(String inputValue) {
        String value = Normalizer.normalize(inputValue, 2);
        if (!this.contains(this.genericValues, value)) {
            this.addElement(value);
            return true;
        }
        return false;
    }

    public boolean add(String inputKey, String inputValue) {
        String key = Normalizer.normalize(inputKey, 2);
        String value = Normalizer.normalize(inputValue, 2);
        if (!this.contains(this.values.get(key), value)) {
            this.addElement(key, value);
            return true;
        }
        return false;
    }

    private boolean remove(List<String> list, String item) {
        if (null != list && list.remove(item)) {
            --this.num_items;
            return true;
        }
        return false;
    }

    public boolean remove(String inputKey, String inputValue) {
        String key = Normalizer.normalize(inputKey, 2);
        String value = Normalizer.normalize(inputValue, 2);
        boolean rc = this.remove(this.values.get(key), value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "remove: " + key + "=" + value + " rc=" + rc);
        }
        return rc;
    }

    public boolean remove(String inputValue) {
        String value = Normalizer.normalize(inputValue, 2);
        boolean rc = this.remove(this.genericValues, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "remove: " + value + " rc=" + rc);
        }
        return rc;
    }

    public int removeKey(String inputKey) {
        String key = Normalizer.normalize(inputKey, 2);
        int num_removed = 0;
        List<String> vals = this.values.remove(key);
        if (null != vals) {
            num_removed = vals.size();
        }
        this.num_items -= num_removed;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "removeKey: key=" + key + " " + num_removed);
        }
        return num_removed;
    }

    private boolean contains(List<String> list, String item) {
        return null == list ? false : list.contains(item);
    }

    public boolean contains(String inputValue) {
        String value = Normalizer.normalize(inputValue, 2);
        boolean rc = this.contains(this.genericValues, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "contains: value [" + inputValue + "] rc=" + rc);
        }
        return rc;
    }

    public boolean containsKey(String inputKey) {
        boolean rc;
        String key = Normalizer.normalize(inputKey, 2);
        List<String> list = this.values.get(key);
        boolean bl = null == list ? false : (rc = !list.isEmpty());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "containsKey: key=" + inputKey + " rc=" + rc);
        }
        return rc;
    }

    public boolean contains(String inputKey, String inputValue) {
        String key = Normalizer.normalize(inputKey, 2);
        String value = Normalizer.normalize(inputValue, 2);
        boolean rc = this.contains(this.values.get(key), value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "contains: " + inputKey + "=" + inputValue + " rc=" + rc);
        }
        return rc;
    }

    public Iterator<String> getValues() {
        return this.genericValues.iterator();
    }

    public Iterator<String> getValues(String inputKey) {
        String key = Normalizer.normalize(inputKey, 2);
        List<String> vals = this.values.get(key);
        if (null != vals) {
            return vals.iterator();
        }
        return new LinkedList().iterator();
    }

    public String marshall() {
        if (0 == this.num_items) {
            return "";
        }
        boolean shouldPrepend = false;
        StringBuilder output = new StringBuilder(10 * this.num_items);
        Iterator<String> i = this.genericValues.iterator();
        while (i.hasNext()) {
            if (shouldPrepend) {
                output.append(this.mySep);
                output.append(' ');
            }
            output.append(i.next());
            shouldPrepend = true;
        }
        for (String key : this.values.keySet()) {
            List<String> vals = this.values.get(key);
            int size = null == vals ? 0 : vals.size();
            if (0 == size) continue;
            if (shouldPrepend) {
                output.append(this.mySep);
                output.append(' ');
            }
            output.append(key);
            output.append('=');
            if (1 == size) {
                output.append(vals.get(0));
            } else {
                shouldPrepend = false;
                output.append('\"');
                for (int count = 0; count < size; ++count) {
                    if (shouldPrepend) {
                        output.append(this.mySep);
                        output.append(' ');
                    }
                    output.append(vals.get(count));
                    shouldPrepend = true;
                }
                output.append('\"');
            }
            shouldPrepend = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "marshalling [" + output.toString() + "]");
        }
        return output.toString();
    }

    public int numValues() {
        return this.num_items;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void clear() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Clearing this header handler: " + this);
        }
        this.num_items = 0;
        this.values.clear();
        this.genericValues.clear();
    }

    public String toString() {
        return super.toString() + "; num items=" + this.numValues();
    }
}

