/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.genericbnf.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.genericbnf.impl.BNFHeadersImpl;
import com.ibm.ws.genericbnf.impl.GenericUtils;
import com.ibm.ws.http.channel.impl.HttpDateFormat;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import java.nio.BufferUnderflowException;
import java.text.ParseException;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderElement
implements Comparable<HeaderElement> {
    private static final TraceComponent tc = Tr.register(HeaderElement.class, "GenericBNF", "com.ibm.ws.genericbnf.resources.genericbnfMessages");
    private static final int initHash = 629;
    private static final int ELEM_INIT = 0;
    private static final int ELEM_CHANGED = 1;
    private static final int ELEM_REMOVED = 2;
    private static final int ELEM_ADDED = 3;
    HeaderElement nextInstance = null;
    HeaderElement nextSequence = null;
    HeaderElement prevSequence = null;
    private HeaderKeys keyName = null;
    private int buffIndex = -1;
    private int offset = 0;
    private int valueLength = 0;
    private byte[] bValue = null;
    private String sValue = null;
    private BNFHeadersImpl myOwner;
    private int myHashCode = -1;
    private int status = 3;
    private int lastCRLFBufferIndex = -1;
    private int lastCRLFPosition = -1;
    private boolean lastCRLFisCR = false;

    HeaderElement(HeaderKeys header, BNFHeadersImpl owner) {
        this.keyName = header;
        this.myOwner = owner;
    }

    public HeaderKeys getHeaderKey() {
        return this.keyName;
    }

    public void setParseInformation(int index, int start) {
        this.buffIndex = index;
        this.offset = start;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Set parse information " + this.buffIndex + " " + this.offset);
        }
    }

    public void setValueLength(int len) {
        this.valueLength = len;
    }

    public int getValueLength() {
        return this.valueLength;
    }

    public int getOffset() {
        return this.offset;
    }

    private boolean extractInitialValue() {
        if (-1 == this.buffIndex) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Extract: -1 index");
            }
            return false;
        }
        this.bValue = new byte[this.valueLength];
        WsByteBuffer buff = this.myOwner.getParseBuffer(this.buffIndex);
        int savePosition = buff.position();
        try {
            buff.position(this.offset);
            buff.get(this.bValue, 0, this.valueLength);
            buff.position(savePosition);
        }
        catch (BufferUnderflowException bue) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Header value straddled buffers");
            }
            int lengthNeeded = this.valueLength;
            int arrayOffset = 0;
            buff.position(this.offset);
            int spaceLeftInBuffer = buff.remaining();
            int index = this.buffIndex + 1;
            while (true) {
                if (lengthNeeded <= spaceLeftInBuffer) {
                    buff.get(this.bValue, arrayOffset, lengthNeeded);
                    buff.position(savePosition);
                    break;
                }
                buff.get(this.bValue, arrayOffset, spaceLeftInBuffer);
                buff.position(savePosition);
                lengthNeeded -= spaceLeftInBuffer;
                arrayOffset += spaceLeftInBuffer;
                buff = this.myOwner.getParseBuffer(index);
                ++index;
                savePosition = buff.position();
                buff.position(0);
                spaceLeftInBuffer = buff.limit();
            }
        }
        this.offset = 0;
        this.buffIndex = -1;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            this.sValue = GenericUtils.getEnglishString(this.bValue);
            Tr.debug(tc, "extractInitialValue parsed [" + this.getDebugValue() + "]");
        }
        return true;
    }

    public byte[] getByteArrayValue() {
        if (null == this.bValue) {
            if (null != this.sValue) {
                this.bValue = GenericUtils.getEnglishBytes(this.sValue);
            } else if (!this.extractInitialValue() && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "byte[] value requested from empty structure");
            }
        } else if (this.valueLength != this.bValue.length) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Extracting value from larger input array");
            }
            byte[] temp = new byte[this.valueLength];
            System.arraycopy(this.bValue, this.offset, temp, 0, temp.length);
            this.bValue = temp;
            this.offset = 0;
            this.valueLength = temp.length;
        }
        return this.bValue;
    }

    public byte[] getRawByteArrayValue() {
        if (null == this.bValue) {
            if (null != this.sValue) {
                this.bValue = GenericUtils.getEnglishBytes(this.sValue);
            } else if (!this.extractInitialValue() && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "no byte[] value present");
            }
        }
        return this.bValue;
    }

    public String getStringValue() {
        if (null == this.sValue) {
            if (null == this.bValue && !this.extractInitialValue()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "String value requested from empty structure");
                }
                return null;
            }
            this.sValue = GenericUtils.getEnglishString(this.bValue, this.offset, this.offset + this.valueLength);
        }
        return this.sValue;
    }

    public String getDebugValue() {
        if (this.keyName.shouldLogValue()) {
            return this.getStringValue();
        }
        return GenericUtils.blockContents(this.getStringValue());
    }

    public Date asDate() throws ParseException {
        return HttpDateFormat.getRef().parseTime(this.getStringValue());
    }

    public Integer asInteger() {
        return new Integer(this.getStringValue().trim());
    }

    public void setByteArrayValue(byte[] input) {
        this.sValue = null;
        this.bValue = input;
        this.offset = 0;
        this.valueLength = input.length;
        if (3 != this.status) {
            this.status = 1;
        }
    }

    public void setByteArrayValue(byte[] input, int offset, int length) {
        if (offset + length > input.length) {
            throw new IllegalArgumentException("Invalid length: " + offset + "+" + length + " > " + input.length);
        }
        this.sValue = null;
        this.bValue = input;
        this.offset = offset;
        this.valueLength = length;
        if (3 != this.status) {
            this.status = 1;
        }
    }

    public void setStringValue(String input) {
        this.bValue = null;
        this.sValue = input;
        this.offset = 0;
        int n = this.valueLength = null == input ? 0 : input.length();
        if (3 != this.status) {
            this.status = 1;
        }
    }

    public boolean equals(Object inElem) {
        if (this == inElem) {
            return true;
        }
        if (!(inElem instanceof HeaderElement)) {
            return false;
        }
        return this.keyName.equals(((HeaderElement)inElem).getHeaderKey());
    }

    public boolean isSameName(HeaderElement elem) {
        return this.keyName.getOrdinal() == elem.keyName.getOrdinal();
    }

    public boolean isSameValue(HeaderElement elem) {
        return this.getStringValue().equals(elem.getStringValue());
    }

    public boolean isSameValueIgnoreCase(HeaderElement elem) {
        return this.getStringValue().equalsIgnoreCase(elem.getStringValue());
    }

    public int hashCode() {
        if (-1 == this.myHashCode) {
            this.myHashCode = 629 + this.keyName.hashCode();
        }
        return this.myHashCode;
    }

    @Override
    public int compareTo(HeaderElement o) {
        if (this == o) {
            return 0;
        }
        return this.hashCode() - o.hashCode();
    }

    public boolean wasRemoved() {
        return 2 == this.status;
    }

    public boolean wasChanged() {
        return 1 == this.status;
    }

    public boolean wasAdded() {
        return 3 == this.status;
    }

    public void remove() {
        if (2 != this.status) {
            this.status = 2;
            this.myOwner.decrementHeaderCounter();
        }
    }

    public void startTracking() {
        this.status = 0;
    }

    protected void updateLastCRLFInfo(int index, int pos, boolean isCR) {
        this.lastCRLFBufferIndex = index;
        this.lastCRLFPosition = pos;
        this.lastCRLFisCR = isCR;
    }

    protected int getLastCRLFPosition() {
        return this.lastCRLFPosition;
    }

    protected int getLastCRLFBufferIndex() {
        return this.lastCRLFBufferIndex;
    }

    protected boolean isLastCRLFaCR() {
        return this.lastCRLFisCR;
    }

    public String getName() {
        return this.keyName.getName();
    }

    public void destroy() {
        this.nextSequence = null;
        this.prevSequence = null;
        this.bValue = null;
        this.sValue = null;
        this.buffIndex = -1;
        this.offset = 0;
        this.valueLength = 0;
        this.myHashCode = -1;
        this.lastCRLFBufferIndex = -1;
        this.lastCRLFisCR = false;
        this.lastCRLFPosition = -1;
        this.status = 3;
        this.myOwner.freeElement(this);
    }

    public void init(HeaderKeys key) {
        this.keyName = key;
    }

    public String toString() {
        return "HeaderElement name=" + this.getName() + " status=" + this.status;
    }
}

