/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.jitdeploy;

import com.ibm.ejs.container.EJBConfigurationException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.jitdeploy.CORBA_Utils;
import com.ibm.ws.ejbcontainer.jitdeploy.JITUtils;
import com.ibm.ws.ejbcontainer.jitdeploy.RMItoIDL;
import java.lang.reflect.Modifier;
import java.rmi.Remote;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public final class JIT_Stub {
    private static final String CLASS_NAME = JIT_Stub.class.getName();
    private static final TraceComponent tc = Tr.register(CLASS_NAME, "JITDeploy", "com.ibm.ejs.container.container");

    public static String getRemoteInterfaceName(String stubClassName) {
        if (stubClassName != null && stubClassName.endsWith("_Stub")) {
            StringBuilder nameBuilder = new StringBuilder(stubClassName);
            nameBuilder.setLength(nameBuilder.length() - 5);
            int packageOffset = nameBuilder.lastIndexOf(".") + 1;
            if (nameBuilder.charAt(packageOffset) != '_') {
                return null;
            }
            nameBuilder.deleteCharAt(packageOffset);
            return nameBuilder.toString();
        }
        return null;
    }

    public static byte[] generateStubBytes(Class remoteInterface) throws EJBConfigurationException {
        String stubClassName = JIT_Stub.getStubClassName(remoteInterface.getName());
        java.lang.reflect.Method[] remoteMethods = remoteInterface.getMethods();
        String[] idlNames = RMItoIDL.getIdlMethodNames(remoteMethods);
        byte[] classBytes = JIT_Stub.generateClassBytes(stubClassName, remoteInterface, remoteMethods, idlNames);
        return classBytes;
    }

    static String getStubClassName(String remoteInterfaceName) {
        StringBuilder stubBuilder = new StringBuilder(remoteInterfaceName);
        int packageOffset = stubBuilder.lastIndexOf(".") + 1;
        stubBuilder.insert(packageOffset, '_');
        stubBuilder.append("_Stub");
        return stubBuilder.toString();
    }

    static byte[] generateClassBytes(String stubClassName, Class remoteInterface, java.lang.reflect.Method[] remoteMethods, String[] idlNames) throws EJBConfigurationException {
        int numMethods = remoteMethods.length;
        String internalStubClassName = JITUtils.convertClassName(stubClassName);
        String internalInterfaceName = JITUtils.convertClassName(remoteInterface.getName());
        if (!Modifier.isInterface(remoteInterface.getModifiers())) {
            throw new EJBConfigurationException("The " + remoteInterface.getName() + " class is not an interface class. " + "Stubs may only be generated for interface classes.");
        }
        boolean isRmiRemote = Remote.class.isAssignableFrom(remoteInterface);
        String[] remoteInterfaceNames = isRmiRemote ? new String[]{internalInterfaceName} : new String[]{internalInterfaceName, "java/rmi/Remote"};
        if (TraceComponent.isAnyTracingEnabled()) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "generateClassBytes");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "     className = " + internalStubClassName);
                Tr.debug(tc, "     interface = " + internalInterfaceName);
                if (isRmiRemote) {
                    Tr.debug(tc, "     implements java.rmi.Remote");
                }
            }
        }
        ClassWriter cw = new ClassWriter(true);
        cw.visit(46, 33, internalStubClassName, null, "javax/rmi/CORBA/Stub", remoteInterfaceNames);
        String sourceFileName = stubClassName.substring(stubClassName.lastIndexOf(".") + 1) + ".java";
        cw.visitSource(sourceFileName, null);
        JIT_Stub.addFields(cw);
        JIT_Stub.initializeStaticFields(cw, internalStubClassName, remoteInterface);
        JIT_Stub.addCtor(cw);
        JIT_Stub.addCommonStubMethods(cw, internalStubClassName);
        for (int i = 0; i < numMethods; ++i) {
            JIT_Stub.addStubMethod(cw, internalStubClassName, remoteMethods[i], idlNames[i], isRmiRemote);
        }
        cw.visitEnd();
        byte[] classBytes = cw.toByteArray();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            JITUtils.writeToClassFile(internalStubClassName, classBytes);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "generateClassBytes: " + classBytes.length + " bytes");
        }
        return classBytes;
    }

    private static void addFields(ClassWriter cw) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "     adding field : _type_ids [Ljava/lang/String;");
        }
        FieldVisitor fv = cw.visitField(26, "_type_ids", "[Ljava/lang/String;", null, null);
        fv.visitEnd();
    }

    private static void initializeStaticFields(ClassWriter cw, String stubClassName, Class remoteInterface) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "     adding method : <clinit> ()V");
        }
        Method m = new Method("<clinit>", Type.VOID_TYPE, new Type[0]);
        GeneratorAdapter mg = new GeneratorAdapter(8, m, null, null, (ClassVisitor)cw);
        mg.visitCode();
        String[] remoteTypes = CORBA_Utils.getRemoteTypeIds(remoteInterface);
        mg.push(remoteTypes.length);
        mg.visitTypeInsn(189, "java/lang/String");
        for (int i = 0; i < remoteTypes.length; ++i) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "        _type_ids = " + remoteTypes[i]);
            }
            mg.visitInsn(89);
            mg.push(i);
            mg.visitLdcInsn((Object)remoteTypes[i]);
            mg.visitInsn(83);
        }
        mg.visitFieldInsn(179, stubClassName, "_type_ids", "[Ljava/lang/String;");
        mg.visitInsn(177);
        mg.endMethod();
        mg.visitEnd();
    }

    private static void addCtor(ClassWriter cw) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "     adding method : <init> ()V");
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "javax/rmi/CORBA/Stub", "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private static void addCommonStubMethods(ClassWriter cw, String stubClassName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "     adding method : _ids ()[Ljava/lang/String;");
        }
        MethodVisitor mv = cw.visitMethod(1, "_ids", "()[Ljava/lang/String;", null, null);
        mv.visitCode();
        mv.visitFieldInsn(178, stubClassName, "_type_ids", "[Ljava/lang/String;");
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "     adding method : class$ (Ljava/lang/String;)Ljava/lang/Class;");
        }
        mv = cw.visitMethod(4104, "class$", "(Ljava/lang/String;)Ljava/lang/Class;", null, null);
        mv.visitCode();
        Label try_begin = new Label();
        mv.visitLabel(try_begin);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
        mv.visitInsn(176);
        Label try_end = new Label();
        mv.visitLabel(try_end);
        mv.visitVarInsn(58, 1);
        mv.visitTypeInsn(187, "java/lang/NoClassDefFoundError");
        mv.visitInsn(89);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, "java/lang/Throwable", "getMessage", "()Ljava/lang/String;");
        mv.visitMethodInsn(183, "java/lang/NoClassDefFoundError", "<init>", "(Ljava/lang/String;)V");
        mv.visitInsn(191);
        mv.visitTryCatchBlock(try_begin, try_end, try_end, "java/lang/ClassNotFoundException");
        mv.visitMaxs(3, 2);
        mv.visitEnd();
    }

    private static void addStubMethod(ClassWriter cw, String className, java.lang.reflect.Method method, String idlName, boolean isRmiRemote) throws EJBConfigurationException {
        int i;
        String methodName = method.getName();
        String methodSignature = JITUtils.jdiMethodSignature(method);
        Class<?> declaringClass = method.getDeclaringClass();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "     adding method : " + methodName + " " + methodSignature);
        }
        Class[] methodExceptions = method.getExceptionTypes();
        Class[] checkedExceptions = JITUtils.getCheckedExceptions(method, isRmiRemote, false);
        Class[] methodParameters = method.getParameterTypes();
        Class<?> returnClass = method.getReturnType();
        Type returnType = Type.getType(returnClass);
        Type[] argTypes = JITUtils.getTypes(methodParameters);
        Type[] exceptionTypes = JITUtils.getTypes(methodExceptions);
        Type[] checkedTypes = JITUtils.getTypes(checkedExceptions);
        Type declaringType = Type.getType(declaringClass);
        String declaringName = JITUtils.convertClassName(declaringClass.getName());
        int numArgs = methodParameters.length;
        Method m = new Method(methodName, returnType, argTypes);
        GeneratorAdapter mg = new GeneratorAdapter(1, m, null, exceptionTypes, (ClassVisitor)cw);
        mg.visitCode();
        int servantObj = mg.newLocal(CORBA_Utils.TYPE_CORBA_ServantObject);
        Label do_while_begin = new Label();
        mg.visitLabel(do_while_begin);
        mg.loadThis();
        mg.visitMethodInsn(184, "javax/rmi/CORBA/Util", "isLocal", "(Ljavax/rmi/CORBA/Stub;)Z");
        Label while_not_local_end = new Label();
        mg.visitJumpInsn(154, while_not_local_end);
        Type inputStreamType = CORBA_Utils.TYPE_CORBA_2_3_InputStream;
        int inputstream = mg.newLocal(inputStreamType);
        mg.visitInsn(1);
        mg.storeLocal(inputstream);
        Label not_local_try_begin = new Label();
        mg.visitLabel(not_local_try_begin);
        Type outputStreamType = CORBA_Utils.TYPE_CORBA_2_3_OutputStream;
        int outputstream = mg.newLocal(outputStreamType);
        mg.loadThis();
        mg.push(idlName);
        mg.push(true);
        mg.visitMethodInsn(182, "org/omg/CORBA/portable/ObjectImpl", "_request", "(Ljava/lang/String;Z)Lorg/omg/CORBA/portable/OutputStream;");
        mg.checkCast(outputStreamType);
        mg.storeLocal(outputstream);
        for (int i2 = 0; i2 < numArgs; ++i2) {
            mg.loadLocal(outputstream);
            mg.loadArg(i2);
            CORBA_Utils.write_value(mg, method, methodParameters[i2]);
        }
        mg.loadThis();
        mg.loadLocal(outputstream);
        mg.visitMethodInsn(182, "org/omg/CORBA/portable/ObjectImpl", "_invoke", "(Lorg/omg/CORBA/portable/OutputStream;)Lorg/omg/CORBA/portable/InputStream;");
        if (returnType == Type.VOID_TYPE) {
            mg.pop();
        } else {
            mg.checkCast(inputStreamType);
            mg.storeLocal(inputstream);
        }
        int returnValue = -1;
        if (returnType != Type.VOID_TYPE) {
            returnValue = mg.newLocal(returnType);
            mg.loadLocal(inputstream);
            CORBA_Utils.read_value(mg, method, returnClass, returnType);
            mg.storeLocal(returnValue);
        }
        Label not_local_finally_begin = new Label();
        mg.visitJumpInsn(168, not_local_finally_begin);
        if (returnType != Type.VOID_TYPE) {
            mg.loadLocal(returnValue);
        }
        mg.returnValue();
        Label not_local_inner_try_end = new Label();
        mg.visitLabel(not_local_inner_try_end);
        Label catch_appException_label = not_local_inner_try_end;
        int appException = mg.newLocal(CORBA_Utils.TYPE_CORBA_ApplicationException);
        mg.storeLocal(appException);
        mg.loadLocal(appException);
        mg.visitMethodInsn(182, "org/omg/CORBA/portable/ApplicationException", "getInputStream", "()Lorg/omg/CORBA/portable/InputStream;");
        if (inputStreamType != CORBA_Utils.TYPE_CORBA_InputStream) {
            mg.checkCast(inputStreamType);
        }
        mg.storeLocal(inputstream);
        int exIdlName = mg.newLocal(JITUtils.TYPE_String);
        mg.loadLocal(inputstream);
        mg.visitMethodInsn(182, "org/omg/CORBA/portable/InputStream", "read_string", "()Ljava/lang/String;");
        mg.storeLocal(exIdlName);
        for (int i3 = 0; i3 < checkedExceptions.length; ++i3) {
            mg.loadLocal(exIdlName);
            String exceptionName = checkedExceptions[i3].getName();
            mg.visitLdcInsn((Object)RMItoIDL.getIdlExceptionName(exceptionName));
            mg.visitMethodInsn(182, "java/lang/String", "equals", "(Ljava/lang/Object;)Z");
            Label if_equals_else = new Label();
            mg.visitJumpInsn(153, if_equals_else);
            mg.loadLocal(inputstream);
            mg.visitMethodInsn(182, "org/omg/CORBA_2_3/portable/InputStream", "read_value", "()Ljava/io/Serializable;");
            mg.checkCast(checkedTypes[i3]);
            mg.visitInsn(191);
            mg.visitLabel(if_equals_else);
        }
        mg.visitTypeInsn(187, "java/rmi/UnexpectedException");
        mg.visitInsn(89);
        mg.loadLocal(exIdlName);
        mg.visitMethodInsn(183, "java/rmi/UnexpectedException", "<init>", "(Ljava/lang/String;)V");
        mg.visitInsn(191);
        Label catch_remarshalException_label = new Label();
        mg.visitLabel(catch_remarshalException_label);
        mg.visitInsn(87);
        mg.visitJumpInsn(168, not_local_finally_begin);
        mg.visitJumpInsn(167, do_while_begin);
        Label not_local_outer_try_end = new Label();
        mg.visitLabel(not_local_outer_try_end);
        Label catch_sysException_label = not_local_outer_try_end;
        int sysException = mg.newLocal(CORBA_Utils.TYPE_CORBA_SystemException);
        mg.storeLocal(sysException);
        mg.loadLocal(sysException);
        mg.visitMethodInsn(184, "javax/rmi/CORBA/Util", "mapSystemException", "(Lorg/omg/CORBA/SystemException;)Ljava/rmi/RemoteException;");
        mg.visitInsn(191);
        Label not_local_outer_try_catch_end = new Label();
        mg.visitLabel(not_local_outer_try_catch_end);
        Label not_local_finally_ex = not_local_outer_try_catch_end;
        int not_local_finally_th = mg.newLocal(JITUtils.TYPE_Throwable);
        mg.storeLocal(not_local_finally_th);
        mg.visitJumpInsn(168, not_local_finally_begin);
        mg.loadLocal(not_local_finally_th);
        mg.visitInsn(191);
        mg.visitLabel(not_local_finally_begin);
        int not_local_finally_return = mg.newLocal(JITUtils.TYPE_Object);
        mg.storeLocal(not_local_finally_return);
        mg.loadThis();
        mg.loadLocal(inputstream);
        mg.visitMethodInsn(182, "org/omg/CORBA/portable/ObjectImpl", "_releaseReply", "(Lorg/omg/CORBA/portable/InputStream;)V");
        mg.ret(not_local_finally_return);
        mg.visitLabel(while_not_local_end);
        mg.loadThis();
        mg.push(idlName);
        mg.push(declaringClass.getName());
        mg.visitMethodInsn(184, className, "class$", "(Ljava/lang/String;)Ljava/lang/Class;");
        mg.visitMethodInsn(182, "org/omg/CORBA/portable/ObjectImpl", "_servant_preinvoke", "(Ljava/lang/String;Ljava/lang/Class;)Lorg/omg/CORBA/portable/ServantObject;");
        mg.storeLocal(servantObj);
        mg.loadLocal(servantObj);
        mg.visitJumpInsn(198, do_while_begin);
        Label local_try_begin = new Label();
        mg.visitLabel(local_try_begin);
        int numMutableArgs = 0;
        int firstMutableArg = -1;
        int[] argCopy = null;
        if (numArgs > 0) {
            argCopy = new int[numArgs];
            for (i = 0; i < numArgs; ++i) {
                if (CORBA_Utils.isMutable(methodParameters[i])) {
                    argCopy[i] = mg.newLocal(argTypes[i]);
                    ++numMutableArgs;
                    if (firstMutableArg != -1) continue;
                    firstMutableArg = i;
                    continue;
                }
                argCopy[i] = -1;
            }
        }
        if (numMutableArgs == 1) {
            mg.loadArg(firstMutableArg);
            mg.loadThis();
            mg.visitMethodInsn(182, "org/omg/CORBA/portable/ObjectImpl", "_orb", "()Lorg/omg/CORBA/ORB;");
            mg.visitMethodInsn(184, "javax/rmi/CORBA/Util", "copyObject", "(Ljava/lang/Object;Lorg/omg/CORBA/ORB;)Ljava/lang/Object;");
            mg.checkCast(argTypes[firstMutableArg]);
            mg.storeLocal(argCopy[firstMutableArg]);
        } else if (numMutableArgs > 1) {
            mg.push(numMutableArgs);
            mg.visitTypeInsn(189, "java/lang/Object");
            int argCopyArrayIndex = 0;
            for (int i4 = firstMutableArg; i4 < numArgs; ++i4) {
                if (argCopy[i4] <= -1) continue;
                mg.visitInsn(89);
                mg.push(argCopyArrayIndex++);
                mg.loadArg(i4);
                mg.visitInsn(83);
            }
            mg.loadThis();
            mg.visitMethodInsn(182, "org/omg/CORBA/portable/ObjectImpl", "_orb", "()Lorg/omg/CORBA/ORB;");
            mg.visitMethodInsn(184, "javax/rmi/CORBA/Util", "copyObjects", "([Ljava/lang/Object;Lorg/omg/CORBA/ORB;)[Ljava/lang/Object;");
            int argCopyArray = mg.newLocal(JITUtils.TYPE_Object_ARRAY);
            mg.storeLocal(argCopyArray);
            argCopyArrayIndex = 0;
            for (int i5 = firstMutableArg; i5 < numArgs; ++i5) {
                if (argCopy[i5] <= -1) continue;
                mg.loadLocal(argCopyArray);
                mg.push(argCopyArrayIndex++);
                mg.visitInsn(50);
                mg.checkCast(argTypes[i5]);
                mg.storeLocal(argCopy[i5]);
            }
        }
        mg.loadLocal(servantObj);
        mg.visitFieldInsn(180, "org/omg/CORBA/portable/ServantObject", "servant", "Ljava/lang/Object;");
        mg.checkCast(declaringType);
        for (i = 0; i < numArgs; ++i) {
            if (argCopy[i] > -1) {
                mg.loadLocal(argCopy[i]);
                continue;
            }
            mg.loadArg(i);
        }
        mg.visitMethodInsn(185, declaringName, methodName, m.getDescriptor());
        if (returnType != Type.VOID_TYPE) {
            returnValue = mg.newLocal(returnType);
            mg.storeLocal(returnValue);
            if (CORBA_Utils.isMutable(returnClass)) {
                mg.loadLocal(returnValue);
                mg.loadThis();
                mg.visitMethodInsn(182, "org/omg/CORBA/portable/ObjectImpl", "_orb", "()Lorg/omg/CORBA/ORB;");
                mg.visitMethodInsn(184, "javax/rmi/CORBA/Util", "copyObject", "(Ljava/lang/Object;Lorg/omg/CORBA/ORB;)Ljava/lang/Object;");
                mg.checkCast(returnType);
                mg.storeLocal(returnValue);
            }
        }
        Label local_finally_begin = new Label();
        mg.visitJumpInsn(168, local_finally_begin);
        if (returnType != Type.VOID_TYPE) {
            mg.loadLocal(returnValue);
        }
        mg.returnValue();
        Label local_try_end = new Label();
        mg.visitLabel(local_try_end);
        Label catch_throwable_label = local_try_end;
        int ex = mg.newLocal(JITUtils.TYPE_Throwable);
        mg.storeLocal(ex);
        int exCopy = mg.newLocal(JITUtils.TYPE_Object);
        mg.loadLocal(ex);
        mg.loadThis();
        mg.visitMethodInsn(182, "org/omg/CORBA/portable/ObjectImpl", "_orb", "()Lorg/omg/CORBA/ORB;");
        mg.visitMethodInsn(184, "javax/rmi/CORBA/Util", "copyObject", "(Ljava/lang/Object;Lorg/omg/CORBA/ORB;)Ljava/lang/Object;");
        mg.storeLocal(exCopy);
        Label[] checked_else = new Label[checkedExceptions.length];
        for (int i6 = 0; i6 < checkedExceptions.length; ++i6) {
            String checkedName = JITUtils.convertClassName(checkedExceptions[i6].getName());
            mg.loadLocal(exCopy);
            mg.visitTypeInsn(193, checkedName);
            checked_else[i6] = new Label();
            mg.visitJumpInsn(153, checked_else[i6]);
            mg.loadLocal(exCopy);
            mg.visitTypeInsn(192, checkedName);
            mg.visitInsn(191);
            mg.visitLabel(checked_else[i6]);
        }
        mg.loadLocal(exCopy);
        mg.checkCast(JITUtils.TYPE_Throwable);
        mg.visitMethodInsn(184, "javax/rmi/CORBA/Util", "wrapException", "(Ljava/lang/Throwable;)Ljava/rmi/RemoteException;");
        mg.visitInsn(191);
        Label local_try_catch_end = new Label();
        mg.visitLabel(local_try_catch_end);
        Label local_finally_ex = local_try_catch_end;
        int local_finally_th = mg.newLocal(JITUtils.TYPE_Throwable);
        mg.storeLocal(local_finally_th);
        mg.visitJumpInsn(168, local_finally_begin);
        mg.loadLocal(local_finally_th);
        mg.visitInsn(191);
        mg.visitLabel(local_finally_begin);
        int local_finally_return = mg.newLocal(JITUtils.TYPE_Object);
        mg.storeLocal(local_finally_return);
        mg.loadThis();
        mg.loadLocal(servantObj);
        mg.visitMethodInsn(182, "org/omg/CORBA/portable/ObjectImpl", "_servant_postinvoke", "(Lorg/omg/CORBA/portable/ServantObject;)V");
        mg.ret(local_finally_return);
        mg.visitTryCatchBlock(not_local_try_begin, not_local_inner_try_end, catch_appException_label, "org/omg/CORBA/portable/ApplicationException");
        mg.visitTryCatchBlock(not_local_try_begin, not_local_inner_try_end, catch_remarshalException_label, "org/omg/CORBA/portable/RemarshalException");
        mg.visitTryCatchBlock(not_local_try_begin, not_local_outer_try_end, catch_sysException_label, "org/omg/CORBA/SystemException");
        mg.visitTryCatchBlock(not_local_try_begin, not_local_outer_try_catch_end, not_local_finally_ex, null);
        mg.visitTryCatchBlock(local_try_begin, local_try_end, catch_throwable_label, "java/lang/Throwable");
        mg.visitTryCatchBlock(local_try_begin, local_try_catch_end, local_finally_ex, null);
        mg.endMethod();
        mg.visitEnd();
    }
}

