/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.crypto.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.crypto.config.WSKeySet;
import com.ibm.ws.security.config.SecurityConfigObject;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import java.security.PrivilegedAction;

public class KeyReference {
    private static final TraceComponent tc = Tr.register(KeyReference.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private String keySetName = null;
    private String keyAlias = null;
    private int version = 1;
    private String password = null;
    private WSKeyStore kstore = null;
    private WSKeySet wsKeySet = null;

    public KeyReference(com.ibm.websphere.models.config.ipc.ssl.KeyReference kref, WSKeySet keySet, WSKeyStore ks) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSKeyReference");
        }
        this.kstore = ks;
        this.keySetName = keySet.getName();
        this.wsKeySet = keySet;
        this.keyAlias = kref.getKeyAlias();
        this.version = kref.getVersion();
        this.password = kref.getPassword();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSKeyReference", new Object[]{this.toString()});
        }
    }

    public KeyReference(SecurityConfigObject kref, WSKeySet keySet, WSKeyStore ks) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSKeyReference");
        }
        this.kstore = ks;
        this.keySetName = keySet.getName();
        this.wsKeySet = keySet;
        this.keyAlias = kref.getString("keyAlias");
        this.version = kref.getInteger("version");
        this.password = kref.getDecodedString("password");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSKeyReference", new Object[]{this.toString()});
        }
    }

    public String getKeyAlias() {
        String alias;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyAlias");
        }
        String aliasPrefix = this.wsKeySet.getAliasPrefix();
        String string = alias = this.keyAlias != null ? this.keyAlias : aliasPrefix + "_" + this.version;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyAlias -> " + alias);
        }
        return alias;
    }

    public int getVersion() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getVersion");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getVersion -> " + this.version);
        }
        return this.version;
    }

    public String getPassword() {
        String keyReferencePassword;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPassword");
        }
        final WSKeySet wsKeySetPriv = this.wsKeySet;
        String keySetPassword = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return wsKeySetPriv.getPassword();
            }
        });
        String string = keyReferencePassword = this.password != null ? this.password : keySetPassword;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPassword -> " + SSLConfigManager.mask(keyReferencePassword));
        }
        return keyReferencePassword;
    }

    public String toString() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toString");
        }
        StringBuffer buf = new StringBuffer();
        buf.append("KeyReference.toString() {\n");
        buf.append("keySetName = ");
        buf.append(this.getKeySetName());
        buf.append("\n");
        buf.append("keyAlias = ");
        buf.append(this.getKeyAlias());
        buf.append("\n");
        buf.append("version = ");
        buf.append(this.version);
        if (this.password != null && !this.password.equals("")) {
            buf.append("\n");
            buf.append("password = ");
            buf.append(SSLConfigManager.mask(this.password));
        }
        buf.append("\n}");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "toString");
        }
        return buf.toString();
    }

    public WSKeySet getWSKeySet() {
        return this.wsKeySet;
    }

    public String getKeySetName() {
        return this.wsKeySet.getName();
    }

    public WSKeyStore getWSKeyStore() {
        return this.kstore;
    }
}

