/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.topography;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.KeyRepository;
import com.ibm.ws.cluster.topography.DescriptionKeyImpl;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class KeyRepositoryImpl
implements KeyRepository {
    private static final TraceComponent tc = Tr.register(KeyRepositoryImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private Map keys = new HashMap();
    private Map reverseKeys = new HashMap();
    private ReferenceQueue refQueue = new ReferenceQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DescriptionKey getDescriptionKey(DescriptionKey key, Map identitiesToAppend) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("The parent key must not be null.");
        }
        if (identitiesToAppend == null || identitiesToAppend.isEmpty()) {
            throw new IllegalArgumentException("The identitiesToAppend argument must not be null and must contain at least one entry.");
        }
        HashMap copy = new HashMap(key.getProperties());
        copy.putAll(identitiesToAppend);
        DescriptionKey result = null;
        Map map = this.keys;
        synchronized (map) {
            Reference ref = (Reference)this.keys.get(copy);
            if (ref != null) {
                result = (DescriptionKey)ref.get();
            }
            if (result == null) {
                result = this.buildDescriptionKey(copy);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DescriptionKey getDescriptionKey(Map identities) throws IllegalArgumentException {
        if (identities == null || identities.isEmpty()) {
            throw new IllegalArgumentException("The identities argument must not be null and must contain at least one entry.");
        }
        DescriptionKey key = null;
        Map map = this.keys;
        synchronized (map) {
            Reference ref = (Reference)this.keys.get(identities);
            if (ref != null) {
                key = (DescriptionKey)ref.get();
            }
            if (key == null) {
                HashMap copy = new HashMap((int)((float)identities.size() / 0.75f) + 1, 0.75f);
                copy.putAll(identities);
                key = this.buildDescriptionKey(copy);
            }
        }
        return key;
    }

    private DescriptionKey buildDescriptionKey(Map identities) throws IllegalArgumentException {
        Iterator entries = identities.entrySet().iterator();
        HashMap tmp = new HashMap();
        while (entries.hasNext()) {
            Map.Entry element = entries.next();
            Object eKey = element.getKey();
            Object eValue = element.getValue();
            if (eKey instanceof String && eValue instanceof String) {
                tmp.put(eKey, eValue);
                continue;
            }
            throw new IllegalArgumentException("The identities argument should consist of String keys and values.");
        }
        DescriptionKeyImpl key = new DescriptionKeyImpl(tmp);
        SoftReference<DescriptionKeyImpl> ref = new SoftReference<DescriptionKeyImpl>(key, this.refQueue);
        this.keys.put(identities, ref);
        this.reverseKeys.put(ref, identities);
        this.purge();
        return key;
    }

    public void exportToStream(DataOutput out, DescriptionKey key) throws IOException {
        Map identities = key.getProperties();
        out.writeByte(0);
        int count = identities.size();
        out.writeInt(count);
        Iterator iterator = identities.entrySet().iterator();
        for (int i = 0; i < count; ++i) {
            Map.Entry element = iterator.next();
            out.writeUTF((String)element.getKey());
            out.writeUTF((String)element.getValue());
        }
    }

    public DescriptionKey importFromStream(DataInput in) throws IOException {
        Object result = null;
        in.readByte();
        int count = in.readInt();
        HashMap<String, String> identities = new HashMap<String, String>((int)((float)count / 0.75f) + 1, 0.75f);
        for (int i = 0; i < count; ++i) {
            String key = in.readUTF();
            String value = in.readUTF();
            identities.put(key, value);
        }
        return this.getDescriptionKey(identities);
    }

    private void purge() {
        SoftReference ref = null;
        while ((ref = (SoftReference)this.refQueue.poll()) != null) {
            Map key = (Map)this.reverseKeys.get(ref);
            this.reverseKeys.remove(ref);
            this.keys.remove(key);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "purge", key);
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.15 ");
        }
    }
}

