/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.service;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.Format;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.ws.cluster.Compressor;
import com.ibm.ws.cluster.ProcessProperties;
import com.ibm.ws.cluster.topography.ConcernImpl;
import com.ibm.ws.cluster.topography.FormatImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.WsObjectInputStream;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.distribution.ServerClusterContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerClusterContextImpl
implements ServerClusterContext {
    private static final TraceComponent tc = Tr.register(ServerClusterContextImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final int serverContextVersion = 3;
    protected Map<Identity, List<Identity>> localJoinedClusterMap;
    protected Object localJoinedClusterMapMutex;
    private ProcessProperties ivProcessProperties;
    private Identity me;

    public ServerClusterContextImpl() {
        this.localJoinedClusterMapMutex = this.localJoinedClusterMap = Collections.synchronizedMap(new HashMap());
        this.ivProcessProperties = ProcessProperties.getInstance();
        this.me = (Identity)this.ivProcessProperties.get("key.local.member");
    }

    @Override
    public byte[] checkClientContext(byte[] clientContext) {
        byte[] result;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "checkClientContext", clientContext);
            }
            result = null;
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(clientContext);
                WsObjectInputStream ois = new WsObjectInputStream(bais);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                int clientVersion = ois.readInt();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "clientVersion " + clientVersion);
                }
                HashMap clusterKeyMap = new HashMap();
                this.receiveServerContextCluster(ois, clusterKeyMap);
                if (!clusterKeyMap.isEmpty()) {
                    oos.writeInt(3);
                    DescriptionManagerFactory.getDescriptionManager().stream(clusterKeyMap, oos);
                    oos.flush();
                    result = Compressor.compress(baos.toByteArray(), 4);
                    oos.close();
                }
                baos.close();
                ois.close();
                bais.close();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, ServerClusterContextImpl.class.getName() + ".checkClientContext", "106", this);
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "unexpected exception", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkClientContext", result);
        }
        return result;
    }

    private void receiveServerContextCluster(ObjectInput oi, Map clusterKeyMap) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "receiveServerContextCluster");
        }
        if (oi.readBoolean()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Read cluster available to process true");
            }
            DescriptionKey key = KeyRepositoryFactory.getInstance().getKeyRepository().importFromStream(oi);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "read cluster Key " + key);
            }
            long clientStructuralEpoch = oi.readLong();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "read structural epoch " + clientStructuralEpoch);
            }
            long clientInfluentialEpoch = oi.readLong();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "read influential epoch " + clientInfluentialEpoch);
            }
            ClusterDescription clusterDescription = (ClusterDescription)DescriptionManagerFactory.getDescriptionManager().getDescription(key);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cluster available to process ", new Object[]{new Long(clientStructuralEpoch), new Long(clientInfluentialEpoch), key, clusterDescription});
            }
            if (clusterDescription != null) {
                if (clientStructuralEpoch == -2L) {
                    FormatImpl format = new FormatImpl(new ConcernImpl(Integer.MAX_VALUE), 4);
                    this.addAllClusterKeys(clusterKeyMap, clusterDescription, format);
                } else {
                    ClusterDescription.Memento cdMemento = (ClusterDescription.Memento)clusterDescription.getMemento();
                    int formatType = 0;
                    if (clientStructuralEpoch < cdMemento.getStructuralEpoch()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "structural epoch has changed");
                        }
                        formatType = 1;
                    } else if (clientInfluentialEpoch < cdMemento.getInfluentialEpoch()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "influential epoch has changed");
                        }
                        formatType = 2;
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "client is up to date");
                    }
                    if (formatType != 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "client needs updated cluster information");
                        }
                        FormatImpl format = new FormatImpl(new ConcernImpl(Integer.MAX_VALUE), formatType);
                        this.addClusterKey(clusterKeyMap, clusterDescription, format);
                    }
                }
            } else if (tc.isEventEnabled()) {
                Tr.event(tc, "Unable to find cluster " + (key == null ? "" : key.toString()));
            }
            this.receiveServerContextCluster(oi, clusterKeyMap);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receiveServerContextCluster");
        }
    }

    protected void addAllClusterKeys(Map clusterKeyMap, ClusterDescription cluster, Format format) {
        this.addClusterKey(clusterKeyMap, cluster, format);
    }

    protected void addClusterKey(Map clusterKeyMap, ClusterDescription cluster, Format format) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addClusterKey");
        }
        Set<DescriptionKey> clusterKeySet = null;
        if (clusterKeyMap.containsKey(format)) {
            clusterKeySet = (Set)clusterKeyMap.get(format);
            if (!clusterKeySet.contains(cluster.getKey())) {
                clusterKeySet.add(cluster.getKey());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "added key ", cluster.getKey());
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "set already contains cluster key");
            }
        } else {
            clusterKeySet = new HashSet();
            clusterKeySet.add(cluster.getKey());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "added key ", cluster.getKey());
            }
            clusterKeyMap.put(format, clusterKeySet);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addClusterKey");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validateClusterResidency(Identity clusterIdentity) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "validateClusterResidency", clusterIdentity);
        }
        boolean result = false;
        if (this.me == null) {
            this.me = (Identity)this.ivProcessProperties.get("key.local.member");
        }
        if (this.me == clusterIdentity) {
            result = true;
        } else {
            List<Identity> members = this.localJoinedClusterMap.get(clusterIdentity);
            if (members != null && members.size() >= 1 && members.get(0) == this.me) {
                result = true;
            } else {
                Object object = this.localJoinedClusterMapMutex;
                synchronized (object) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "localJoinedClusterMap", this.printLocalJoinedClusterMap());
                    }
                    result = this.findChild(clusterIdentity);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "validateClusterResidency", String.valueOf(result));
        }
        return result;
    }

    private boolean findChild(Identity clusterIdentity) {
        List<Identity> membersList = this.localJoinedClusterMap.get(clusterIdentity);
        if (membersList == null) {
            return false;
        }
        for (Identity current : membersList) {
            if (this.me == current) {
                return true;
            }
            if (!this.findChild(current)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validateClusterProcessResidency(Identity clusterIdentity) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "validateClusterProcessResidency", clusterIdentity);
        }
        boolean result = false;
        if (this.me == null) {
            this.me = (Identity)this.ivProcessProperties.get("key.local.member");
        }
        if (this.me == clusterIdentity) {
            result = true;
        } else {
            List<Identity> members = this.localJoinedClusterMap.get(clusterIdentity);
            if (members != null && members.size() >= 1 && members.get(0) == this.me) {
                result = true;
            } else {
                Object object = this.localJoinedClusterMapMutex;
                synchronized (object) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "localJoinedClusterMap", this.printLocalJoinedClusterMap());
                    }
                    result = this.findChild(clusterIdentity);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "validateClusterProcessResidency", String.valueOf(result));
        }
        return result;
    }

    protected void updateLocalJoinedClusterMap(Map<Identity, List<Identity>> clusterMap, Object mutex) {
        this.localJoinedClusterMapMutex = mutex;
        this.localJoinedClusterMap = clusterMap;
    }

    private String printLocalJoinedClusterMap() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "me is: " + this.me);
        }
        StringBuilder strBld = new StringBuilder(256);
        strBld.append("[");
        Iterator<Identity> iter = this.localJoinedClusterMap.keySet().iterator();
        Identity clusterKey = null;
        while (iter.hasNext()) {
            clusterKey = iter.next();
            strBld.append(clusterKey);
            strBld.append(" = ");
            strBld.append(this.localJoinedClusterMap.get(clusterKey).toString());
            if (!iter.hasNext()) continue;
            strBld.append("\n ");
        }
        strBld.append("]");
        return strBld.toString();
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.15 ");
        }
    }
}

