/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.service;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.Contract;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.IdentityMap;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.websphere.cluster.topography.ProcessDescription;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.cluster.ProcessProperties;
import com.ibm.ws.cluster.service.ClusterManagementImpl;
import com.ibm.ws.cluster.service.EndPointImpl;
import com.ibm.ws.cluster.service.ServerClusterContextFactory;
import com.ibm.ws.cluster.service.ServerClusterContextImpl;
import com.ibm.ws.cluster.topography.ConcernImpl;
import com.ibm.ws.cluster.topography.ContractImpl;
import com.ibm.ws.cluster.topography.SelectionClusterMemberDescription;
import com.ibm.ws.cluster.topography.TriggerInfoImpl;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.Server;
import com.ibm.wsspi.cluster.ClusterManagement;
import com.ibm.wsspi.cluster.ClusterManagementFactory;
import com.ibm.wsspi.cluster.ClusterMemberService;
import com.ibm.wsspi.cluster.EndPoint;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.IdentityMapping;
import com.ibm.wsspi.cluster.NoClusterDefinedException;
import com.ibm.wsspi.cluster.distribution.ClusterContextDistributor;
import com.ibm.wsspi.cluster.distribution.ServerClusterContext;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ClusterMemberServiceImpl
extends WsComponentImpl
implements ClusterMemberService {
    private static final TraceComponent tc = Tr.register(ClusterMemberServiceImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private DescriptionManager ivDescMgr = DescriptionManagerFactory.getDescriptionManager();
    private ServerClusterContext ivServerClusterContext = ServerClusterContextFactory.getServerClusterContextFactory().createServerClusterContext();
    private Map<Identity, List<Identity>> localJoinedClusterMap = Collections.synchronizedMap(new HashMap());
    private DescriptionKey activeClusterSetKey;
    private IdentityMap activeClusterSet;
    private Map ivDistributors = new HashMap();
    private String ivCellName = null;
    private String ivNodeName = null;
    private String ivProcessName = null;
    private ProcessDescription ivClusterMember = null;
    private Contract ivContract = null;
    private ClusterManagement ivClusterManagement = ClusterManagementFactory.getClusterManagement();
    private ProcessProperties ivProcessProperties = null;
    private Server server = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Object config2) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        AdminService adminService;
        String processType;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", config2);
        }
        if ((processType = (adminService = AdminServiceFactory.getAdminService()).getProcessType()).equals("AdminAgent") || processType.equals("JobManager")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "initialize - running in a ADMIN_AGENT_PROCESS or JOB_MANAGER_PROCESS throwing ComponentDisabledException");
            }
            throw new ComponentDisabledException();
        }
        this.ivContract = new ContractImpl();
        this.ivContract.addEvent(TriggerInfoImpl.TRIGGER_STRUCTURE);
        this.ivContract.addEvent(TriggerInfoImpl.TRIGGER_INFLUENCE);
        this.ivContract.setInterest(new ConcernImpl(Integer.MAX_VALUE));
        try {
            this.server = WsServiceRegistry.getService(this, Server.class);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, ClusterMemberServiceImpl.class.getName() + ".initialize", "199");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "initialize getService Failed");
            }
            throw new ComponentDisabledException();
        }
        this.ivCellName = this.server.getCellName();
        this.ivNodeName = this.server.getNodeName();
        this.ivProcessName = this.server.getName();
        this.activeClusterSetKey = (DescriptionKey)IdentityMapping.getActiveClusterSetIdentityFromCellName(this.ivCellName);
        this.activeClusterSet = this.getActiveClusterSet();
        DescriptionKey memberKey = (DescriptionKey)((ClusterManagementImpl)this.ivClusterManagement).createClusterMember(this.ivCellName, this.ivNodeName, null, this.ivProcessName);
        this.ivProcessProperties = ProcessProperties.getInstance();
        this.ivProcessProperties.put("key.local.member", memberKey);
        this.ivClusterMember = (ProcessDescription)this.ivDescMgr.getDescription(memberKey);
        Map<Identity, List<Identity>> map = this.localJoinedClusterMap;
        synchronized (map) {
            List<Identity> clusterMembers = this.localJoinedClusterMap.get(memberKey);
            if (clusterMembers == null) {
                clusterMembers = new LinkedList<Identity>();
                clusterMembers.add(memberKey);
            } else if (!clusterMembers.contains(memberKey)) {
                clusterMembers.add(memberKey);
            }
            this.localJoinedClusterMap.put(memberKey, clusterMembers);
        }
        try {
            WsServiceRegistry.addService(this, ClusterMemberService.class);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, ClusterMemberServiceImpl.class.getName() + ".initialize", "235");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "initialize addService Failed");
            }
            throw new ComponentDisabledException();
        }
        this.ivProcessProperties.put("key.clustermember.service", this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void start() throws RuntimeWarning, RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        super.start();
        if (this.server.getServerMode() == 1) {
            this.ivClusterMember.setAvailability((byte)9);
        } else {
            this.ivClusterMember.setAvailability((byte)0);
        }
        TreeMap<String, String> selectionDistinction = new TreeMap<String, String>();
        selectionDistinction.put(SelectionClusterMemberDescription.distinction[0], SelectionClusterMemberDescription.distinction[1]);
        DescriptionKey selectionKey = KeyRepositoryFactory.getInstance().getKeyRepository().getDescriptionKey(this.ivClusterMember.getKey(), selectionDistinction);
        SelectionClusterMemberDescription selectionMember = (SelectionClusterMemberDescription)this.ivDescMgr.getDescription(selectionKey);
        selectionMember.updateMemento();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public EndPoint defineLocalScopedData(Identity dataIdentity, byte[] data) {
        EndPointImpl result;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "defineLocalScopedData ", dataIdentity);
        }
        try {
            result = (EndPointImpl)this.ivDescMgr.getDescription((DescriptionKey)dataIdentity, EndPoint.class.getName());
            result.setlocal(true);
            result.setData(data);
            this.ivClusterMember.setExtrinsicData(result);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, this.getClass().getName() + ".defineLocalScopedData", "341");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "unexpected exception ", e);
            }
            IllegalArgumentException iae = new IllegalArgumentException("An internal error occurred while trying to process the local data.");
            iae.initCause(e);
            throw iae;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "defineLocalScopedData", result);
        }
        return result;
    }

    public EndPoint defineMemberScopedData(Identity dataIdentity, byte[] data) {
        EndPoint result;
        block2: {
            result = null;
            try {
                result = this.ivClusterManagement.defineMemberScopedData(this.ivClusterMember.getKey(), dataIdentity, data);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, ClusterMemberServiceImpl.class.getName() + ".defineMemberScopedData", "221");
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "unexpected exception ", e);
            }
        }
        return result;
    }

    public byte[] undefineMemberScopedData(EndPoint endpoint) {
        try {
            this.ivClusterManagement.undefineMemberScopedData(this.ivClusterMember.getKey(), endpoint);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, ClusterMemberServiceImpl.class.getName() + ".undefineMemberScopedData", "240");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception ", e);
            }
            return null;
        }
        return endpoint.getData();
    }

    public byte[] undefineLocalScopedData(EndPoint endpoint) {
        DescriptionKey dataKey = (DescriptionKey)endpoint.getIdentity();
        this.ivClusterMember.removeExtrinsicData(dataKey);
        return endpoint.getData();
    }

    public void joinCluster(Identity clusterIdentity) throws NoClusterDefinedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "joinCluster", clusterIdentity);
        }
        DescriptionKey memberKey = this.ivClusterMember.getKey();
        this.addToLocalJoinedClusterMap(clusterIdentity, memberKey);
        this.addToActiveClusterSet(clusterIdentity);
        this.ivClusterManagement.joinCluster(clusterIdentity, new Identity[]{memberKey});
        ((ServerClusterContextImpl)this.ivServerClusterContext).updateLocalJoinedClusterMap(this.localJoinedClusterMap, this.localJoinedClusterMap);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "joinCluster", this.localJoinedClusterMap);
        }
    }

    public void disjoinCluster(Identity clusterIdentity) throws NoClusterDefinedException {
        DescriptionKey clusterKey;
        ClusterDescription clusterDescription;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "disjoinCluster", clusterIdentity);
        }
        if ((clusterDescription = (ClusterDescription)this.ivDescMgr.getDescription(clusterKey = (DescriptionKey)clusterIdentity)) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "disjoinCluster", "throw NoClusterDefinedException()");
            }
            throw new NoClusterDefinedException();
        }
        DescriptionKey memberKey = this.ivClusterMember.getKey();
        this.ivClusterManagement.disjoinCluster(clusterKey, new Identity[]{memberKey});
        if (this.removeFromLocalJoinedClusterMap(clusterIdentity, memberKey)) {
            this.removeFromActiveClusterSet(clusterIdentity);
        }
        ((ServerClusterContextImpl)this.ivServerClusterContext).updateLocalJoinedClusterMap(this.localJoinedClusterMap, this.localJoinedClusterMap);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "disjoinCluster", this.localJoinedClusterMap);
        }
    }

    public ServerClusterContext getServerClusterContextListener() {
        return this.ivServerClusterContext;
    }

    public void registerDistributor(ClusterContextDistributor distributor, Identity identity) {
        this.ivDistributors.put(identity, distributor);
    }

    public void joinCluster(Identity[] hierarchicalClusterIdentities) throws NoClusterDefinedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "joinCluster", hierarchicalClusterIdentities);
        }
        HashMap<Identity, Object> localActiveClusterSubset = new HashMap<Identity, Object>();
        try {
            Identity parentClusterKey = hierarchicalClusterIdentities[0];
            Identity childClusterKey = null;
            int arrayLength = hierarchicalClusterIdentities.length;
            for (int i = 1; i < arrayLength; ++i) {
                childClusterKey = hierarchicalClusterIdentities[i];
                this.ivDescMgr.getDescription((DescriptionKey)childClusterKey, ClusterDescription.class.getName());
                this.addToLocalJoinedClusterMap(parentClusterKey, childClusterKey);
                localActiveClusterSubset.put(parentClusterKey, null);
                this.ivClusterManagement.joinCluster(parentClusterKey, new Identity[]{childClusterKey});
                parentClusterKey = childClusterKey;
            }
            this.ivClusterManagement.joinCluster(hierarchicalClusterIdentities[arrayLength - 1], new Identity[]{this.ivClusterMember.getKey()});
            this.addToLocalJoinedClusterMap(hierarchicalClusterIdentities[arrayLength - 1], this.ivClusterMember.getKey());
            localActiveClusterSubset.put(hierarchicalClusterIdentities[arrayLength - 1], null);
            ((ServerClusterContextImpl)this.ivServerClusterContext).updateLocalJoinedClusterMap(this.localJoinedClusterMap, this.localJoinedClusterMap);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, ClusterMemberServiceImpl.class.getName() + ".joinCluster", "325");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception ", e);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "joinCluster");
            }
            throw new NoClusterDefinedException(e);
        }
        finally {
            this.addToActiveClusterSet(localActiveClusterSubset);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "joinCluster", this.localJoinedClusterMap);
        }
    }

    public void disjoinCluster(Identity[] hierarchicalClusterIdentities) throws NoClusterDefinedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "disjoinCluster", hierarchicalClusterIdentities);
        }
        HashSet<DescriptionKey> localActiveClusterSubset = new HashSet<DescriptionKey>();
        int length = hierarchicalClusterIdentities.length;
        if (length > 1) {
            DescriptionKey lastKey = (DescriptionKey)hierarchicalClusterIdentities[length - 1];
            ClusterDescription childClusterDescription = (ClusterDescription)this.ivDescMgr.getDescription(lastKey);
            if (childClusterDescription == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "disjoinCluster", "throw NoClusterDefinedException()");
                }
                throw new NoClusterDefinedException();
            }
            for (int i = length - 2; i >= 0; --i) {
                DescriptionKey parentClusterKey = (DescriptionKey)hierarchicalClusterIdentities[i];
                DescriptionKey childClusterKey = childClusterDescription.getKey();
                if (this.removeFromLocalJoinedClusterMap(parentClusterKey, childClusterKey)) {
                    localActiveClusterSubset.add(parentClusterKey);
                }
                this.ivClusterManagement.disjoinCluster(parentClusterKey, new Identity[]{childClusterKey});
                childClusterDescription = (ClusterDescription)this.ivDescMgr.getDescription(parentClusterKey);
                if (childClusterDescription != null) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "disjoinCluster", "throw NoClusterDefinedException()");
                }
                throw new NoClusterDefinedException();
            }
            ((ServerClusterContextImpl)this.ivServerClusterContext).updateLocalJoinedClusterMap(this.localJoinedClusterMap, this.localJoinedClusterMap);
            this.removeFromActiveClusterSet(localActiveClusterSubset);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "disjoinCluster", this.localJoinedClusterMap);
        }
    }

    public void defineAttribute(String attribute) {
        this.ivClusterManagement.defineAttribute(this.ivClusterMember.getKey(), attribute);
    }

    public void undefineAttribute(String attribute) {
        this.ivClusterManagement.undefineAttribute(this.ivClusterMember.getKey(), attribute);
    }

    public Identity getIdentity() {
        return this.ivClusterMember.getKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToLocalJoinedClusterMap(Identity cluster, Identity member) {
        Map<Identity, List<Identity>> map = this.localJoinedClusterMap;
        synchronized (map) {
            List<Identity> clusterMembers = this.localJoinedClusterMap.get(cluster);
            if (clusterMembers == null) {
                clusterMembers = new LinkedList<Identity>();
                clusterMembers.add(member);
            } else if (!clusterMembers.contains(member)) {
                clusterMembers.add(member);
            }
            this.localJoinedClusterMap.put(cluster, clusterMembers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeFromLocalJoinedClusterMap(Identity cluster, Identity member) {
        boolean remove = false;
        Map<Identity, List<Identity>> map = this.localJoinedClusterMap;
        synchronized (map) {
            List<Identity> clusterMembers = this.localJoinedClusterMap.get(cluster);
            if (clusterMembers != null && clusterMembers.remove(member)) {
                if (clusterMembers.isEmpty()) {
                    this.localJoinedClusterMap.remove(cluster);
                    remove = true;
                } else {
                    this.localJoinedClusterMap.put(cluster, clusterMembers);
                }
            }
        }
        return remove;
    }

    private void addToActiveClusterSet(Identity key) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addToActiveClusterSet", key);
        }
        this.activeClusterSet.put(key, null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addToActiveClusterSet", this.activeClusterSet);
        }
    }

    private void addToActiveClusterSet(Map subset) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addToActiveClusterSet", subset);
        }
        this.activeClusterSet.putAll(subset);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addToActiveClusterSet", this.activeClusterSet);
        }
    }

    private IdentityMap getActiveClusterSet() {
        IdentityMap identityMap;
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "getActiveClusterSet");
            }
            identityMap = null;
            try {
                identityMap = (IdentityMap)this.ivDescMgr.getDescription(this.activeClusterSetKey, IdentityMap.class.getName());
            }
            catch (Exception e) {
                FFDCFilter.processException(e, ClusterMemberServiceImpl.class.getName() + "getIdentityMap", "623");
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                Tr.event(tc, "unexpected", e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getActiveClusterSet", identityMap.toString());
        }
        return identityMap;
    }

    private void removeFromActiveClusterSet(Identity key) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeFromActiveClusterSet", key);
        }
        this.activeClusterSet.remove(key);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeFromActiveClusterSet", this.activeClusterSet);
        }
    }

    private void removeFromActiveClusterSet(HashSet keys) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeFromActiveClusterSet", keys);
        }
        this.activeClusterSet.removeSet(keys);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeFromActiveClusterSet", this.activeClusterSet);
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.64 ");
        }
    }
}

