/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.service;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.ws.cluster.Compressor;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.WsObjectInputStream;
import com.ibm.wsspi.cluster.distribution.ClientClusterContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.ListIterator;

public class ClientClusterContextImpl
implements ClientClusterContext {
    private static final TraceComponent tc = Tr.register(ClientClusterContextImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private DescriptionManager descMgr;
    private static final int clientContextVersion = 3;
    private List clusters;

    public ClientClusterContextImpl(List clusters) {
        DescriptionManagerFactory.getInstance();
        this.descMgr = DescriptionManagerFactory.getDescriptionManager();
        this.clusters = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", clusters);
        }
        ListIterator<ClusterDescription> iter = clusters.listIterator();
        while (iter.hasNext()) {
            DescriptionKey clusterKey = (DescriptionKey)iter.next();
            ClusterDescription clusterDescription = (ClusterDescription)this.descMgr.getDescription(clusterKey);
            if (clusterDescription != null) {
                iter.set(clusterDescription);
                continue;
            }
            iter.remove();
        }
        this.clusters = clusters;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public byte[] exportClientContext() {
        byte[] result;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "exportClientContext");
            }
            result = null;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeInt(3);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "wrote context version 3");
                }
                this.sendClientContextClusters(oos);
                oos.flush();
                result = baos.toByteArray();
                oos.close();
                baos.close();
            }
            catch (IOException ioe) {
                FFDCFilter.processException((Throwable)ioe, ClientClusterContextImpl.class.getName() + ".exportClientContext", "121", this);
                if (!tc.isEventEnabled()) break block5;
                Tr.event(tc, "unexpected exception", ioe);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exportClientContext", result);
        }
        return result;
    }

    public void importClusterContext(byte[] context) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "receiveClientContext", context);
        }
        ByteArrayInputStream bais = null;
        WsObjectInputStream ois = null;
        try {
            bais = new ByteArrayInputStream(Compressor.decompress(context, 4));
            ois = new WsObjectInputStream(bais);
            DescriptionManagerFactory.getInstance();
            DescriptionManagerFactory.getDescriptionManager().update(ois);
            ois.close();
            bais.close();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, ClientClusterContextImpl.class.getName() + ".receiveClientContext", "151", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receiveClientContext");
        }
    }

    private void sendClientContextClusters(ObjectOutput oo) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendClientContextPrefix");
        }
        for (ClusterDescription cluster : this.clusters) {
            ClusterDescription.Memento cdMemento = (ClusterDescription.Memento)((Object)cluster);
            oo.writeBoolean(true);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote available to process true");
            }
            KeyRepositoryFactory.getInstance().getKeyRepository().exportToStream(oo, cluster.getKey());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote cluster Key " + cluster.getKey());
            }
            oo.writeLong(cdMemento.getStructuralEpoch());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote structural epoch " + cdMemento.getStructuralEpoch());
            }
            oo.writeLong(cdMemento.getInfluentialEpoch());
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "wrote influential epoch " + cdMemento.getInfluentialEpoch());
        }
        oo.writeBoolean(false);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wrote available to process false");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendClientContextPrefix");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.4 ");
        }
    }
}

