/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.selection.feedback;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cluster.selection.RouterMediator;
import com.ibm.ws.cluster.selection.algorithm.SelectionAlgorithm;
import com.ibm.ws.cluster.selection.feedback.WeightBasedFeedback;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.monitor.AdvisorFactory;
import com.ibm.wsspi.cluster.monitor.AdvisorMediator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class ObservedWeightFeedback
implements WeightBasedFeedback {
    private static final TraceComponent tc = Tr.register(ObservedWeightFeedback.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final ClusterService clusterService = ClusterServiceFactory.getClusterService();
    private final AdvisorMediator mediator = AdvisorFactory.getAdvisorMediator();
    private Identity clusterIdentity;
    private SelectionAlgorithm selectionAlgorithm;
    private Map members = Collections.EMPTY_MAP;
    private volatile boolean execute = true;

    private int[] modifyWeights(MemberData[] memberData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "modifyWeights", memberData);
        }
        int size = memberData.length;
        int observedSum = 0;
        int activeSize = 0;
        int[] newWeights = new int[size];
        int[] desiredWeights = new int[size];
        for (int i = 0; i < size; ++i) {
            newWeights[i] = memberData[i].observed;
            desiredWeights[i] = 5;
            if (desiredWeights[i] != 0) {
                ++activeSize;
            }
            observedSum += newWeights[i];
        }
        boolean result = false;
        size = activeSize;
        int idealWeight = 1;
        if (observedSum > 0) {
            idealWeight = observedSum / size + 1;
        }
        for (int i = 0; i < size; ++i) {
            int n = newWeights[i] = desiredWeights[i] == 0 ? 0 : idealWeight - newWeights[i];
            if (newWeights[i] == memberData[i].last) continue;
            memberData[i].last = newWeights[i];
            result = true;
        }
        if (tc.isEntryEnabled()) {
            StringBuffer weightString = new StringBuffer("weights ");
            if (result) {
                for (int i = 0; i < size; ++i) {
                    weightString.append(5);
                    weightString.append("->");
                    weightString.append(newWeights[i]);
                    weightString.append(" ");
                }
            } else {
                weightString.append("no change ");
            }
            weightString.append(observedSum);
            Tr.exit(tc, "modifyWeights", weightString);
        }
        return (int[])(result ? newWeights : null);
    }

    public void init(Identity cluster, SelectionAlgorithm algorithm) {
        this.clusterIdentity = cluster;
        this.selectionAlgorithm = algorithm;
        this.applyStructuralUpdate(clusterService.getMemberIdentities(this.clusterIdentity));
        ((RouterMediator)this.mediator).registerFeedback(this, cluster);
    }

    public void applyStructuralUpdate(Identity[] memberArray) {
        HashMap<Identity, MemberData> memberMap = new HashMap<Identity, MemberData>(memberArray.length * 2);
        for (int i = 0; i < memberArray.length; ++i) {
            MemberData memberData = (MemberData)this.members.get(memberArray[i]);
            if (memberData == null) {
                memberData = new MemberData(memberArray[i]);
            }
            memberMap.put(memberArray[i], memberData);
        }
        this.members = memberMap;
        this.execute(true);
    }

    public void applyWorkloadUpdate(Identity member, int weight) {
        MemberData data = (MemberData)this.members.get(member);
        if (data != null) {
            data.observed = weight;
        }
        if (this.execute) {
            this.execute = false;
            this.execute(false);
            this.execute = true;
        }
    }

    public void applyExceptionUpdate(Identity member, int exceptionIncrement) {
        MemberData data = (MemberData)this.members.get(member);
        if (data != null) {
            data.exception += exceptionIncrement;
        }
        if (this.execute) {
            this.execute = false;
            this.execute(false);
            this.execute = true;
        }
    }

    private void execute(boolean forcePrepare) {
        MemberData[] memberData = new MemberData[this.members.size()];
        this.members.values().toArray(memberData);
        int[] applyWeights = this.modifyWeights(memberData);
        if (forcePrepare || applyWeights != null) {
            int i;
            Identity[] memberArray = new Identity[memberData.length];
            for (i = 0; i < memberData.length; ++i) {
                memberArray[i] = memberData[i].memberIdentity;
            }
            if (applyWeights == null) {
                applyWeights = new int[memberArray.length];
                for (i = 0; i < memberData.length; ++i) {
                    applyWeights[i] = 5;
                }
            }
            this.selectionAlgorithm.prepare(memberArray, applyWeights);
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.6 ");
        }
    }

    private final class MemberData {
        private final Identity memberIdentity;
        private final int desired = 5;
        private int observed;
        private int exception;
        private int last;

        private MemberData(Identity member) {
            this.memberIdentity = member;
        }

        public String toString() {
            return "FeedbackData [" + this.memberIdentity + ':' + 5 + ':' + this.observed + ':' + this.exception + ':' + this.last + ']';
        }
    }
}

