/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.selection.feedback;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cluster.selection.algorithm.SelectionAlgorithm;
import com.ibm.ws.cluster.selection.feedback.WeightBasedFeedback;
import com.ibm.wsspi.cluster.ClusterManagement;
import com.ibm.wsspi.cluster.ClusterManagementFactory;
import com.ibm.wsspi.cluster.ClusterObserver;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.Identity;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class DesiredWeightFeedback
implements WeightBasedFeedback,
ClusterObserver {
    private static final TraceComponent tc = Tr.register(DesiredWeightFeedback.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final ClusterService clusterService = ClusterServiceFactory.getClusterService();
    private static final ClusterManagement clusterManagement = ClusterManagementFactory.getClusterManagement();
    private Identity clusterIdentity;
    private SelectionAlgorithm selectionAlgorithm;
    private Map members = Collections.EMPTY_MAP;

    public void init(Identity cluster, SelectionAlgorithm algorithm) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init", new Object[]{cluster, algorithm});
        }
        this.clusterIdentity = cluster;
        this.selectionAlgorithm = algorithm;
        clusterService.registerInterest(this, this.clusterIdentity, "type.cluster.weight.update");
        this.applyStructuralUpdate(clusterService.getMemberIdentities(cluster));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public void applyStructuralUpdate(Identity[] memberArray) {
        HashMap<Identity, MemberData> memberMap = new HashMap<Identity, MemberData>(memberArray.length * 2);
        int[] weights = new int[memberArray.length];
        for (int i = 0; i < memberArray.length; ++i) {
            MemberData memberData = (MemberData)this.members.get(memberArray[i]);
            if (memberData == null) {
                memberData = new MemberData(memberArray[i]);
            }
            memberData.desired = DesiredWeightFeedback.clusterManagement.getDesiredWeight(this.clusterIdentity, memberArray[i]);
            weights[i] = memberData.desired;
            memberMap.put(memberArray[i], memberData);
        }
        this.members = memberMap;
        this.execute();
    }

    public void applyWorkloadUpdate(Identity member, int weight) {
    }

    public void applyExceptionUpdate(Identity member, int exceptionIncrement) {
    }

    private int[] modifyWeights(MemberData[] memberData) {
        int[] result = new int[memberData.length];
        for (int i = 0; i < memberData.length; ++i) {
            result[i] = memberData[i].desired;
        }
        return result;
    }

    private void execute() {
        MemberData[] memberData = new MemberData[this.members.size()];
        this.members.values().toArray(memberData);
        int[] applyWeights = this.modifyWeights(memberData);
        if (applyWeights != null) {
            Identity[] memberArray = new Identity[memberData.length];
            for (int i = 0; i < memberData.length; ++i) {
                memberArray[i] = memberData[i].memberIdentity;
            }
            this.selectionAlgorithm.prepare(memberArray, applyWeights);
        }
    }

    public void notify(Identity identity, String type, Object info) {
        MemberData data;
        if (tc.isEventEnabled()) {
            Tr.event(tc, "notify", new Object[]{identity, type, info});
        }
        if ((data = (MemberData)this.members.get(info)) != null) {
            data.desired = DesiredWeightFeedback.clusterManagement.getDesiredWeight(this.clusterIdentity, (Identity)info);
        }
        this.execute();
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version", "1.1");
        }
    }

    private final class MemberData {
        private final Identity memberIdentity;
        private int desired;

        private MemberData(Identity member) {
            this.memberIdentity = member;
        }

        public String toString() {
            return "FeedbackData [" + this.memberIdentity + ":" + this.desired + "]";
        }
    }
}

