/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.selection.feedback;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.DescriptionModificationListener;
import com.ibm.ws.cluster.selection.RouterMediator;
import com.ibm.ws.cluster.selection.algorithm.SelectionAlgorithm;
import com.ibm.ws.cluster.selection.feedback.WeightBasedFeedback;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.monitor.AdvisorFactory;
import com.ibm.wsspi.cluster.monitor.AdvisorMediator;
import java.util.Set;

public final class BlendedWeightFeedback
implements WeightBasedFeedback,
DescriptionModificationListener {
    private static final TraceComponent tc = Tr.register(BlendedWeightFeedback.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final DescriptionManager descriptionManager = DescriptionManagerFactory.getDescriptionManager();
    private ClusterDescription cluster;
    private SelectionAlgorithm selectionAlgorithm;
    private MemberData[] members = new MemberData[0];
    private volatile boolean execute = true;

    private int[] modifyWeights(MemberData[] memberData) {
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "modifyWeights", memberData);
        }
        int size = memberData.length;
        int desiredSum = 0;
        int observedSum = 0;
        int[] pendingWeights = new int[size];
        for (int i2 = 0; i2 < size; ++i2) {
            observedSum += memberData[i2].observed;
            desiredSum += memberData[i2].desired;
        }
        boolean result = false;
        if (observedSum == 0) {
            for (int i3 = 0; i3 < size; ++i3) {
                pendingWeights[i3] = memberData[i3].desired;
                if (memberData[i3].last == memberData[i3].desired) continue;
                memberData[i3].last = memberData[i3].desired;
                result = true;
            }
        } else if (desiredSum == 0) {
            int optimalObservedWeight = observedSum / size;
            for (i = 0; i < size; ++i) {
                pendingWeights[i] = optimalObservedWeight - memberData[i].observed;
                if (pendingWeights[i] == memberData[i].last) continue;
                memberData[i].last = pendingWeights[i];
                result = true;
            }
        } else {
            double sumFactor = (double)desiredSum / (double)observedSum;
            for (int i4 = 0; i4 < size; ++i4) {
                int n = pendingWeights[i4] = memberData[i4].desired == 0 ? 0 : 2 * memberData[i4].desired - (int)((double)memberData[i4].observed * sumFactor);
                if (pendingWeights[i4] == memberData[i4].last) continue;
                memberData[i4].last = pendingWeights[i4];
                result = true;
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer weightString = new StringBuffer("weights ");
            for (i = 0; i < size; ++i) {
                weightString.append(memberData[i].desired);
                weightString.append("->");
                weightString.append(pendingWeights[i]);
                weightString.append(" ");
            }
            weightString.append(desiredSum);
            weightString.append(" ");
            weightString.append(observedSum);
            Tr.exit(tc, "modifyWeights", weightString);
        }
        return (int[])(result ? pendingWeights : null);
    }

    public void init(Identity clusterKey, SelectionAlgorithm algorithm) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init", new Object[]{clusterKey, algorithm});
        }
        this.cluster = (ClusterDescription)descriptionManager.getDescription((DescriptionKey)clusterKey);
        this.selectionAlgorithm = algorithm;
        Set keys = this.getClusterMemento().getMembers().keySet();
        Identity[] memberArray = new Identity[keys.size()];
        keys.toArray(memberArray);
        this.applyStructuralUpdate(memberArray);
        AdvisorMediator mediator = AdvisorFactory.getAdvisorMediator();
        ((RouterMediator)mediator).registerFeedback(this, this.cluster.getKey());
        this.cluster.registerNotificationListener(this, "type.cluster.weight.update", null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init", this);
        }
    }

    public void applyStructuralUpdate(Identity[] memberArray) {
        MemberData[] data = new MemberData[memberArray.length];
        for (int i = 0; i < memberArray.length; ++i) {
            MemberData memberData = this.getMemberData(memberArray[i]);
            if (memberData == null) {
                memberData = new MemberData(memberArray[i]);
            }
            data[i] = memberData;
            memberData.desired = this.getClusterMemento().getWeightTableEntry((DescriptionKey)memberArray[i]);
        }
        this.members = data;
        this.execute(true);
    }

    public void applyWorkloadUpdate(Identity member, int weight) {
        MemberData data = this.getMemberData(member);
        if (data != null) {
            data.observed = weight;
        }
        if (this.execute) {
            this.execute = false;
            this.execute(false);
            this.execute = true;
        }
    }

    public void applyExceptionUpdate(Identity member, int exceptionIncrement) {
        MemberData data = this.getMemberData(member);
        if (data != null) {
            data.exception += exceptionIncrement;
        }
        if (this.execute) {
            this.execute = false;
            this.execute(false);
            this.execute = true;
        }
    }

    private void execute(boolean forcePrepare) {
        MemberData[] data = this.members;
        int[] applyWeights = this.modifyWeights(data);
        if (forcePrepare || applyWeights != null) {
            int i;
            Identity[] memberArray = new Identity[data.length];
            for (i = 0; i < data.length; ++i) {
                memberArray[i] = data[i].memberIdentity;
            }
            if (applyWeights == null) {
                applyWeights = new int[memberArray.length];
                for (i = 0; i < data.length; ++i) {
                    applyWeights[i] = data[i].desired;
                }
            }
            this.selectionAlgorithm.prepare(memberArray, applyWeights);
        }
    }

    public void handleNotification(DescriptionKey key, String type, Object userData, Object handback) {
        MemberData data;
        if (tc.isEventEnabled()) {
            Tr.event(tc, "handleNotification", new Object[]{key, type, userData});
        }
        if ((data = this.getMemberData((Identity)userData)) != null) {
            data.desired = this.getClusterMemento().getWeightTableEntry((DescriptionKey)userData);
        }
        this.execute(true);
    }

    private MemberData getMemberData(Identity member) {
        MemberData[] data = this.members;
        for (int i = 0; i < data.length; ++i) {
            if (data[i].memberIdentity != member) continue;
            return data[i];
        }
        return null;
    }

    public String toString() {
        return super.toString() + '[' + (this.cluster == null ? "null" : this.cluster.getKey()) + ' ' + (this.selectionAlgorithm == null ? "null" : this.selectionAlgorithm) + ' ' + (this.members == null ? "null" : this.members) + ']';
    }

    private ClusterDescription.Memento getClusterMemento() {
        return (ClusterDescription.Memento)this.cluster.getMemento();
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.11 ");
        }
    }

    private final class MemberData {
        private final Identity memberIdentity;
        private int desired;
        private int observed;
        private int exception;
        private int last;

        private MemberData(Identity member) {
            this.memberIdentity = member;
        }

        public String toString() {
            return "[" + this.memberIdentity + ':' + this.desired + ':' + this.observed + ':' + this.exception + ':' + this.last + ']';
        }
    }
}

