/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.selection.algorithm;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cluster.selection.algorithm.SelectionAlgorithm;
import com.ibm.wsspi.cluster.Identity;
import java.util.Random;

public final class RandomAlgorithm
implements SelectionAlgorithm {
    private static final TraceComponent tc = Tr.register(RandomAlgorithm.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private Memento memento;
    private static final Random random;

    public RandomAlgorithm() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.prepare(new Identity[0], new int[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Identity select() {
        Memento localMemento = null;
        RandomAlgorithm randomAlgorithm = this;
        synchronized (randomAlgorithm) {
            localMemento = this.memento;
        }
        if (localMemento.size == 0) {
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "select", this);
        }
        int index = random.nextInt(localMemento.size);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "select", "select - " + localMemento.targets[index]);
        }
        return localMemento.targets[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(Identity[] members, int[] weights) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepare", members);
        }
        if (members.length != weights.length) {
            throw new IllegalStateException("The target and weight tables must have identical size.");
        }
        Memento localMemento = new Memento(members, weights, members.length);
        RandomAlgorithm randomAlgorithm = this;
        synchronized (randomAlgorithm) {
            this.memento = localMemento;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepare", this);
        }
    }

    public String toString() {
        return this.memento.toString();
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.3 ");
        }
        random = new Random(System.currentTimeMillis());
    }

    private final class Memento {
        final Identity[] targets;
        final int[] weights;
        final int size;

        private Memento(Identity[] targets, int[] weights, int size) {
            this.targets = targets;
            this.weights = weights;
            this.size = size;
        }

        public String toString() {
            StringBuffer result = new StringBuffer(super.toString());
            result.append("[");
            result.append(this.size);
            result.append(" ");
            for (int i = 0; i < this.size; ++i) {
                result.append(this.targets[i]);
                result.append(" ");
                result.append(" ignored ");
                result.append(this.weights[i]);
                result.append(" ");
            }
            result.append("]");
            return result.toString();
        }
    }
}

