/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cluster.channel.ChannelSelectionAdapterImpl;
import com.ibm.ws.cluster.selection.TargetImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.channel.framework.CFEndPointCriteria;
import com.ibm.wsspi.channel.framework.DetailedCFEndPointCriteria;
import com.ibm.wsspi.cluster.EndPoint;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.Target;
import com.ibm.wsspi.cluster.adapter.IdentityMapping;
import com.ibm.wsspi.cluster.adapter.channel.ChannelTarget;
import java.util.HashMap;
import java.util.Map;

public class ChannelTargetImpl
implements ChannelTarget {
    private static final TraceComponent tc = Tr.register(ChannelTargetImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    public static final Map<String, String> distinction = new HashMap<String, String>();
    private Target target;
    private CFEndPointCriteria criteria;
    private EndPoint[] wlmEndPoints = null;
    private CFEndPoint[] cfEndpoints = new CFEndPoint[0];
    private long wlmEndPointsVersion = 0L;
    private boolean endPointsChanged = false;

    public ChannelTargetImpl(Target target, CFEndPointCriteria criteria) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ChannelTargetImpl", new Object[]{target, criteria});
        }
        if (target == null) {
            throw new IllegalArgumentException("The Target passed in was null.");
        }
        if (criteria == null) {
            throw new IllegalArgumentException("The CFEndPointCriteria passed in was null.");
        }
        this.target = target;
        this.criteria = criteria;
        this.updateCachedEndpoints();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ChannelTargetImpl", this.wlmEndPointsVersion);
        }
    }

    public Identity getMemberIdentity() {
        return this.target.getMemberIdentity();
    }

    public Identity[] getClusterIdentities() {
        return this.target.getClusterIdentities();
    }

    public CFEndPoint[] getCFEndpoints() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getCFEndpoints", this.wlmEndPointsVersion);
        }
        this.updateCachedEndpoints();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getCFEndpoints", new Object[]{this.wlmEndPointsVersion, this.cfEndpoints.length});
        }
        return this.cfEndpoints;
    }

    public EndPoint[] getEndpoints() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getEndpoints", this.wlmEndPointsVersion);
        }
        this.updateCachedEndpoints();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getEndpoints", this.wlmEndPointsVersion);
        }
        return this.wlmEndPoints;
    }

    public CFEndPointCriteria getCFEndPointCriteria() {
        return this.criteria;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CFEndPoint getCFEndPoint() {
        CFEndPoint[] tempCFEndPoints;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getCFEndPoint", this);
        }
        CFEndPoint result = null;
        if (ChannelSelectionAdapterImpl.cfService != null) {
            tempCFEndPoints = this.getCFEndpoints();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                StringBuilder criteriaBuffer = new StringBuilder(this.criteria.toString());
                criteriaBuffer.append("[");
                if (this.criteria instanceof DetailedCFEndPointCriteria) {
                    criteriaBuffer.append(((DetailedCFEndPointCriteria)this.criteria).getChainProperties() + ":");
                } else {
                    criteriaBuffer.append("Not DetailedCFEndPointCriteria:");
                }
                criteriaBuffer.append("]");
                Tr.debug(tc, "subset CFEndPointCriteria= ", criteriaBuffer);
                if (this.endPointsChanged) {
                    Object object = ((TargetImpl)this.target).getEndPointMutex();
                    synchronized (object) {
                        this.endPointsChanged = false;
                    }
                    StringBuilder cfeps = new StringBuilder(128);
                    if (tempCFEndPoints != null) {
                        cfeps.append("CFEndPoints list size = " + tempCFEndPoints.length + " ");
                        for (CFEndPoint ep : tempCFEndPoints) {
                            cfeps.append("[" + ep + "]");
                        }
                    } else {
                        cfeps.append("unexpected: CFEndPoints list is null");
                    }
                    Tr.debug(tc, "end points changed: ", cfeps.toString());
                }
            }
        } else {
            Tr.error(tc, "NLSKEY_CFS_UNAVAILABLE");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getCFEndPoint", "unexpected: ChannelFrameworkService is not available.");
            }
            throw new IllegalStateException("The ChannelFrameworkService is not available for determining the best end point.");
        }
        result = ChannelSelectionAdapterImpl.cfService.determineBestEndPoint(tempCFEndPoints, this.criteria);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getCFEndPoint", result);
        }
        return result;
    }

    public boolean isMemberInProcess() {
        boolean result;
        block3: {
            result = false;
            try {
                TargetImpl targetImpl = (TargetImpl)this.target;
                if (targetImpl != null) {
                    result = targetImpl.isTargetInProcess();
                }
            }
            catch (ClassCastException e) {
                FFDCFilter.processException((Throwable)e, ChannelTargetImpl.class.getName() + ".isMemberInProcess", "193", this);
                if (!tc.isEventEnabled()) break block3;
                Tr.debug(tc, "unexpected", e);
            }
        }
        return result;
    }

    public boolean isMemberInHost() {
        boolean result;
        block4: {
            result = false;
            try {
                TargetImpl targetImpl = (TargetImpl)this.target;
                if (targetImpl != null) {
                    result = targetImpl.isTargetInHost();
                }
            }
            catch (ClassCastException e) {
                FFDCFilter.processException((Throwable)e, ChannelTargetImpl.class.getName() + ".isMemberInHost", "215", this);
                if (!tc.isEventEnabled()) break block4;
                Tr.debug(tc, "unexpected", e);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isMemberInHost: " + result);
        }
        return result;
    }

    public boolean isMemberInServer() {
        boolean result;
        block3: {
            result = false;
            try {
                TargetImpl targetImpl = (TargetImpl)this.target;
                if (targetImpl != null) {
                    result = targetImpl.isTargetInServer();
                }
            }
            catch (ClassCastException e) {
                FFDCFilter.processException((Throwable)e, ChannelTargetImpl.class.getName() + ".isMemberInServer", "236", this);
                if (!tc.isEventEnabled()) break block3;
                Tr.debug(tc, "unexpected", e);
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("Target is: ");
        sb.append(this.target);
        sb.append("Criteria is: ");
        sb.append(this.criteria);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCachedEndpoints() {
        boolean local_endPointsChanged = false;
        EndPoint[] local_wlmEndPoints = null;
        long local_wlmEndPointsVersion = 0L;
        CFEndPoint[] local_cfEndpoints = new CFEndPoint[]{};
        Object object = ((TargetImpl)this.target).getEndPointMutex();
        synchronized (object) {
            if (((TargetImpl)this.target).getEndPointVersion() > this.wlmEndPointsVersion) {
                this.endPointsChanged = true;
                local_endPointsChanged = true;
                local_wlmEndPoints = this.target.matchEndPoints(distinction);
                local_wlmEndPointsVersion = ((TargetImpl)this.target).getEndPointVersion();
            }
        }
        if (local_endPointsChanged) {
            local_cfEndpoints = new CFEndPoint[local_wlmEndPoints.length];
            for (int i = 0; i < local_cfEndpoints.length; ++i) {
                local_cfEndpoints[i] = IdentityMapping.getCFEndPoint(local_wlmEndPoints[i].getIdentity());
            }
            Object object2 = ((TargetImpl)this.target).getEndPointMutex();
            synchronized (object2) {
                if (local_wlmEndPointsVersion > this.wlmEndPointsVersion) {
                    this.wlmEndPoints = local_wlmEndPoints;
                    this.wlmEndPointsVersion = local_wlmEndPointsVersion;
                    this.cfEndpoints = local_cfEndpoints;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "updateCachedEndpoints", this.cfEndpoints.length);
                    }
                }
            }
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.30 ");
        }
        distinction.put("TYPE", "CHANNEL");
        distinction.put("COMPONENT", "CF");
    }
}

