/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.cluster.channel.ChannelTargetImpl;
import com.ibm.ws.cluster.channel.NoAvailableEndPointExceptionImpl;
import com.ibm.ws.cluster.selection.SelectionCriteriaImpl;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.channel.framework.CFEndPointCriteria;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.Target;
import com.ibm.wsspi.cluster.adapter.channel.ChannelSelectionAdapter;
import com.ibm.wsspi.cluster.adapter.channel.ChannelSelectionCriteria;
import com.ibm.wsspi.cluster.adapter.channel.ChannelTarget;
import com.ibm.wsspi.cluster.adapter.channel.HealthMonitorManager;
import com.ibm.wsspi.cluster.adapter.channel.NoAvailableEndPointException;
import com.ibm.wsspi.cluster.selection.NoApplicableTargetException;
import com.ibm.wsspi.cluster.selection.NoAvailableTargetException;
import com.ibm.wsspi.cluster.selection.SelectionCriteria;
import com.ibm.wsspi.cluster.selection.SelectionService;
import com.ibm.wsspi.cluster.selection.SelectionServiceFactory;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public final class ChannelSelectionAdapterImpl
extends WsComponentImpl
implements ChannelSelectionAdapter {
    private static final TraceComponent tc = Tr.register(ChannelSelectionAdapterImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private SelectionService selectionService = SelectionServiceFactory.getSelectionService();
    static ChannelFrameworkService cfService = null;
    static HealthMonitorManager hmService = null;
    private Map<Target, ChannelTarget> channelTargetCache = Collections.synchronizedMap(new WeakHashMap());

    public void initialize(Object config2) throws ComponentDisabledException {
        AdminService adminService;
        block17: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initialize", new Object[]{config2});
            }
            adminService = null;
            try {
                adminService = AdminServiceFactory.getAdminService();
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block17;
                Tr.debug(tc, "initialize getAdminService Failed Continue");
            }
        }
        if (adminService == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "initialize", "AdminService Service is unavailable.  Continue");
            }
        } else {
            String processType = adminService.getProcessType();
            if (processType.equals("AdminAgent") || processType.equals("JobManager")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "initialize - running in a ADMIN_AGENT_PROCESS or JOB_MANAGER_PROCESS throwing ComponentDisabledException");
                }
                throw new ComponentDisabledException();
            }
        }
        try {
            cfService = WsServiceRegistry.getService(this, ChannelFrameworkService.class);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, ChannelSelectionAdapterImpl.class.getName() + ".initialize", "105");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "initialize getService Failed");
            }
            throw new ComponentDisabledException();
        }
        if (cfService == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize", "ChannelFrameworkService is unavailable.  Shutting down the ChannelSelectionAdapter");
            }
            throw new ComponentDisabledException();
        }
        try {
            WsServiceRegistry.addService(this, ChannelSelectionAdapter.class);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, ChannelSelectionAdapterImpl.class.getName() + ".initialize", "123");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "initialize addService Failed");
            }
            throw new ComponentDisabledException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize ");
        }
    }

    public void start() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public CFEndPoint select(Identity clusterIdentity, CFEndPointCriteria criteria) throws NoAvailableEndPointException, NoApplicableTargetException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "select", new Object[]{clusterIdentity, criteria});
        }
        if (clusterIdentity == null) {
            throw new IllegalArgumentException("The Identity argument must not be null.");
        }
        if (criteria == null) {
            throw new IllegalArgumentException("The CFEndPointCriteria argument must not be null.");
        }
        ChannelSelectionCriteria selectionCriteria = this.getCriteria(clusterIdentity, null, criteria);
        ChannelTarget channelTarget = this.select(selectionCriteria);
        CFEndPoint bestCFEndPoint = channelTarget.getCFEndPoint();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "select", bestCFEndPoint);
        }
        return bestCFEndPoint;
    }

    public ChannelTarget select(ChannelSelectionCriteria selectCriteria) throws NoAvailableEndPointException, NoApplicableTargetException {
        ChannelTarget result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "select", selectCriteria);
        }
        if (selectCriteria == null) {
            throw new IllegalArgumentException("The ChannelSelectionCriteria attribute must not be null.");
        }
        Boolean criteriaMatch = null;
        try {
            SelectionCriteria selCrit = selectCriteria.getCriteria();
            Target target = this.selectionService.select(selCrit);
            result = this.channelTargetCache.get(target);
            if (result != null) {
                criteriaMatch = new Boolean(((ChannelTargetImpl)result).getCFEndPointCriteria().equals(selectCriteria.getCFEndPointCriteria()));
            }
            if (result == null || !criteriaMatch.booleanValue()) {
                CFEndPointCriteria criteria;
                if (result != null && TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled() && (criteria = ((ChannelTargetImpl)result).getCFEndPointCriteria()) instanceof ChannelSelectionCriteria) {
                    ((ChannelSelectionCriteria)criteria).equals(selectCriteria.getCFEndPointCriteria(), true);
                }
                result = new ChannelTargetImpl(target, selectCriteria.getCFEndPointCriteria());
                if (selCrit instanceof SelectionCriteriaImpl) {
                    SelectionCriteriaImpl selCritImpl = (SelectionCriteriaImpl)selCrit;
                    if (!selCritImpl.isAffinityKeyPresent()) {
                        this.channelTargetCache.put(target, result);
                    }
                } else {
                    this.channelTargetCache.put(target, result);
                }
            }
        }
        catch (NoAvailableTargetException nat) {
            throw new NoAvailableEndPointExceptionImpl(nat, selectCriteria);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "select", new Object[]{result, criteriaMatch});
        }
        return result;
    }

    public ChannelTarget select(Identity clusterIdentity, ChannelSelectionCriteria selectCriteria) throws NoAvailableEndPointException, NoApplicableTargetException {
        ChannelTargetImpl result;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "select", new Object[]{clusterIdentity, selectCriteria});
        }
        if (clusterIdentity == null) {
            throw new IllegalArgumentException("The Identity argument must not be null.");
        }
        if (selectCriteria == null) {
            throw new IllegalArgumentException("The ChannelSelectionCriteria argument must not be null.");
        }
        try {
            Target target = this.selectionService.select(selectCriteria.getCriteria());
            result = new ChannelTargetImpl(target, selectCriteria.getCFEndPointCriteria());
        }
        catch (NoAvailableTargetException nat) {
            throw new NoAvailableEndPointExceptionImpl(nat, selectCriteria);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "select", result);
        }
        return result;
    }

    public ChannelSelectionCriteria getCriteria(Identity clusterIdentity, Map context, CFEndPointCriteria cfCriteria) {
        ChannelSelectionCriteria result;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCriteria", new Object[]{clusterIdentity, context, cfCriteria});
        }
        if (clusterIdentity == null) {
            throw new IllegalArgumentException("The identity attribute must not be null.");
        }
        if (context == null) {
            context = new HashMap<String, Map<String, String>>(5);
        }
        if (!context.containsKey("endpoints")) {
            context.put("endpoints", ChannelTargetImpl.distinction);
        }
        ChannelSelectionCriteria channelSelectionCriteria = result = cfCriteria == null ? new ChannelSelectionCriteria(clusterIdentity, context, null, null, null, false) : new ChannelSelectionCriteria(clusterIdentity, context, cfCriteria);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCriteria", result);
        }
        return result;
    }

    public ChannelSelectionCriteria getCriteria(Identity clusterIdentity, Map context, String chainName, Class channelAccessor, Class[] optionalChannelFactories, boolean sslRequired) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCriteria", new Object[]{clusterIdentity, context, chainName, channelAccessor, optionalChannelFactories, String.valueOf(sslRequired)});
        }
        if (clusterIdentity == null) {
            throw new IllegalArgumentException("The identity attribute must not be null.");
        }
        ChannelSelectionCriteria result = new ChannelSelectionCriteria(clusterIdentity, context, chainName, channelAccessor, optionalChannelFactories, sslRequired);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCriteria", result);
        }
        return result;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.25 ");
        }
    }
}

