/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cluster.channel.ChannelTargetImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.wlm.threadmanager.SleeperThreadPool;
import com.ibm.ws.wlm.threadmanager.SleeperThreadPoolFactory;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.Target;
import com.ibm.wsspi.cluster.adapter.channel.ChannelSelectionCriteria;
import com.ibm.wsspi.cluster.adapter.channel.SelectionEndPointCallback;
import com.ibm.wsspi.cluster.selection.NoAvailableTargetException;
import com.ibm.wsspi.cluster.selection.SelectionService;
import com.ibm.wsspi.cluster.selection.SelectionServiceFactory;
import java.lang.ref.WeakReference;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class CallbackWhenEPAvailableThread
implements Runnable {
    private static final TraceComponent tc = Tr.register(CallbackWhenEPAvailableThread.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    final Identity clusterIdentity;
    final WeakReference callback;
    final ChannelSelectionCriteria criteria;
    final Object handback;
    private long beginTime = 0L;
    private long endTime = 0L;
    private static final SelectionService selectionService;
    private static final SleeperThreadPool pool;

    public CallbackWhenEPAvailableThread(SelectionEndPointCallback callback, ChannelSelectionCriteria criteria, Object handback) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{callback, handback});
        }
        if (callback == null) {
            throw new IllegalArgumentException("Selection EndPoint callback cannot be null");
        }
        this.callback = new WeakReference<SelectionEndPointCallback>(callback);
        this.criteria = criteria;
        this.handback = handback;
        this.clusterIdentity = criteria.getIdentity();
        if (tc.isEntryEnabled()) {
            this.beginTime = System.currentTimeMillis();
            Tr.exit(tc, "<init>");
        }
    }

    public void run() {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "run", this);
            }
            final CallbackWhenEPAvailableThread command = this;
            PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                public Object run() {
                    block14: {
                        Target selectedTarget = null;
                        ChannelTargetImpl channelTarget = null;
                        try {
                            if (CallbackWhenEPAvailableThread.this.callback.get() != null) {
                                block13: {
                                    try {
                                        selectedTarget = selectionService.select(CallbackWhenEPAvailableThread.this.criteria.getCriteria());
                                        ChannelTargetImpl channelTargetImpl = channelTarget = new ChannelTargetImpl(selectedTarget, CallbackWhenEPAvailableThread.this.criteria.getCFEndPointCriteria());
                                        CFEndPoint[] eps = channelTargetImpl.getCFEndpoints();
                                        if (eps != null && eps.length > 0) {
                                            SelectionEndPointCallback toCallback = (SelectionEndPointCallback)CallbackWhenEPAvailableThread.this.callback.get();
                                            if (toCallback != null) {
                                                toCallback.callback(channelTarget, CallbackWhenEPAvailableThread.this.handback);
                                                if (tc.isDebugEnabled()) {
                                                    CallbackWhenEPAvailableThread.this.endTime = System.currentTimeMillis();
                                                    long waitTime = CallbackWhenEPAvailableThread.this.beginTime == 0L ? -1L : CallbackWhenEPAvailableThread.this.endTime - CallbackWhenEPAvailableThread.this.beginTime;
                                                    Tr.debug(tc, " after waiting " + waitTime + "ms, callback called with channelTarget: " + channelTarget);
                                                }
                                            } else if (tc.isDebugEnabled()) {
                                                CallbackWhenEPAvailableThread.this.endTime = System.currentTimeMillis();
                                                long waitTime = CallbackWhenEPAvailableThread.this.beginTime == 0L ? -1L : CallbackWhenEPAvailableThread.this.endTime - CallbackWhenEPAvailableThread.this.beginTime;
                                                Tr.debug(tc, "callback object was collected after waiting " + waitTime + "ms");
                                            }
                                            return channelTarget;
                                        }
                                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                            Tr.debug(tc, "no CF end points yet");
                                        }
                                    }
                                    catch (NoAvailableTargetException e1) {
                                        if (!tc.isDebugEnabled()) break block13;
                                        Tr.debug(tc, "still no available target");
                                    }
                                }
                                pool.RunInTimeOrder(command, 500);
                                break block14;
                            }
                            if (tc.isDebugEnabled()) {
                                CallbackWhenEPAvailableThread.this.endTime = System.currentTimeMillis();
                                long waitTime = CallbackWhenEPAvailableThread.this.beginTime == 0L ? -1L : CallbackWhenEPAvailableThread.this.endTime - CallbackWhenEPAvailableThread.this.beginTime;
                                Tr.debug(tc, "callback ref was collected after waiting " + waitTime + "ms");
                            }
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, CallbackWhenEPAvailableThread.class.getName(), "199", this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Unexpected Exception occured when trying to select a target ", e);
                            }
                            return null;
                        }
                    }
                    return null;
                }
            };
            try {
                ContextManagerFactory.getInstance().runAsSystem(action);
            }
            catch (PrivilegedActionException e) {
                FFDCFilter.processException((Throwable)e, CallbackWhenEPAvailableThread.class.getName(), "212", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "unexpected PrivilegedActionException", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "run", new Object[]{this.clusterIdentity, this.callback});
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getClass().getName());
        result.append(" < clusterIdentity=" + this.clusterIdentity + " SelectionEndPointCallback=" + this.callback + " handback=" + this.handback + " >");
        return result.toString();
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.8 : none");
        }
        selectionService = SelectionServiceFactory.getSelectionService();
        pool = SleeperThreadPoolFactory.getInstance();
    }
}

