/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.validation;

import com.ibm.websphere.models.config.channelservice.TransportChannel;
import com.ibm.ws.channel.framework.ChannelTypeManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelValidationCollector {
    protected Map<ChannelTypeManager.ChannelMetaData, List<TransportChannel>> _collectionMap;
    protected ChannelTypeManager _typeManager;

    public ChannelValidationCollector(ChannelTypeManager typeManager) {
        this._typeManager = typeManager;
        this._collectionMap = new HashMap<ChannelTypeManager.ChannelMetaData, List<TransportChannel>>();
    }

    public boolean collectChannel(TransportChannel channel) {
        if (channel == null) {
            return false;
        }
        this.getChannelBucket(this._typeManager.getChannelType(channel), true).add(channel);
        return true;
    }

    public Set<ChannelTypeManager.ChannelMetaData> getChannelTypes() {
        return this._collectionMap.keySet();
    }

    public List<TransportChannel> getChannels(ChannelTypeManager.ChannelMetaData type) {
        return this.getChannelBucket(type, false);
    }

    private List<TransportChannel> getChannelBucket(ChannelTypeManager.ChannelMetaData type, boolean createIfNeeded) {
        List<TransportChannel> bucket = this._collectionMap.get(type);
        if (null == bucket && createIfNeeded) {
            bucket = new ArrayList<TransportChannel>();
            this._collectionMap.put(type, bucket);
        }
        return bucket;
    }
}

