/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.ws.channel.common.ChannelPoolObject;
import com.ibm.ws.channel.common.ChannelUtilsBase;
import com.ibm.ws.util.ObjectPool;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChannelUtils
extends ChannelUtilsBase {
    private static ChannelUtils chTrace = new ChannelUtils();

    public static ChannelPoolObject getChannelObject(TraceComponent tc, String desc, ObjectPool pool) {
        return chTrace.getObject(tc, desc, pool, tc.isDebugEnabled(), tc.isEntryEnabled());
    }

    public static boolean releaseChannelObject(TraceComponent tc, String desc, ChannelPoolObject obj, ObjectPool pool) {
        return chTrace.releaseObject(tc, desc, obj, pool, tc.isDebugEnabled(), tc.isEntryEnabled());
    }

    public static void printDebugStackTrace(TraceComponent tc, Throwable t, String message) {
        if (!tc.isDebugEnabled()) {
            return;
        }
        chTrace.traceDebugStack(tc, t, message);
    }

    public static void printThreadStackTrace(TraceComponent tc, Thread thread) {
        if (!tc.isDebugEnabled()) {
            return;
        }
        chTrace.traceThreadStack(tc, thread);
    }

    public static void displayChannels(TraceComponent tc, ChannelFramework cfw, String message, String prefix) {
        if (!tc.isDebugEnabled()) {
            return;
        }
        chTrace.traceChannels(tc, cfw, message, prefix);
    }

    public static void displayChains(TraceComponent tc, ChannelFramework cfw, Class<?> factory, String message, String prefix) {
        if (!tc.isDebugEnabled()) {
            return;
        }
        chTrace.traceChains((Object)tc, cfw, factory, message, prefix);
    }

    public static void displayChains(TraceComponent tc, ChannelFramework cfw, String groupName, String message, String prefix) {
        if (!tc.isDebugEnabled()) {
            return;
        }
        chTrace.traceChains((Object)tc, cfw, groupName, message, prefix);
    }

    public static void displayChains(TraceComponent tc, ChainData[] chains, String message, String prefix) {
        if (!tc.isDebugEnabled()) {
            return;
        }
        if (chains == null || chains.length == 0) {
            chTrace.debugTrace(tc, prefix + ", no chains to trace (" + message + ")");
        } else {
            chTrace.traceChains(tc, Arrays.asList(chains), message, prefix);
        }
    }

    public static void displayChains(TraceComponent tc, List<?> lchain, String message, String prefix) {
        if (!tc.isDebugEnabled()) {
            return;
        }
        chTrace.traceChains(tc, lchain, message, prefix);
    }

    @Override
    protected void debugTrace(Object logTool, String msg) {
        Tr.debug((TraceComponent)logTool, msg);
    }

    @Override
    protected void entryTrace(Object logTool, String m_name, Object parms) {
        Tr.entry((TraceComponent)logTool, m_name, parms);
    }

    @Override
    protected void exitTrace(Object logTool, String m_name, Object result) {
        Tr.exit((TraceComponent)logTool, m_name, result);
    }
}

