/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bootstrap;

import com.ibm.ws.bootstrap.RASDelegator;
import com.ibm.ws.bootstrap.RASWsLoggerFactory;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class WsLogManager
extends LogManager {
    private static final String CONFIGURE_BY_SERVER_PROPERTY_NAME = "java.util.logging.configureByServer";
    private static final String CONFIGURE_BY_LOGGING_PROPERTIES_FILE = "java.util.logging.configureByLoggingPropertiesFile";
    private static final boolean CHECK_CALLING_METHOD_FOR_GETLOGGER = "false".equals(System.getProperty("com.ibm.ws.bootstrap.logmanager.createNewLogger"));
    private static boolean configureByServer = "true".equalsIgnoreCase(System.getProperty("java.util.logging.configureByServer"));
    private static boolean configureByLoggingProperties = "true".equalsIgnoreCase(System.getProperty("java.util.logging.configureByLoggingPropertiesFile"));
    private static RASDelegator svRASDelegator = RASDelegator.getSingleton();
    private boolean isTrLoaded = false;
    private boolean resetEnabled = true;

    public void readConfiguration() throws IOException, SecurityException {
        if (!configureByServer || configureByLoggingProperties) {
            super.readConfiguration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Logger getLogger(String name) {
        Logger logger;
        if (!this.isTrLoaded) {
            try {
                Class.forName("com.ibm.ejs.ras.Tr", true, WsLogManager.getClassLoader(WsLogManager.class));
            }
            catch (ClassNotFoundException ex) {
            }
            catch (PrivilegedActionException pe) {
            }
            finally {
                this.isTrLoaded = true;
            }
        }
        if ((logger = super.getLogger(name)) == null) {
            boolean createNewLogger = true;
            if (CHECK_CALLING_METHOD_FOR_GETLOGGER) {
                createNewLogger = false;
                boolean foundThisMethod = false;
                Exception ex = new Exception();
                StackTraceElement[] ste = ex.getStackTrace();
                for (int i = 0; i < ste.length; ++i) {
                    if (foundThisMethod) {
                        if (!ste[i].getClassName().equals("java.util.logging.Logger") || !ste[i].getMethodName().equals("getLogger")) break;
                        createNewLogger = true;
                        break;
                    }
                    if (!ste[i].getClassName().equals("com.ibm.ws.bootstrap.WsLogManager") || !ste[i].getMethodName().equals("getLogger")) continue;
                    foundThisMethod = true;
                }
            }
            if (createNewLogger && (logger = svRASDelegator.createWsLogger(name)) != null) {
                this.addLogger(logger);
            }
        }
        return logger;
    }

    public void initWsLoggerFactory(RASWsLoggerFactory impl) {
        svRASDelegator.setRASWsLogerFactory(impl);
    }

    public void reset() throws SecurityException {
        if (this.resetEnabled) {
            super.reset();
        }
    }

    public void enableReset() {
        this.resetEnabled = true;
    }

    public void disableReset() {
        this.resetEnabled = false;
    }

    public boolean isResetEnabled() {
        return this.resetEnabled;
    }

    public static boolean isConfigureByLoggingProperties() {
        return configureByLoggingProperties;
    }

    private static ClassLoader getClassLoader(final Class clazz) throws PrivilegedActionException {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return clazz.getClassLoader();
            }
        });
    }
}

