/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bootstrap;

import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class LoggingServices {
    public static final boolean debugEnabled = Boolean.getBoolean("ws.ext.debug");
    private static ResourceBundle bundle = null;
    public static PrintStream out = System.out;

    public static void trace(String key) {
        LoggingServices.trace(key, null);
    }

    public static void trace(String key, Object o) {
        LoggingServices.trace(key, new Object[]{o});
    }

    public static void trace(String key, Object[] o) {
        if (bundle == null) {
            bundle = ResourceBundle.getBundle("com.ibm.ws.bootstrap.bootstrap");
        }
        try {
            String msg = bundle.getString(key);
            if (msg != null) {
                msg = MessageFormat.format(msg, o);
                out.println(msg);
                return;
            }
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        out.println(key);
        for (int i = 0; o != null && i < o.length; ++i) {
            out.println(o[i]);
        }
    }
}

