/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bootstrap;

import com.ibm.ws.bootstrap.ExtClassLoaderMBean;
import com.ibm.ws.bootstrap.WSLauncher;
import com.ibm.ws.classloader.WsClassLoader;
import com.ibm.ws.security.util.AccessController;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class ExtClassLoader
extends URLClassLoader
implements WsClassLoader,
ExtClassLoaderMBean {
    private Gateway gateway = null;
    private static ExtClassLoader instance;
    protected ArrayList containedPaths = new ArrayList();
    protected ArrayList nativePaths = new ArrayList();
    String classpath = null;
    String nativepath = null;

    public void installGateway(Gateway g) {
        if (this.gateway != null) {
            throw new IllegalStateException("Gateway cannot be installed twice");
        }
        this.gateway = g;
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return super.loadClass(name, resolve);
    }

    public static ExtClassLoader getInstance() {
        ClassLoader system;
        if (instance != null) {
            return instance;
        }
        ClassLoader parent = ExtClassLoader.class.getClassLoader();
        for (ClassLoader iter = system = ClassLoader.getSystemClassLoader(); iter != null; iter = iter.getParent()) {
            if (iter != parent) continue;
            parent = system;
            break;
        }
        instance = new ExtClassLoader(System.getProperty("ws.ext.dirs"), parent);
        return instance;
    }

    public ExtClassLoader(String extDirs) {
        this(extDirs, ClassLoader.getSystemClassLoader());
    }

    public ExtClassLoader(ClassLoader parent) {
        this((String)null, parent);
    }

    public ExtClassLoader(String extDirName, ClassLoader parent) {
        super(new URL[0], parent);
        if (extDirName != null) {
            this.addPath(extDirName);
        }
        if (instance == null) {
            instance = this;
        }
    }

    public Class findClass(String name) throws ClassNotFoundException {
        Class<?> c = super.findClass(name);
        if (WSLauncher.debug) {
            WSLauncher.out.println("[Loaded " + name + " by ExtClassLoader]");
        }
        return c;
    }

    protected String findLibrary(String libname) {
        String result;
        if (WSLauncher.debug) {
            WSLauncher.out.println("looking for library on nativepath: " + libname);
        }
        if ((result = this.findLibrary0(libname, this.nativePaths)) == null) {
            if (WSLauncher.debug) {
                WSLauncher.out.println("looking for library on classpath: " + libname);
            }
            result = this.findLibrary0(libname, this.containedPaths);
        }
        return result;
    }

    protected String findLibrary0(String libname, ArrayList pathList) {
        final String mappedLib = System.mapLibraryName(libname);
        final ArrayList paths = pathList;
        try {
            return (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    int sz = paths.size();
                    for (int i = 0; i < sz; ++i) {
                        URL url = (URL)paths.get(i);
                        File f = new File(url.getFile());
                        if (!f.isDirectory()) continue;
                        File lib = new File(f, mappedLib);
                        if (WSLauncher.debug) {
                            WSLauncher.out.println("File: " + lib.getPath() + (lib.isFile() ? " is a file" : " is not a file"));
                            WSLauncher.out.println("File: " + lib.getPath() + (lib.exists() ? " exists" : " does not exist"));
                        }
                        if (!lib.exists()) continue;
                        if (WSLauncher.debug) {
                            WSLauncher.out.println("library found: " + lib.getPath());
                        }
                        return lib.getPath();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            return null;
        }
    }

    public void addPath(String path) {
        if (path != null) {
            StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
            while (st.hasMoreTokens()) {
                Object[] files;
                File f;
                block17: {
                    block16: {
                        f = new File(st.nextToken());
                        if (!f.exists() && WSLauncher.debug) {
                            WSLauncher.out.println("ExtClassLoader:addPath - failed to find: " + f);
                        }
                        try {
                            f = f.getCanonicalFile();
                        }
                        catch (IOException ex) {
                            if (!WSLauncher.debug) break block16;
                            ex.printStackTrace(System.out);
                        }
                    }
                    if (f.isDirectory()) {
                        String[] dirFileList = f.list();
                        if (dirFileList != null) {
                            if (dirFileList.length == 0) {
                                if (!WSLauncher.debug) continue;
                                WSLauncher.out.println("ExtClassLoader:addPath - Skipping empty directory: " + f);
                                continue;
                            }
                        } else {
                            WSLauncher.out.println("ExtClassLoader:addPath - An exception occurred while trying to retrieve the list of files in the directory \"" + f + "\".  Verify the permissions associated with this directory");
                        }
                    }
                    try {
                        URL url = f.toURL();
                        this.addURL(url);
                    }
                    catch (Exception ex) {
                        if (!WSLauncher.debug) break block17;
                        ex.printStackTrace(WSLauncher.out);
                    }
                }
                if (!f.isDirectory()) continue;
                if (WSLauncher.debug) {
                    WSLauncher.out.println("Adding jar and zip files from " + f.getPath());
                }
                if ((files = f.list()) == null) continue;
                Arrays.sort(files);
                for (int j = 0; j < files.length; ++j) {
                    String lwr = ((String)files[j]).toLowerCase();
                    if (WSLauncher.debug) {
                        WSLauncher.out.println("Checking file " + lwr);
                    }
                    if (!lwr.endsWith(".jar") && !lwr.endsWith(".zip")) continue;
                    File jar = new File(f, (String)files[j]);
                    try {
                        this.addURL(jar.toURL());
                        continue;
                    }
                    catch (Exception ex) {
                        if (!WSLauncher.debug) continue;
                        ex.printStackTrace(WSLauncher.out);
                    }
                }
            }
        }
    }

    public void addURL(URL url) {
        if (!this.containedPaths.contains(url)) {
            this.containedPaths.add(url);
            super.addURL(url);
            this.classpath = null;
        }
    }

    public String getClassPath() {
        if (this.classpath == null) {
            StringBuffer sb = new StringBuffer();
            URL[] classpaths = super.getURLs();
            for (int i = 0; i < classpaths.length; ++i) {
                try {
                    File f = new File(classpaths[i].getFile());
                    sb.append(f.getCanonicalPath());
                    sb.append(File.pathSeparator);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            sb.append(System.getProperty("java.class.path"));
            this.classpath = sb.toString();
        }
        return this.classpath;
    }

    public URL[] getURLs() {
        return null;
    }

    public URL[] _getURLs() {
        return super.getURLs();
    }

    public void addNativePath(String paths) {
        if (paths == null) {
            if (WSLauncher.debug) {
                WSLauncher.out.println("Native path not added: invalid path argument (null)");
            }
        } else {
            File f = null;
            Exception err = null;
            StringTokenizer st = new StringTokenizer(paths, File.pathSeparator);
            while (st.hasMoreTokens()) {
                try {
                    f = new File(st.nextToken()).getCanonicalFile();
                    this.nativePaths.add(f.toURL());
                }
                catch (Exception e) {
                    err = e;
                }
                if (WSLauncher.debug) {
                    if (err != null) {
                        WSLauncher.out.println("An error occurred adding native path \"" + (f == null ? "null" : f.toString()) + "\": " + err);
                    } else if (!f.exists()) {
                        WSLauncher.out.println("Native path \"" + f.getPath() + "\" does not exist! Specify a directory containing a native library.");
                    } else if (!f.isDirectory()) {
                        WSLauncher.out.println("Native path \"" + f.getPath() + "\" is not a directory! Specify a directory containing a native library.");
                    } else {
                        String[] files = f.list();
                        if (files == null || files.length == 0) {
                            WSLauncher.out.println("Native path \"" + f.getPath() + "\" is empty! Specify a directory containing a native library.");
                        } else {
                            boolean containsNativeLib = false;
                            boolean containsClasses = false;
                            String flc = null;
                            for (int i = files.length - 1; i >= 0; --i) {
                                if (files[i] == null) continue;
                                flc = files[i].toLowerCase();
                                containsNativeLib |= flc.endsWith(".dll") || flc.endsWith(".so") || flc.endsWith(".a");
                                containsClasses |= flc.endsWith(".jar") || flc.endsWith(".zip") || flc.endsWith(".class");
                            }
                            if (!containsNativeLib) {
                                WSLauncher.out.println("Native path \"" + f.getPath() + "\" contains no native libraries! Specify a directory containing a native library.");
                            }
                            if (containsClasses) {
                                WSLauncher.out.println("Native path \"" + f.getPath() + "\" contains JAR/Zip/class files. Should path be in classpath also/instead?");
                            }
                        }
                    }
                }
                f = null;
                err = null;
            }
        }
    }

    public String getNativePath() {
        if (this.nativepath == null) {
            StringBuffer sb = new StringBuffer();
            Object[] nativepaths = this.nativePaths.toArray();
            for (int i = 0; i < this.nativePaths.size(); ++i) {
                try {
                    File f = new File(((URL)nativepaths[i]).getFile());
                    sb.append(f.getCanonicalPath());
                    sb.append(File.pathSeparator);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            this.nativepath = sb.toString();
        }
        return this.nativepath;
    }

    public URL findResource(String name) {
        URL resource = super.findResource(name);
        if (resource == null && this.gateway != null) {
            resource = this.gateway.findResource(name);
        }
        return resource;
    }

    public Enumeration findResources(String name) throws IOException {
        final Enumeration<URL> extensionResources = super.findResources(name);
        final URL[] resources = this.gateway != null ? this.gateway.findResources(name) : null;
        if (resources == null || resources.length == 0) {
            return extensionResources;
        }
        return new Enumeration(){
            int current = 0;

            public boolean hasMoreElements() {
                if (this.current < resources.length) {
                    return true;
                }
                return extensionResources.hasMoreElements();
            }

            public Object nextElement() {
                if (this.current < resources.length) {
                    return resources[this.current++];
                }
                return extensionResources.nextElement();
            }
        };
    }

    public static interface Gateway {
        public URL findResource(String var1);

        public URL[] findResources(String var1);
    }
}

