/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wssecurity.transport.token;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import java.lang.reflect.Method;
import java.util.HashMap;

public class HttpUtil {
    private static final String HTTP_AUTHZ_HEADER = "Authorization";
    private static final String SPNEGO_NEGOTIATE = "Negotiate ";
    private static final String REQUEST_TRANSPORT_HEADER = "com.ibm.websphere.webservices.requestTransportProperties";

    public static void addSPNEGOTokenInHTTPheader(byte[] token, Object messageContext) throws WSSException {
        try {
            Class[] parameterTypes = new Class[]{String.class};
            Method getProperty = messageContext.getClass().getMethod("getProperty", parameterTypes);
            Object[] args = new Object[]{REQUEST_TRANSPORT_HEADER};
            HashMap hm = (HashMap)getProperty.invoke(messageContext, args);
            if (hm != null) {
                String value = (String)hm.get(HTTP_AUTHZ_HEADER);
                if (value != null) {
                    throw new WSSException("HTTP Authorization header has already been set: " + value);
                }
                value = SPNEGO_NEGOTIATE + String.valueOf(HttpUtil.base64Encode(token));
                hm.put(HTTP_AUTHZ_HEADER, value);
            }
            parameterTypes = new Class[]{String.class, HashMap.class};
            Method setProperty = messageContext.getClass().getMethod("setProperty", parameterTypes);
            args = new Object[]{REQUEST_TRANSPORT_HEADER, hm};
            setProperty.invoke(messageContext, args);
        }
        catch (Exception ex) {
            throw new WSSException(ex);
        }
    }

    public static synchronized byte[] base64Encode(byte[] binaryData) {
        byte val2;
        byte val1;
        int i;
        int BASELENGTH = 255;
        int LOOKUPLENGTH = 64;
        int TWENTYFOURBITGROUP = 24;
        int EIGHTBIT = 8;
        int SIXTEENBIT = 16;
        int SIXBIT = 6;
        int FOURBYTE = 4;
        int SIGN = -128;
        int PAD = 61;
        byte[] base64Alphabet = new byte[BASELENGTH];
        byte[] lookUpBase64Alphabet = new byte[LOOKUPLENGTH];
        for (i = 0; i < BASELENGTH; ++i) {
            base64Alphabet[i] = -1;
        }
        for (i = 90; i >= 65; --i) {
            base64Alphabet[i] = (byte)(i - 65);
        }
        for (i = 122; i >= 97; --i) {
            base64Alphabet[i] = (byte)(i - 97 + 26);
        }
        for (i = 57; i >= 48; --i) {
            base64Alphabet[i] = (byte)(i - 48 + 52);
        }
        base64Alphabet[43] = 62;
        base64Alphabet[47] = 63;
        for (i = 0; i <= 25; ++i) {
            lookUpBase64Alphabet[i] = (byte)(65 + i);
        }
        i = 26;
        int j = 0;
        while (i <= 51) {
            lookUpBase64Alphabet[i] = (byte)(97 + j);
            ++i;
            ++j;
        }
        i = 52;
        j = 0;
        while (i <= 61) {
            lookUpBase64Alphabet[i] = (byte)(48 + j);
            ++i;
            ++j;
        }
        lookUpBase64Alphabet[62] = 43;
        lookUpBase64Alphabet[63] = 47;
        int lengthDataBits = binaryData.length * EIGHTBIT;
        int fewerThan24bits = lengthDataBits % TWENTYFOURBITGROUP;
        int numberTriplets = lengthDataBits / TWENTYFOURBITGROUP;
        byte[] encodedData = null;
        encodedData = fewerThan24bits != 0 ? new byte[(numberTriplets + 1) * 4] : new byte[numberTriplets * 4];
        byte k = 0;
        byte l = 0;
        byte b1 = 0;
        byte b2 = 0;
        byte b3 = 0;
        int encodedIndex = 0;
        int dataIndex = 0;
        int i2 = 0;
        for (i2 = 0; i2 < numberTriplets; ++i2) {
            dataIndex = i2 * 3;
            b1 = binaryData[dataIndex];
            b2 = binaryData[dataIndex + 1];
            b3 = binaryData[dataIndex + 2];
            l = (byte)(b2 & 0xF);
            k = (byte)(b1 & 3);
            encodedIndex = i2 * 4;
            val1 = (b1 & SIGN) == 0 ? (byte)(b1 >> 2) : (byte)(b1 >> 2 ^ 0xC0);
            val2 = (b2 & SIGN) == 0 ? (byte)(b2 >> 4) : (byte)(b2 >> 4 ^ 0xF0);
            byte val3 = (b3 & SIGN) == 0 ? (byte)(b3 >> 6) : (byte)(b3 >> 6 ^ 0xFC);
            encodedData[encodedIndex] = lookUpBase64Alphabet[val1];
            encodedData[encodedIndex + 1] = lookUpBase64Alphabet[val2 | k << 4];
            encodedData[encodedIndex + 2] = lookUpBase64Alphabet[l << 2 | val3];
            encodedData[encodedIndex + 3] = lookUpBase64Alphabet[b3 & 0x3F];
        }
        dataIndex = i2 * 3;
        encodedIndex = i2 * 4;
        if (fewerThan24bits == EIGHTBIT) {
            b1 = binaryData[dataIndex];
            k = (byte)(b1 & 3);
            val1 = (b1 & SIGN) == 0 ? (byte)(b1 >> 2) : (byte)(b1 >> 2 ^ 0xC0);
            encodedData[encodedIndex] = lookUpBase64Alphabet[val1];
            encodedData[encodedIndex + 1] = lookUpBase64Alphabet[k << 4];
            encodedData[encodedIndex + 2] = PAD;
            encodedData[encodedIndex + 3] = PAD;
        } else if (fewerThan24bits == SIXTEENBIT) {
            b1 = binaryData[dataIndex];
            b2 = binaryData[dataIndex + 1];
            l = (byte)(b2 & 0xF);
            k = (byte)(b1 & 3);
            val1 = (b1 & SIGN) == 0 ? (byte)(b1 >> 2) : (byte)(b1 >> 2 ^ 0xC0);
            val2 = (b2 & SIGN) == 0 ? (byte)(b2 >> 4) : (byte)(b2 >> 4 ^ 0xF0);
            encodedData[encodedIndex] = lookUpBase64Alphabet[val1];
            encodedData[encodedIndex + 1] = lookUpBase64Alphabet[val2 | k << 4];
            encodedData[encodedIndex + 2] = lookUpBase64Alphabet[l << 2];
            encodedData[encodedIndex + 3] = PAD;
        }
        return encodedData;
    }
}

