/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wssecurity.callbackhandler;

import com.ibm.websphere.wssecurity.callbackhandler.X509ConsumeCallback;
import com.ibm.wsspi.wssecurity.core.config.CallbackHandlerConfig;
import com.ibm.wsspi.wssecurity.core.config.KeyInformationConfig;
import com.ibm.wsspi.wssecurity.core.config.KeyStoreConfig;
import java.io.IOException;
import java.io.Serializable;
import java.security.Provider;
import java.security.cert.PKIXBuilderParameters;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X509ConsumeCallbackHandler
implements CallbackHandler,
Serializable {
    private static final long serialVersionUID = 4652590475346979402L;
    private boolean existKeyStore;
    private boolean trustAnyCertificate;
    private String keyStoreRef;
    private String keyStorePath;
    private String keyStoreType;
    private char[] keyStorePassword;
    private String alias;
    private char[] keyPassword;
    private String keyName;
    private String trustAnchorPath;
    private String trustAnchorType;
    private char[] trustAnchorPassword;
    private List certStores;
    private PKIXBuilderParameters certPathParam;
    private Provider provider;

    public X509ConsumeCallbackHandler(Map<Object, Object> properties) {
        this.existKeyStore = false;
        this.trustAnyCertificate = false;
        CallbackHandlerConfig chconfig = (CallbackHandlerConfig)properties.get("com.ibm.wsspi.wssecurity.impl.config.callbackHandler.configKey");
        if (chconfig != null) {
            KeyInformationConfig kiconfig;
            this.trustAnyCertificate = chconfig.isTrustAnyCertificate();
            this.certStores = chconfig.getCertStores();
            this.certPathParam = chconfig.getPKIXBuilderParameters();
            this.provider = chconfig.getProvider();
            KeyStoreConfig ksconfig = chconfig.getResolvingKeyStore();
            if (ksconfig != null) {
                this.existKeyStore = true;
                this.keyStoreRef = ksconfig.getKsRef();
                this.keyStorePath = ksconfig.getPath();
                this.keyStoreType = ksconfig.getType();
                String tmp = ksconfig.getPassword();
                char[] cArray = this.keyStorePassword = tmp == null ? null : tmp.toCharArray();
            }
            if ((kiconfig = chconfig.getKeyInformation()) != null) {
                this.alias = kiconfig.getAlias();
                this.keyName = kiconfig.getName();
                String tmp = kiconfig.getKeyPass();
                this.keyPassword = tmp == null ? null : tmp.toCharArray();
            }
        }
    }

    public X509ConsumeCallbackHandler(String keyStoreRef, String keyStorePath, String keyStoreType, char[] keyStorePassword, String alias, char[] keyPassword, String keyName, String trustAnchorPath, String trustAnchorType, char[] trustAnchorPassword, List certStores, Provider provider) {
        this.existKeyStore = true;
        this.trustAnyCertificate = false;
        this.keyStoreRef = keyStoreRef;
        this.keyStorePath = keyStorePath;
        this.keyStoreType = keyStoreType;
        this.keyStorePassword = keyStorePassword;
        this.alias = alias;
        this.keyPassword = (char[])(keyPassword != null && keyPassword.length != 0 ? keyPassword : null);
        this.keyName = keyName;
        this.trustAnchorPath = trustAnchorPath;
        this.trustAnchorType = trustAnchorType;
        if (trustAnchorPassword != null && trustAnchorPassword.length != 0) {
            this.trustAnchorPassword = trustAnchorPassword;
        } else {
            this.keyPassword = null;
        }
        this.certStores = certStores;
        this.provider = provider;
    }

    public X509ConsumeCallbackHandler(String keyStoreRef, String keyStorePath, String keyStoreType, char[] keyStorePassword, String alias, char[] keyPassword, String keyName) {
        this.existKeyStore = true;
        this.trustAnyCertificate = true;
        this.keyStoreRef = keyStoreRef;
        this.keyStorePath = keyStorePath;
        this.keyStoreType = keyStoreType;
        this.keyStorePassword = keyStorePassword;
        this.alias = alias;
        this.keyPassword = (char[])(keyPassword != null && keyPassword.length != 0 ? keyPassword : null);
        this.keyName = keyName;
    }

    public X509ConsumeCallbackHandler(String trustAnchorPath, String trustAnchorType, char[] trustAnchorPassword, List certStores, Provider provider) {
        this.existKeyStore = false;
        this.trustAnyCertificate = false;
        this.trustAnchorPath = trustAnchorPath;
        this.trustAnchorType = trustAnchorType;
        this.trustAnchorPassword = trustAnchorPassword;
        this.certStores = certStores;
        this.provider = provider;
    }

    public X509ConsumeCallbackHandler() {
        this.existKeyStore = false;
        this.trustAnyCertificate = true;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks == null || callbacks.length == 0) {
            throw new UnsupportedCallbackException(null, "There is no callback.");
        }
        for (int i = 0; i < callbacks.length; ++i) {
            Callback callback = callbacks[i];
            if (!(callback instanceof X509ConsumeCallback)) continue;
            X509ConsumeCallback x509Callback = (X509ConsumeCallback)callback;
            x509Callback.setExistKeyStore(this.existKeyStore);
            x509Callback.setKeyStoreReference(this.keyStoreRef);
            x509Callback.setKeyStorePath(this.keyStorePath);
            x509Callback.setKeyStoreType(this.keyStoreType);
            x509Callback.setKeyStorePassword(this.keyStorePassword);
            x509Callback.setAlias(this.alias);
            x509Callback.setKeyPassword(this.keyPassword);
            x509Callback.setKeyName(this.keyName);
            x509Callback.setTrustAnyCertificate(this.trustAnyCertificate);
            x509Callback.setTrustAnchorPath(this.trustAnchorPath);
            x509Callback.setTrustAnchorType(this.trustAnchorType);
            x509Callback.setTrustAnchorPassword(this.trustAnchorPassword);
            x509Callback.setCertStores(this.certStores);
            x509Callback.setCertPathParameter(this.certPathParam);
            x509Callback.setProvider(this.provider);
        }
    }
}

