/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wssecurity.callbackhandler;

import com.ibm.websphere.wssecurity.callbackhandler.UNTGenerateCallback;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.config.CallbackHandlerConfig;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UNTGenerateCallbackHandler
implements CallbackHandler,
Serializable {
    private static final long serialVersionUID = 3486899256146086776L;
    private String userid;
    private char[] password;
    private boolean identityAssertion = false;
    private boolean runAsSubject = false;
    private boolean sendRealm = false;
    private boolean nonce = false;
    private boolean createdTimestamp = false;
    private boolean trustedRealm = false;
    private static final String[] TRUE_VALUES = new String[]{"yes", "on", "true", "1"};

    public static boolean isTrue(String flag) {
        boolean ret = false;
        if (flag != null) {
            flag = flag.trim();
            for (int i = 0; i < TRUE_VALUES.length; ++i) {
                if (!TRUE_VALUES[i].equalsIgnoreCase(flag)) continue;
                return true;
            }
        }
        return ret;
    }

    public UNTGenerateCallbackHandler(Map<Object, Object> properties) {
        CallbackHandlerConfig config2 = (CallbackHandlerConfig)properties.get("com.ibm.wsspi.wssecurity.impl.config.callbackHandler.configKey");
        if (config2 != null) {
            this.userid = config2.getUserId();
            this.password = config2.getUserPassword();
            Object obj = config2.getProperties().get(Constants.WSSECURITY_USE_IDASSERTION);
            if (obj != null) {
                this.identityAssertion = UNTGenerateCallbackHandler.isTrue(obj.toString());
            }
            if ((obj = config2.getProperties().get(Constants.WSSECURITY_USE_RUNASIDENTITY)) != null) {
                this.runAsSubject = UNTGenerateCallbackHandler.isTrue(obj.toString());
            }
            if ((obj = config2.getProperties().get(Constants.WSSECURITY_SEND_REALM)) != null) {
                this.sendRealm = UNTGenerateCallbackHandler.isTrue(obj.toString());
            }
            if ((obj = config2.getProperties().get(Constants.WSSECURITY_TRUSTED_REALM)) != null) {
                this.trustedRealm = UNTGenerateCallbackHandler.isTrue(obj.toString());
            }
            if ((obj = config2.getProperties().get(Constants.WSSECURITY_ADD_NONCE)) != null) {
                this.nonce = UNTGenerateCallbackHandler.isTrue(obj.toString());
            }
            if ((obj = config2.getProperties().get(Constants.WSSECURITY_ADD_TIMESTAMP)) != null) {
                this.createdTimestamp = UNTGenerateCallbackHandler.isTrue(obj.toString());
            }
        }
    }

    public UNTGenerateCallbackHandler(String userid, String password) {
        this.userid = userid;
        this.password = password == null ? null : password.toCharArray();
        this.identityAssertion = false;
        this.runAsSubject = false;
        this.sendRealm = false;
        this.trustedRealm = false;
        this.nonce = false;
        this.createdTimestamp = false;
    }

    public UNTGenerateCallbackHandler(String userid, String password, boolean setNonce, boolean setCreatedTimestamp) {
        this.userid = userid;
        this.password = password == null ? null : password.toCharArray();
        this.identityAssertion = false;
        this.runAsSubject = false;
        this.sendRealm = false;
        this.trustedRealm = false;
        this.nonce = setNonce;
        this.createdTimestamp = setCreatedTimestamp;
    }

    public UNTGenerateCallbackHandler(boolean useRunAsSubject, boolean sendRealm) {
        this.userid = null;
        this.password = null;
        this.identityAssertion = true;
        this.runAsSubject = useRunAsSubject;
        this.sendRealm = sendRealm;
        this.trustedRealm = false;
        this.nonce = false;
        this.createdTimestamp = false;
    }

    public UNTGenerateCallbackHandler(boolean useRunAsSubject, boolean sendRealm, boolean trustedRealm) {
        this.userid = null;
        this.password = null;
        this.identityAssertion = true;
        this.runAsSubject = useRunAsSubject;
        this.sendRealm = sendRealm;
        this.trustedRealm = trustedRealm;
        this.nonce = false;
        this.createdTimestamp = false;
    }

    public UNTGenerateCallbackHandler(boolean useIdentityAssertion) {
        this.userid = null;
        this.password = null;
        this.identityAssertion = useIdentityAssertion;
        this.runAsSubject = false;
        this.sendRealm = false;
        this.trustedRealm = false;
        this.nonce = false;
        this.createdTimestamp = false;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks == null || callbacks.length == 0) {
            throw new UnsupportedCallbackException(null, "There is no callback.");
        }
        for (int i = 0; i < callbacks.length; ++i) {
            Callback callback = callbacks[i];
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this.userid);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(this.password);
                continue;
            }
            if (!(callback instanceof UNTGenerateCallback)) continue;
            ((UNTGenerateCallback)callback).setUsingIdentityAssertion(this.identityAssertion);
            ((UNTGenerateCallback)callback).setUsingRunAsSubject(this.runAsSubject);
            ((UNTGenerateCallback)callback).setSendRealm(this.sendRealm);
            ((UNTGenerateCallback)callback).setUsingTrustedRealm(this.trustedRealm);
            ((UNTGenerateCallback)callback).setNonce(this.nonce);
            ((UNTGenerateCallback)callback).setCreatedTimestamp(this.createdTimestamp);
        }
    }
}

