/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wssecurity.callbackhandler;

import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.token.UsernameToken;
import com.ibm.ws.wssecurity.platform.auth.WSSContext;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManagerFactory;
import com.ibm.ws.wssecurity.util.LoginPanel;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.SecurityTokenWrapper;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.swing.JFrame;
import org.apache.axis2.context.MessageContext;

public class UNTGUIPromptCallbackHandler
implements CallbackHandler,
Serializable {
    private static final long serialVersionUID = 8793785569405324482L;
    private static final TraceComponent tc = Tr.register(UNTGUIPromptCallbackHandler.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private String userid;
    private String password;
    private String realmName = "<default>";
    private String userNamePrompt = "";
    private String passwordPrompt = "";
    private int result = 0;

    public UNTGUIPromptCallbackHandler() {
    }

    public UNTGUIPromptCallbackHandler(Map properties) {
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks == null || callbacks.length == 0) {
            throw new UnsupportedCallbackException(null, "There is no callback.");
        }
        boolean done = false;
        int retries = 0;
        for (int i = 0; i < callbacks.length; ++i) {
            Map<Object, Object> context;
            MessageContext messageContext;
            Callback c = callbacks[i];
            if (c instanceof NameCallback) {
                this.userNamePrompt = ((NameCallback)c).getPrompt();
                this.userid = ((NameCallback)c).getDefaultName();
                continue;
            }
            if (c instanceof PasswordCallback) {
                this.passwordPrompt = ((PasswordCallback)c).getPrompt();
                continue;
            }
            if (!(c instanceof PropertyCallback) || (messageContext = (MessageContext)(context = ((PropertyCallback)c).getProperties()).get("com.ibm.wsspi.wssecurity.core.messageContext")) == null) continue;
            SecurityToken obj = null;
            if (!WSSContextManagerFactory.getInstance().processIsServer()) {
                Set<SecurityTokenWrapper> set;
                Subject subject;
                block22: {
                    WSSContext sContext = (WSSContext)messageContext.getProperty("com.ibm.wsspi.websphere.security.SecurityContext");
                    subject = null;
                    try {
                        subject = sContext.getRunAsSubject(messageContext);
                    }
                    catch (SoapSecurityException se) {
                        if (!tc.isDebugEnabled()) break block22;
                        Tr.debug(tc, "Exception caught " + se.getMessage());
                    }
                }
                if (subject != null && (set = subject.getPrivateCredentials(SecurityTokenWrapper.class)) != null && !set.isEmpty()) {
                    for (SecurityTokenWrapper stw : set) {
                        SecurityToken t = stw.getSecurityToken();
                        if (t == null || !(t instanceof UsernameToken) || stw.getEndPoint() == null || stw.getEndPoint().length() <= 0 || messageContext.getTo() == null || !messageContext.getTo().getAddress().equals(stw.getEndPoint())) continue;
                        obj = t;
                        break;
                    }
                }
            }
            if (obj == null || !(obj instanceof UsernameToken)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The cached username token is used.");
            }
            return;
        }
        LoginPanel lgpanel = null;
        JFrame tmpFrame = null;
        while (!done) {
            tmpFrame = new JFrame();
            lgpanel = new LoginPanel(this.userid, this.realmName, "", tmpFrame);
            this.result = lgpanel.showPanel();
            if (this.result == 2) {
                String sn = lgpanel.getId();
                if (sn != null && sn.length() > 0) {
                    this.userid = new String(sn.trim());
                    if (this.userid != null && this.userid.length() > 0) {
                        String pw = lgpanel.getPassword();
                        this.password = pw != null && pw.length() > 0 ? new String(pw) : "";
                        lgpanel.dispose();
                        lgpanel = null;
                        tmpFrame.dispose();
                        tmpFrame = null;
                        done = true;
                    } else {
                        this.userid = "";
                        this.password = "";
                    }
                } else {
                    this.userid = "";
                    this.password = "";
                }
                if (!done) {
                    lgpanel.dispose();
                    lgpanel = null;
                    tmpFrame.dispose();
                    tmpFrame = null;
                    if (retries < 1) {
                        ++retries;
                    } else {
                        done = true;
                    }
                }
            } else {
                lgpanel.dispose();
                lgpanel = null;
                tmpFrame.dispose();
                tmpFrame = null;
                this.userid = null;
                this.password = null;
                done = true;
            }
            if (tmpFrame == null) continue;
            tmpFrame.dispose();
            tmpFrame = null;
        }
        for (int i = 0; i < callbacks.length; ++i) {
            Callback callback = callbacks[i];
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this.userid);
                continue;
            }
            if (!(callback instanceof PasswordCallback)) continue;
            ((PasswordCallback)callback).setPassword(this.password == null ? new char[]{} : this.password.toCharArray());
        }
    }
}

