/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wssecurity.callbackhandler;

import com.ibm.websphere.wssecurity.callbackhandler.DerivedKeyInfoCallback;
import com.ibm.websphere.wssecurity.callbackhandler.SCTGenerateCallback;
import com.ibm.websphere.wssecurity.wssapi.WSSConsumingContext;
import com.ibm.websphere.wssecurity.wssapi.WSSGenerationContext;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityContextToken;
import java.io.IOException;
import java.io.Serializable;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Dispatch;

public class SCTGenerateCallbackHandler
implements CallbackHandler,
Serializable {
    private static final long serialVersionUID = 4562705769327050747L;
    private WSSGenerationContext gencont;
    private WSSConsumingContext concont;
    private String serviceEndpointAddress;
    private boolean requiredDKT;
    private String signatureAlgorithm = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
    private int signatureKeyBytesLength;
    private String encyptionAlgorithm = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
    private int encyptionKeyBytesLength;
    private SecurityContextToken token;
    private String clientLabel;
    private String serviceLabel;
    private BindingProvider bindingProvider;
    private BindingProvider axis2BindingProvider;
    private int keylenghth = 0;
    private int nonceLength = 16;

    public SCTGenerateCallbackHandler(WSSGenerationContext gencont, WSSConsumingContext concont, String serviceEndpointAddress, boolean requiredDKT) {
        this.gencont = gencont;
        this.concont = concont;
        this.serviceEndpointAddress = serviceEndpointAddress;
        this.requiredDKT = requiredDKT;
    }

    public SCTGenerateCallbackHandler(WSSGenerationContext gencont, WSSConsumingContext concont, String serviceEndpointAddress, String encryptionAlgorithm) {
        this.gencont = gencont;
        this.concont = concont;
        this.serviceEndpointAddress = serviceEndpointAddress;
        this.requiredDKT = true;
        this.encyptionAlgorithm = encryptionAlgorithm;
    }

    public SCTGenerateCallbackHandler(WSSGenerationContext gencont, WSSConsumingContext concont) {
        this.gencont = gencont;
        this.concont = concont;
        this.requiredDKT = true;
    }

    public SCTGenerateCallbackHandler(SecurityContextToken token, WSSGenerationContext gencont, WSSConsumingContext concont, String signatureAlgorithm, int signatureKeyLength, String encryptionAlgorithm, int encryptionKeyLength, String serviceLabel, String clientLabel) {
        this.token = token;
        this.gencont = gencont;
        this.concont = concont;
        this.requiredDKT = true;
        this.signatureAlgorithm = signatureAlgorithm;
        this.signatureKeyBytesLength = signatureKeyLength;
        this.encyptionAlgorithm = encryptionAlgorithm;
        this.encyptionKeyBytesLength = encryptionKeyLength;
        this.serviceLabel = serviceLabel;
        this.clientLabel = clientLabel;
    }

    public SCTGenerateCallbackHandler(WSSGenerationContext gencont, WSSConsumingContext concont, String serviceEndpointAddress, boolean requiredDKT, Dispatch dispatch) {
        this.gencont = gencont;
        this.concont = concont;
        this.serviceEndpointAddress = serviceEndpointAddress;
        this.requiredDKT = requiredDKT;
        this.axis2BindingProvider = dispatch;
    }

    public SCTGenerateCallbackHandler(WSSGenerationContext gencont, WSSConsumingContext concont, String serviceEndpointAddress, Dispatch dispatch) {
        this.gencont = gencont;
        this.concont = concont;
        this.serviceEndpointAddress = serviceEndpointAddress;
        this.requiredDKT = true;
        this.axis2BindingProvider = dispatch;
    }

    public SCTGenerateCallbackHandler(WSSGenerationContext gencont, WSSConsumingContext concont, Dispatch dispatch) {
        this.gencont = gencont;
        this.concont = concont;
        this.requiredDKT = true;
        this.axis2BindingProvider = dispatch;
    }

    public SCTGenerateCallbackHandler(SecurityContextToken token, WSSGenerationContext gencont, WSSConsumingContext concont, String signatureAlgorithm, int signatureKeyLength, String encryptionAlgorithm, int encryptionKeyLength, String serviceLabel, String clientLabel, Dispatch dispatch) {
        this.token = token;
        this.gencont = gencont;
        this.concont = concont;
        this.requiredDKT = true;
        this.signatureAlgorithm = signatureAlgorithm;
        this.signatureKeyBytesLength = signatureKeyLength;
        this.encyptionAlgorithm = encryptionAlgorithm;
        this.encyptionKeyBytesLength = encryptionKeyLength;
        this.serviceLabel = serviceLabel;
        this.clientLabel = clientLabel;
        this.axis2BindingProvider = dispatch;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks == null || callbacks.length == 0) {
            throw new UnsupportedCallbackException(null, "There is no callback.");
        }
        for (int i = 0; i < callbacks.length; ++i) {
            Callback callback = callbacks[i];
            if (callback instanceof SCTGenerateCallback) {
                SCTGenerateCallback sctGenerateCallback = (SCTGenerateCallback)callback;
                sctGenerateCallback.setWSSConsumingContext(this.concont);
                sctGenerateCallback.setWSSGenerationContext(this.gencont);
                sctGenerateCallback.setServiceEndpointAddress(this.serviceEndpointAddress);
                sctGenerateCallback.setRequiredDKT(this.requiredDKT);
                sctGenerateCallback.setSignatureAlgorithm(this.signatureAlgorithm);
                sctGenerateCallback.setSignatureKeyBytesLength(this.signatureKeyBytesLength);
                sctGenerateCallback.setEncyptionAlgorithm(this.encyptionAlgorithm);
                sctGenerateCallback.setEncyptionKeyBytesLength(this.encyptionKeyBytesLength);
                sctGenerateCallback.setToken(this.token);
                sctGenerateCallback.setServiceLabel(this.serviceLabel);
                sctGenerateCallback.setClientLabel(this.clientLabel);
                sctGenerateCallback.setBindingProvider(this.axis2BindingProvider);
            }
            if (!(callback instanceof DerivedKeyInfoCallback)) continue;
            DerivedKeyInfoCallback dkcallback = (DerivedKeyInfoCallback)callback;
            dkcallback.setClientLabel(this.clientLabel);
            dkcallback.setServerLabel(this.serviceLabel);
            dkcallback.setKeyBytesLength(this.keylenghth);
            dkcallback.setNonceBytesLength(this.nonceLength);
            dkcallback.setRequiredDKT(this.requiredDKT);
        }
    }

    public String getClientLabel() {
        return this.clientLabel;
    }

    public String getServerLabel() {
        return this.serviceLabel;
    }

    public boolean getRequiredDKT() {
        return this.requiredDKT;
    }

    public int getKeyBytesLength() {
        return this.keylenghth;
    }

    public int getNonceBytesLength() {
        return this.nonceLength;
    }
}

