/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wssecurity.callbackhandler;

import com.ibm.websphere.wssecurity.callbackhandler.DerivedKeyInfoCallback;
import com.ibm.websphere.wssecurity.callbackhandler.KRBTokenConsumeCallback;
import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.websphere.wssecurity.callbackhandler.SharedContextCallback;
import com.ibm.websphere.wssecurity.wssapi.decryption.WSSDecryption;
import com.ibm.websphere.wssecurity.wssapi.verification.WSSVerification;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.config.TokenConsumerConfig;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KRBTokenConsumeCallbackHandler
implements CallbackHandler,
Serializable {
    private static final long serialVersionUID = 5739806943302253015L;
    private QName tokentype = null;
    private int keylength = 0;
    private int nonceLength = 16;
    private boolean requiredDKT = false;
    private boolean sha1AsSupportToken = false;
    private String clientLabel = Constants.DEFAULT_DERIVEDKEY_LABEL;
    private String serviceLabel = Constants.DEFAULT_DERIVEDKEY_LABEL;
    private boolean useWSSAPI = false;
    private static final String CONSUME_CALLBACK_BY_WSSAPI = "com.ibm.wsspi.wssecurity.krbtoken.consumeCallbackByWSSAPI:";
    private WSSDecryption wssDecryption;
    private WSSVerification wssVerification;

    public KRBTokenConsumeCallbackHandler(Map<Object, Object> properties) {
        TokenConsumerConfig tconfig = (TokenConsumerConfig)properties.get("com.ibm.wsspi.wssecurity.impl.config.tokenConsumer.configKey");
        if (tconfig != null) {
            this.tokentype = tconfig.getType();
        }
    }

    public KRBTokenConsumeCallbackHandler(QName tkntype, boolean supportTokenRequireSHA1, WSSDecryption decComponent, WSSVerification verComponent) {
        this.tokentype = tkntype;
        this.useWSSAPI = true;
        this.sha1AsSupportToken = supportTokenRequireSHA1;
        this.wssDecryption = decComponent;
        this.wssVerification = verComponent;
    }

    public KRBTokenConsumeCallbackHandler(QName tokenValueType, boolean requireDKT, String clabel, String slabel, int keylen, int noncelen, boolean supportTokenRequireSHA1, WSSDecryption decComponent, WSSVerification verComponent) {
        this.tokentype = tokenValueType;
        this.requiredDKT = requireDKT;
        if (clabel != null) {
            this.clientLabel = clabel;
        }
        if (slabel != null) {
            this.serviceLabel = slabel;
        }
        this.keylength = keylen;
        this.nonceLength = noncelen;
        this.useWSSAPI = true;
        this.sha1AsSupportToken = supportTokenRequireSHA1;
        this.wssDecryption = decComponent;
        this.wssVerification = verComponent;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof PropertyCallback) {
                TokenConsumerConfig tconfig;
                Map<Object, Object> context = ((PropertyCallback)callbacks[i]).getProperties();
                if (context == null || this.useWSSAPI || (tconfig = (TokenConsumerConfig)context.get("com.ibm.wsspi.wssecurity.impl.config.tokenConsumer.configKey")) == null) continue;
                this.tokentype = tconfig.getType();
                continue;
            }
            if (callbacks[i] instanceof KRBTokenConsumeCallback) {
                ((KRBTokenConsumeCallback)callbacks[i]).setValueType(this.tokentype);
                continue;
            }
            if (callbacks[i] instanceof DerivedKeyInfoCallback) {
                if (!this.useWSSAPI) continue;
                ((DerivedKeyInfoCallback)callbacks[i]).setRequiredDKT(this.requiredDKT);
                ((DerivedKeyInfoCallback)callbacks[i]).setClientLabel(this.clientLabel);
                ((DerivedKeyInfoCallback)callbacks[i]).setServerLabel(this.serviceLabel);
                ((DerivedKeyInfoCallback)callbacks[i]).setKeyBytesLength(this.keylength);
                ((DerivedKeyInfoCallback)callbacks[i]).setNonceBytesLength(this.nonceLength);
                continue;
            }
            if (callbacks[i] instanceof SharedContextCallback) {
                SharedContextCallback sharedCallback = (SharedContextCallback)callbacks[i];
                sharedCallback.setWSSDecryption(this.wssDecryption);
                sharedCallback.setWSSVerification(this.wssVerification);
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i], callbacks[i].getClass() + " is not recognised callback ");
        }
    }
}

