/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wssecurity.admin;

import com.ibm.websphere.wssecurity.admin.PolicyAttributesConstants;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;

public class PolicyAttributesUtil
implements PolicyAttributesConstants {
    private static TraceComponent tc = Tr.register(PolicyAttributesUtil.class, "wssecuirty.admin", "com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");
    private static PolicyAttributesUtil util = new PolicyAttributesUtil();

    public static PolicyAttributesUtil getInstance() {
        return util;
    }

    public Properties attributeListToProperties(AttributeList attrList) {
        return this.attributeListToProperties(attrList, null);
    }

    public Properties attributeListToProperties(AttributeList attrList, Properties requestedProps) {
        Properties props = new Properties();
        if (attrList == null) {
            return props;
        }
        for (int i = 0; i < attrList.size(); ++i) {
            props.putAll((Map<?, ?>)this.attributeToProps(null, (Attribute)attrList.get(i), requestedProps));
        }
        return props;
    }

    public AttributeList propertiesToAttributeList(Properties props) {
        AttributeList attrList = new AttributeList();
        if (props == null || props.isEmpty()) {
            return attrList;
        }
        AttributeList startAttrList = null;
        Attribute attr = null;
        String name = null;
        String value = null;
        String nameToken = null;
        StringTokenizer tokens = null;
        ArrayList<String> tokenList = null;
        boolean createAttributeList = false;
        Enumeration<?> names = props.propertyNames();
        while (names.hasMoreElements()) {
            name = (String)names.nextElement();
            value = props.getProperty(name);
            tokens = new StringTokenizer(name, ".");
            tokenList = new ArrayList<String>();
            while (tokens.hasMoreTokens()) {
                tokenList.add(tokens.nextToken());
            }
            startAttrList = attrList;
            for (int i = 0; i < tokenList.size(); ++i) {
                nameToken = (String)tokenList.get(i);
                createAttributeList = i < tokenList.size() - 1 ? true : "remove".equals(value);
                attr = this.getAttribute(startAttrList, nameToken, createAttributeList, value);
                if (!createAttributeList) continue;
                startAttrList = (AttributeList)attr.getValue();
            }
        }
        return attrList;
    }

    private Attribute getAttribute(AttributeList attrList, String token, boolean containAttrList, String value) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getAttribute: token=" + token + ", containAttrList=" + containAttrList);
        }
        Attribute attr = null;
        boolean found = false;
        for (int i = 0; i < attrList.size(); ++i) {
            attr = (Attribute)attrList.get(i);
            if (!attr.getName().equals(token)) continue;
            found = true;
            break;
        }
        if (found) {
            return attr;
        }
        if (containAttrList) {
            attr = new Attribute(token, new AttributeList());
            attrList.add(attr);
        } else {
            attr = new Attribute(token, value);
            attrList.add(attr);
        }
        return attr;
    }

    private Properties attributeToProps(String prefix, Attribute attr, Properties requestedProps) {
        Properties props = new Properties();
        Object value = attr.getValue();
        String key = attr.getName();
        String newPrefix = null;
        newPrefix = prefix == null ? key : prefix + "." + key;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "attributeToProps, prefix=" + prefix + ", newPrefix=" + newPrefix + ", attr name=" + attr.getName() + ", attr value=" + attr.getValue());
        }
        if (value == null) {
            return new Properties();
        }
        if (value instanceof AttributeList) {
            AttributeList attrList = (AttributeList)value;
            if (attrList.size() == 0) {
                return new Properties();
            }
            for (int i = 0; i < attrList.size(); ++i) {
                Properties subProps = this.attributeToProps(newPrefix, (Attribute)attrList.get(i), requestedProps);
                props.putAll((Map<?, ?>)subProps);
            }
            return props;
        }
        if (this.isRequested(newPrefix, requestedProps)) {
            props.put(newPrefix, value);
        }
        return props;
    }

    private boolean isRequested(String newPrefix, Properties requestedProps) {
        if (requestedProps == null || requestedProps.size() == 0) {
            return true;
        }
        Enumeration<?> requestedKeys = requestedProps.propertyNames();
        while (requestedKeys.hasMoreElements()) {
            if (!newPrefix.startsWith((String)requestedKeys.nextElement())) continue;
            return true;
        }
        return false;
    }
}

