/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wsaddressing.jaxws21;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.wsaddressing.jaxws21.SubmissionEndpointReference;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.addressing.util.EndpointReferenceUtils;
import org.w3c.dom.Element;

public final class SubmissionEndpointReferenceBuilder {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wsaddressing.jaxws.CWWARMessages");
    private static final Element[] ZERO_LENGTH_ARRAY = new Element[0];
    private String address;
    private QName serviceName;
    private QName endpointName;
    private String wsdlDocumentLocation;
    private List<Element> referenceParameters;
    private QName portType;

    public SubmissionEndpointReferenceBuilder address(String address) {
        this.address = address;
        return this;
    }

    public SubmissionEndpointReferenceBuilder serviceName(QName serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public SubmissionEndpointReferenceBuilder endpointName(QName endpointName) {
        if (this.serviceName == null) {
            throw new IllegalStateException(nls.getString("MISSING_SERVICE_QNAME_CWWAR0018"));
        }
        this.endpointName = endpointName;
        return this;
    }

    public SubmissionEndpointReferenceBuilder wsdlDocumentLocation(String wsdlDocumentLocation) {
        this.wsdlDocumentLocation = wsdlDocumentLocation;
        return this;
    }

    public SubmissionEndpointReferenceBuilder referenceProperty(Element referenceProperty) {
        if (referenceProperty == null) {
            throw new IllegalArgumentException(nls.getString("NULL_REFERENCE_PARAMETER_CWWAR0019"));
        }
        if (this.referenceParameters == null) {
            this.referenceParameters = new ArrayList<Element>();
        }
        this.referenceParameters.add(referenceProperty);
        return this;
    }

    public SubmissionEndpointReferenceBuilder referenceParameter(Element referenceParameter) {
        if (referenceParameter == null) {
            throw new IllegalArgumentException(nls.getString("NULL_REFERENCE_PARAMETER_CWWAR0019"));
        }
        if (this.referenceParameters == null) {
            this.referenceParameters = new ArrayList<Element>();
        }
        this.referenceParameters.add(referenceParameter);
        return this;
    }

    public SubmissionEndpointReferenceBuilder portType(QName portType) {
        this.portType = portType;
        return this;
    }

    public SubmissionEndpointReference build() {
        SubmissionEndpointReference submissionEPR = null;
        String addressingNamespace = EndpointReferenceUtils.getAddressingNamespace(SubmissionEndpointReference.class);
        EndpointReference axis2EPR = EndpointReferenceUtils.createAxis2EndpointReference(this.address, this.serviceName, this.endpointName, this.wsdlDocumentLocation, addressingNamespace);
        try {
            if (this.referenceParameters != null) {
                EndpointReferenceUtils.addReferenceParameters(axis2EPR, this.referenceParameters.toArray(ZERO_LENGTH_ARRAY));
            }
            if (this.portType != null) {
                EndpointReferenceUtils.addInterface(axis2EPR, this.portType, addressingNamespace);
            }
            submissionEPR = (SubmissionEndpointReference)EndpointReferenceUtils.convertFromAxis2(axis2EPR, addressingNamespace);
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException(nls.getString("UNABLE_TO_CREATE_AN_EPR_CWWAR0013"), e);
        }
        return submissionEPR;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.address != null) {
            buffer.append("Address: ").append(this.address);
        }
        if (this.serviceName != null) {
            buffer.append(", Service name: ").append(this.serviceName);
        }
        if (this.endpointName != null) {
            buffer.append(", Endpoint name: ").append(this.endpointName);
        }
        if (this.portType != null) {
            buffer.append(", Port type: ").append(this.portType);
        }
        if (this.referenceParameters != null) {
            buffer.append(", Reference parameters: ").append(this.referenceParameters);
        }
        if (this.wsdlDocumentLocation != null) {
            buffer.append(", WSDL location: ").append(this.wsdlDocumentLocation);
        }
        return buffer.toString();
    }
}

