/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wsaddressing.jaxws21;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.wsaddressing.EndpointReference;
import com.ibm.websphere.wsaddressing.EndpointReferenceCreationException;
import com.ibm.websphere.wsaddressing.jaxws21.EndpointReferenceConverter;
import com.ibm.websphere.wsaddressing.jaxws21.SubmissionEndpointReference;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.wsspi.wsaddressing.EndpointReferenceManager;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.soap.SOAPElement;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.w3c.dom.Node;

public class EndpointReferenceConverterImpl
extends EndpointReferenceConverter {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wsaddressing.jaxws.CWWARMessages");
    private static final TraceComponent TRACE_COMPONENT = Tr.register(EndpointReferenceConverterImpl.class, "WS-Addressing", "com.ibm.ws.wsaddressing.jaxws.CWWARMessages");
    private static final String CLASSNAME = "com.ibm.websphere.wsaddressing.jaxws21.EndpointReferenceConverterImpl";

    public com.ibm.wsspi.wsaddressing.EndpointReference createIBMEndpointReferenceImpl(final W3CEndpointReference epr) throws EndpointReferenceCreationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createIBMEndpointReferenceImpl", epr);
        }
        if (epr == null) {
            EndpointReferenceCreationException exception = new EndpointReferenceCreationException(nls.getString("NULL_EPR_CWWAR0111"));
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "createIBMEndpointReferenceImpl", exception);
            }
            throw exception;
        }
        com.ibm.wsspi.wsaddressing.EndpointReference ibmepr = null;
        try {
            try {
                ibmepr = AccessController.doPrivileged(new PrivilegedExceptionAction<com.ibm.wsspi.wsaddressing.EndpointReference>(){

                    @Override
                    public com.ibm.wsspi.wsaddressing.EndpointReference run() throws Exception {
                        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{W3CEndpointReference.class});
                        Marshaller m = jc.createMarshaller();
                        SOAPFactory soapFactory = new SOAPFactory();
                        SOAPElement tempElement = soapFactory.createElement("EndpointReference", "wsa", "http://www.w3.org/2005/08/addressing");
                        m.marshal((Object)epr, (Node)tempElement);
                        return EndpointReferenceManager.createEndpointReference((SOAPElement)tempElement.getFirstChild());
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, CLASSNAME, "1:1.1:95");
            EndpointReferenceCreationException rethrow = new EndpointReferenceCreationException(e);
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "createIBMEndpointReferenceImpl", rethrow);
            }
            throw rethrow;
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createIBMEndpointReferenceImpl", ibmepr);
        }
        return ibmepr;
    }

    public com.ibm.wsspi.wsaddressing.EndpointReference createIBMEndpointReferenceImpl(final SubmissionEndpointReference epr) throws EndpointReferenceCreationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createIBMEndpointReferenceImpl", (Object)epr);
        }
        if (epr == null) {
            EndpointReferenceCreationException exception = new EndpointReferenceCreationException(nls.getString("NULL_EPR_CWWAR0111"));
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "createIBMEndpointReferenceImpl", exception);
            }
            throw exception;
        }
        com.ibm.wsspi.wsaddressing.EndpointReference ibmepr = null;
        try {
            try {
                ibmepr = AccessController.doPrivileged(new PrivilegedExceptionAction<com.ibm.wsspi.wsaddressing.EndpointReference>(){

                    @Override
                    public com.ibm.wsspi.wsaddressing.EndpointReference run() throws Exception {
                        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{SubmissionEndpointReference.class});
                        Marshaller m = jc.createMarshaller();
                        SOAPFactory soapFactory = new SOAPFactory();
                        SOAPElement tempElement = soapFactory.createElement("EndpointReference", "wsa", "http://schemas.xmlsoap.org/ws/2004/08/addressing");
                        m.marshal((Object)epr, (Node)tempElement);
                        return EndpointReferenceManager.createEndpointReference((SOAPElement)tempElement.getFirstChild());
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, CLASSNAME, "1:1.1:150");
            EndpointReferenceCreationException rethrow = new EndpointReferenceCreationException(e);
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "createIBMEndpointReferenceImpl", rethrow);
            }
            throw rethrow;
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createIBMEndpointReferenceImpl", ibmepr);
        }
        return ibmepr;
    }

    public W3CEndpointReference createW3CEndpointReferenceImpl(EndpointReference epr) throws EndpointReferenceCreationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createW3CEndpointReferenceImpl", epr);
        }
        if (epr == null) {
            EndpointReferenceCreationException exception = new EndpointReferenceCreationException(nls.getString("NULL_EPR_CWWAR0111"));
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "createW3CEndpointReferenceImpl", exception);
            }
            throw exception;
        }
        if (!"http://www.w3.org/2005/08/addressing".equals(((com.ibm.wsspi.wsaddressing.EndpointReference)epr).getNamespace())) {
            EndpointReferenceCreationException exception = new EndpointReferenceCreationException(nls.getFormattedMessage("UNEXPECTED_NAMESPACE_CWWAR0112", new Object[]{((com.ibm.wsspi.wsaddressing.EndpointReference)epr).getNamespace(), "http://www.w3.org/2005/08/addressing"}, null));
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "createW3CEndpointReferenceImpl", exception);
            }
            throw exception;
        }
        W3CEndpointReference out = null;
        try {
            SOAPFactory soapFactory = new SOAPFactory();
            SOAPElement tempElement = soapFactory.createElement("EndpointReference", "wsa", "http://www.w3.org/2005/08/addressing");
            final SOAPElement eprElement = ((com.ibm.wsspi.wsaddressing.EndpointReference)epr).getSOAPElement(tempElement);
            try {
                out = AccessController.doPrivileged(new PrivilegedExceptionAction<W3CEndpointReference>(){

                    @Override
                    public W3CEndpointReference run() throws Exception {
                        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{W3CEndpointReference.class});
                        Unmarshaller um = jc.createUnmarshaller();
                        return (W3CEndpointReference)um.unmarshal((Node)eprElement);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, CLASSNAME, "1:1.1:214");
            EndpointReferenceCreationException rethrow = new EndpointReferenceCreationException(e);
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "createW3CEndpointReferenceImpl", rethrow);
            }
            throw rethrow;
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createW3CEndpointReferenceImpl", out);
        }
        return out;
    }

    public SubmissionEndpointReference createSubmissionEndpointReferenceImpl(EndpointReference epr) throws EndpointReferenceCreationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createSubmissionEndpointReferenceImpl", epr);
        }
        if (epr == null) {
            EndpointReferenceCreationException exception = new EndpointReferenceCreationException(nls.getString("NULL_EPR_CWWAR0111"));
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "createSubmissionEndpointReferenceImpl", exception);
            }
            throw exception;
        }
        if (!"http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(((com.ibm.wsspi.wsaddressing.EndpointReference)epr).getNamespace())) {
            EndpointReferenceCreationException exception = new EndpointReferenceCreationException(nls.getFormattedMessage("UNEXPECTED_NAMESPACE_CWWAR0112", new Object[]{((com.ibm.wsspi.wsaddressing.EndpointReference)epr).getNamespace(), "http://schemas.xmlsoap.org/ws/2004/08/addressing"}, null));
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "createSubmissionEndpointReferenceImpl", exception);
            }
            throw exception;
        }
        SubmissionEndpointReference out = null;
        try {
            SOAPFactory soapFactory = new SOAPFactory();
            SOAPElement tempElement = soapFactory.createElement("EndpointReference", "wsa", "http://schemas.xmlsoap.org/ws/2004/08/addressing");
            final SOAPElement eprElement = ((com.ibm.wsspi.wsaddressing.EndpointReference)epr).getSOAPElement(tempElement);
            try {
                out = AccessController.doPrivileged(new PrivilegedExceptionAction<SubmissionEndpointReference>(){

                    @Override
                    public SubmissionEndpointReference run() throws Exception {
                        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{SubmissionEndpointReference.class});
                        Unmarshaller um = jc.createUnmarshaller();
                        return (SubmissionEndpointReference)((Object)um.unmarshal((Node)eprElement));
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, CLASSNAME, "1:1.1:277");
            EndpointReferenceCreationException rethrow = new EndpointReferenceCreationException(e);
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "createSubmissionEndpointReferenceImpl", rethrow);
            }
            throw rethrow;
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createSubmissionEndpointReferenceImpl", (Object)out);
        }
        return out;
    }
}

