/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wsaddressing.jaxws;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wsaddressing.EndpointReference;
import com.ibm.websphere.wsaddressing.EndpointReferenceCreationException;
import com.ibm.websphere.wsaddressing.jaxws.SubmissionEndpointReference;
import com.ibm.websphere.wsaddressing.jaxws.W3CEndpointReference;
import com.ibm.ws.ffdc.FFDCFilter;

public abstract class EndpointReferenceConverter {
    private static EndpointReferenceConverter _delegatedHelper = null;
    private static final String CONCRETE_HELPER_CLASSNAME = "com.ibm.websphere.wsaddressing.jaxws.EndpointReferenceConverterImpl";
    private static final String CLASSNAME = "com.ibm.webshere.wsaddressing.jaxws.EndpointReferenceConverter";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(EndpointReferenceConverter.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");

    public static EndpointReference createIBMEndpointReference(W3CEndpointReference epr) throws EndpointReferenceCreationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createIBMEndpointReference", epr);
        }
        EndpointReference result = _delegatedHelper.createIBMEndpointReferenceImpl(epr);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createIBMEndpointReference", result);
        }
        return result;
    }

    public static EndpointReference createIBMEndpointReference(SubmissionEndpointReference epr) throws EndpointReferenceCreationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createIBMEndpointReference", epr);
        }
        EndpointReference result = _delegatedHelper.createIBMEndpointReferenceImpl(epr);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createIBMEndpointReference", result);
        }
        return result;
    }

    public static W3CEndpointReference createW3CEndpointReference(EndpointReference epr) throws EndpointReferenceCreationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createW3CEndpointReference", epr);
        }
        W3CEndpointReference result = _delegatedHelper.createW3CEndpointReferenceImpl(epr);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createW3CEndpointReference", result);
        }
        return result;
    }

    public static SubmissionEndpointReference createSubmissionEndpointReference(EndpointReference epr) throws EndpointReferenceCreationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createSubmissionEndpointReference", epr);
        }
        SubmissionEndpointReference result = _delegatedHelper.createSubmissionEndpointReferenceImpl(epr);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createSubmissionEndpointReference", result);
        }
        return result;
    }

    protected abstract EndpointReference createIBMEndpointReferenceImpl(W3CEndpointReference var1) throws EndpointReferenceCreationException;

    protected abstract EndpointReference createIBMEndpointReferenceImpl(SubmissionEndpointReference var1) throws EndpointReferenceCreationException;

    protected abstract W3CEndpointReference createW3CEndpointReferenceImpl(EndpointReference var1) throws EndpointReferenceCreationException;

    protected abstract SubmissionEndpointReference createSubmissionEndpointReferenceImpl(EndpointReference var1) throws EndpointReferenceCreationException;

    private static void traceAndFFDCException(Exception e) {
        String exceptionName = e.getClass().getName();
        String exceptionMessage = e.getMessage();
        String message = "Caught a " + exceptionName + ": " + exceptionMessage + " when trying to create a new " + CONCRETE_HELPER_CLASSNAME + " instance within a static initializer";
        Tr.warning(TRACE_COMPONENT, message);
        FFDCFilter.processException(e, CLASSNAME, "1:1.3:182");
    }

    static {
        try {
            _delegatedHelper = (EndpointReferenceConverter)Class.forName(CONCRETE_HELPER_CLASSNAME).newInstance();
        }
        catch (InstantiationException e) {
            EndpointReferenceConverter.traceAndFFDCException(e);
        }
        catch (IllegalAccessException e) {
            EndpointReferenceConverter.traceAndFFDCException(e);
        }
        catch (ClassNotFoundException e) {
            EndpointReferenceConverter.traceAndFFDCException(e);
        }
    }
}

