/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.ssl.protocol;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.ssl.config.SSLConfigManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;

public class SSLSocketFactory
extends javax.net.ssl.SSLSocketFactory {
    private static final TraceComponent tc = Tr.register(SSLSocketFactory.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    protected Properties props;
    private javax.net.ssl.SSLSocketFactory default_factory = null;
    private javax.net.ssl.SSLSocketFactory factory = null;
    protected boolean default_constructor = true;
    private static SSLSocketFactory thisClass = null;

    public SSLSocketFactory() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SSLSocketFactory(1)");
        }
        try {
            HashMap connectionInfo = new HashMap();
            Map currentConnectionInfo = JSSEHelper.getInstance().getOutboundConnectionInfo();
            this.props = SSLConfigManager.getInstance().getDefaultSystemProperties(true);
            if (this.props == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Getting default SSL properties from WebSphere configuration.");
                }
                this.props = JSSEHelper.getInstance().getProperties(null, connectionInfo, null);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Getting javax.net.ssl.* SSL System properties.");
                }
                this.default_constructor = false;
            }
            this.default_factory = JSSEHelper.getInstance().getSSLSocketFactory(connectionInfo, this.props);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SSLSocketFactory(1)");
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SSLSocketFactory exception getting default SSL properties.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.protocol.SSLSocketFactory.constructor", "103", this);
            this.props = null;
        }
    }

    public SSLSocketFactory(String alias) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SSLSocketFactory(2)", new Object[]{alias});
        }
        try {
            this.default_constructor = false;
            HashMap connectionInfo = new HashMap();
            Map currentConnectionInfo = JSSEHelper.getInstance().getOutboundConnectionInfo();
            this.props = JSSEHelper.getInstance().getProperties(alias, connectionInfo, null);
            this.default_factory = JSSEHelper.getInstance().getSSLSocketFactory(connectionInfo, this.props);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SSLSocketFactory(2)");
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SSLSocketFactory exception getting SSL properties from alias.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.protocol.SSLSocketFactory.constructor(alias)", "140", this);
            this.props = null;
        }
    }

    public SSLSocketFactory(Properties sslprops) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SSLSocketFactory(3)");
        }
        try {
            this.default_constructor = false;
            this.props = sslprops;
            HashMap connectionInfo = new HashMap();
            Map currentConnectionInfo = JSSEHelper.getInstance().getOutboundConnectionInfo();
            this.default_factory = JSSEHelper.getInstance().getSSLSocketFactory(connectionInfo, this.props);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SSLSocketFactory(3)");
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SSLSocketFactory exception getting SSL properties from properties.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.protocol.SSLSocketFactory.constructor(sslprops)", "177", this);
            this.props = null;
        }
    }

    public SSLSocketFactory(String alias, Map connectionInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SSLSocketFactory(4)", new Object[]{alias, connectionInfo});
        }
        try {
            this.default_constructor = false;
            this.props = JSSEHelper.getInstance().getProperties(alias, connectionInfo, null);
            this.default_factory = JSSEHelper.getInstance().getSSLSocketFactory(connectionInfo, this.props);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SSLSocketFactory(4)");
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SSLSocketFactory exception getting SSL properties from selections.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.protocol.SSLSocketFactory.constructor(alias, dynamicSelectionInfo, endPointName)", "216", this);
            this.props = null;
        }
    }

    public static SocketFactory getDefault() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefault");
        }
        if (thisClass == null) {
            try {
                thisClass = new SSLSocketFactory();
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SSLSocketFactory exception getting default socket factory.", new Object[]{e});
                }
                Manager.Ffdc.log(e, SSLSocketFactory.class, "com.ibm.websphere.ssl.protocol.SSLSocketFactory.getDefault", "239");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefault");
        }
        return thisClass;
    }

    public String[] getDefaultCipherSuites() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultCipherSuites");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultCipherSuites");
        }
        return this.default_factory.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSupportedCipherSuites");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSupportedCipherSuites");
        }
        return this.default_factory.getSupportedCipherSuites();
    }

    public Socket createSocket() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSocket(0)");
        }
        SSLSocket socket = null;
        Properties sslprops = this.props;
        try {
            if (sslprops == null) {
                sslprops = JSSEHelper.getInstance().getProperties(null, null, null);
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting properties ", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.protocol.SSLSocketFactory.createSocket(0)", "325", this);
            this.factory = this.default_factory;
        }
        socket = (SSLSocket)this.default_factory.createSocket();
        socket = SSLConfigManager.getInstance().setCipherListOnSocket(sslprops, socket);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSocket(0)");
        }
        return socket;
    }

    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSocket(1)", new Object[]{s, host, new Integer(port), new Boolean(autoClose)});
        }
        SSLSocket socket = null;
        Properties sslprops = this.props;
        try {
            HashMap<String, String> connectionInfo = JSSEHelper.getInstance().getOutboundConnectionInfo();
            if (connectionInfo == null) {
                connectionInfo = new HashMap<String, String>();
                connectionInfo.put("com.ibm.ssl.direction", "outbound");
                connectionInfo.put("com.ibm.ssl.remoteHost", host);
                connectionInfo.put("com.ibm.ssl.remotePort", Integer.toString(port));
            }
            String protocol = (String)connectionInfo.get("com.ibm.ssl.endPointName");
            if (this.default_constructor || protocol != null && protocol.equals("ADMIN_SOAP")) {
                sslprops = JSSEHelper.getInstance().getProperties(null, connectionInfo, null);
            }
            this.factory = JSSEHelper.getInstance().getSSLSocketFactory(connectionInfo, sslprops);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting SSLSocketFactory.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.protocol.SSLSocketFactory.createSocket(1)", "356", this);
            this.factory = this.default_factory;
        }
        socket = (SSLSocket)this.factory.createSocket(s, host, port, autoClose);
        socket = SSLConfigManager.getInstance().setCipherListOnSocket(sslprops, socket);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSocket(1)");
        }
        return socket;
    }

    public Socket createSocket(InetAddress host, int port) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSocket(2)", new Object[]{host, new Integer(port)});
        }
        SSLSocket socket = null;
        Properties sslprops = this.props;
        try {
            HashMap<String, String> connectionInfo;
            String remoteHostName = null;
            if (host != null) {
                try {
                    remoteHostName = host.getHostName();
                    if (remoteHostName == null) {
                        remoteHostName = host.getCanonicalHostName();
                    }
                }
                catch (Throwable e) {
                    remoteHostName = host.getHostAddress();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception getting hostname from socket.", new Object[]{e});
                    }
                    Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.protocol.SSLSocketFactory.createSocket(2)", "404", this);
                }
            }
            if ((connectionInfo = JSSEHelper.getInstance().getOutboundConnectionInfo()) == null) {
                connectionInfo = new HashMap<String, String>();
                connectionInfo.put("com.ibm.ssl.direction", "outbound");
                connectionInfo.put("com.ibm.ssl.remoteHost", remoteHostName);
                connectionInfo.put("com.ibm.ssl.remotePort", Integer.toString(port));
            }
            String protocol = (String)connectionInfo.get("com.ibm.ssl.endPointName");
            if (this.default_constructor || protocol != null && protocol.equals("ADMIN_SOAP")) {
                sslprops = JSSEHelper.getInstance().getProperties(null, connectionInfo, null);
            }
            this.factory = JSSEHelper.getInstance().getSSLSocketFactory(connectionInfo, sslprops);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting SSLSocketFactory.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.protocol.SSLSocketFactory.createSocket(2)", "434", this);
            this.factory = this.default_factory;
        }
        socket = (SSLSocket)this.factory.createSocket(host, port);
        socket = SSLConfigManager.getInstance().setCipherListOnSocket(sslprops, socket);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSocket(2)");
        }
        return socket;
    }

    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSocket(3)", new Object[]{address, new Integer(port), localAddress, new Integer(localPort)});
        }
        SSLSocket socket = null;
        Properties sslprops = this.props;
        try {
            HashMap<String, String> connectionInfo;
            String remoteHostName = null;
            if (address != null) {
                try {
                    remoteHostName = address.getHostName();
                    if (remoteHostName == null) {
                        remoteHostName = address.getCanonicalHostName();
                    }
                }
                catch (Throwable e) {
                    remoteHostName = address.getHostAddress();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception getting hostname from socket.", new Object[]{e});
                    }
                    Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.protocol.SSLSocketFactory.createSocket(3)", "488", this);
                }
            }
            if ((connectionInfo = JSSEHelper.getInstance().getOutboundConnectionInfo()) == null) {
                connectionInfo = new HashMap<String, String>();
                connectionInfo.put("com.ibm.ssl.direction", "outbound");
                connectionInfo.put("com.ibm.ssl.remoteHost", remoteHostName);
                connectionInfo.put("com.ibm.ssl.remotePort", Integer.toString(port));
            }
            String protocol = (String)connectionInfo.get("com.ibm.ssl.endPointName");
            if (this.default_constructor || protocol != null && protocol.equals("ADMIN_SOAP")) {
                sslprops = JSSEHelper.getInstance().getProperties(null, connectionInfo, null);
            }
            this.factory = JSSEHelper.getInstance().getSSLSocketFactory(connectionInfo, sslprops);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting SSLSocketFactory.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.protocol.SSLSocketFactory.createSocket(3)", "518", this);
            this.factory = this.default_factory;
        }
        socket = (SSLSocket)this.factory.createSocket(address, port, localAddress, localPort);
        socket = SSLConfigManager.getInstance().setCipherListOnSocket(sslprops, socket);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSocket(3)");
        }
        return socket;
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSocket(4)", new Object[]{host, new Integer(port)});
        }
        SSLSocket socket = null;
        Properties sslprops = this.props;
        try {
            HashMap<String, String> connectionInfo = JSSEHelper.getInstance().getOutboundConnectionInfo();
            if (connectionInfo == null) {
                connectionInfo = new HashMap<String, String>();
                connectionInfo.put("com.ibm.ssl.direction", "outbound");
                connectionInfo.put("com.ibm.ssl.remoteHost", host);
                connectionInfo.put("com.ibm.ssl.remotePort", Integer.toString(port));
            }
            String protocol = (String)connectionInfo.get("com.ibm.ssl.endPointName");
            if (this.default_constructor || protocol != null && protocol.equals("ADMIN_SOAP")) {
                sslprops = JSSEHelper.getInstance().getProperties(null, connectionInfo, null);
            }
            this.factory = JSSEHelper.getInstance().getSSLSocketFactory(connectionInfo, sslprops);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting SSLSocketFactory.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.protocol.SSLSocketFactory.createSocket(4)", "582", this);
            this.factory = this.default_factory;
        }
        socket = (SSLSocket)this.factory.createSocket(host, port);
        socket = SSLConfigManager.getInstance().setCipherListOnSocket(sslprops, socket);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSocket(4), not null");
        }
        return socket;
    }

    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSocket(5)", new Object[]{host, new Integer(port), localHost, new Integer(localPort)});
        }
        SSLSocket socket = null;
        Properties sslprops = this.props;
        try {
            HashMap<String, String> connectionInfo = JSSEHelper.getInstance().getOutboundConnectionInfo();
            if (connectionInfo == null) {
                connectionInfo = new HashMap<String, String>();
                connectionInfo.put("com.ibm.ssl.direction", "outbound");
                connectionInfo.put("com.ibm.ssl.remoteHost", host);
                connectionInfo.put("com.ibm.ssl.remotePort", Integer.toString(port));
            }
            String protocol = (String)connectionInfo.get("com.ibm.ssl.endPointName");
            if (this.default_constructor || protocol != null && protocol.equals("ADMIN_SOAP")) {
                sslprops = JSSEHelper.getInstance().getProperties(null, connectionInfo, null);
            }
            this.factory = JSSEHelper.getInstance().getSSLSocketFactory(connectionInfo, sslprops);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting SSLSocketFactory.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.protocol.SSLSocketFactory.createSocket(5)", "646", this);
            this.factory = this.default_factory;
        }
        socket = (SSLSocket)this.factory.createSocket(host, port, localHost, localPort);
        socket = SSLConfigManager.getInstance().setCipherListOnSocket(sslprops, socket);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSocket(5)");
        }
        return socket;
    }
}

