/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.servlet.response;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.websphere.servlet.error.ServletErrorReport;
import com.ibm.websphere.servlet.response.DummyResponse;
import com.ibm.websphere.servlet.response.HttpServletResponseProxy;
import com.ibm.websphere.servlet.response.IResponse;
import com.ibm.websphere.servlet.response.ResponseErrorReport;
import com.ibm.websphere.servlet.response.StoredHeader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.servlet.IncludedResponse;
import com.ibm.ws.webcontainer.srt.SRTOutputStream;
import com.ibm.ws.webcontainer.srt.SRTServletResponse;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.servlet.IExtendedResponse;
import com.ibm.wsspi.webcontainer.servlet.IOutputMethodListener;
import com.ibm.wsspi.webcontainer.util.ByteBufferOutputStream;
import com.ibm.wsspi.webcontainer.util.EncodingUtils;
import com.ibm.wsspi.webcontainer.util.IOutputStreamObserver;
import com.ibm.wsspi.webcontainer.util.IResponseOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoredResponse
extends HttpServletResponseWrapper
implements HttpServletResponse,
Serializable,
IResponseOutput,
IExtendedResponse,
IOutputStreamObserver {
    private static final long serialVersionUID = 3257847662609707832L;
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.websphere.servlet.response");
    private static final String CLASS_NAME = "com.ibm.websphere.servlet.response.StoredResponse";
    protected static final NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");
    private static final int DEFAULT_STATUS_CODE = 200;
    protected PrintWriter _writer;
    protected SRTOutputStream _out;
    protected ByteBufferOutputStream _bbOut;
    private boolean _isFinished;
    private byte[] _outputBuffer;
    private int _statusCode = 200;
    private String _statusMessage;
    private String _redirectURI;
    private Cookie[] _cookies = new Cookie[0];
    private long _lastModified;
    private ResponseErrorReport _error;
    private StoredHeader _header;
    protected boolean _writerObtained = false;
    protected boolean _outputStreamObtained = false;
    private static final String _defaultEncoding = "ISO-8859-1";
    private String _contentType = null;
    private String _encoding;
    private Locale _locale;
    private Locale _defaultLocale;
    protected int bufferSize = 4096;
    private boolean isCommitted = false;
    private List<WsByteBuffer> _bbList = null;
    private IOutputMethodListener outputMethodListener;
    private boolean isInclude = false;
    private Vector[] headerTable;
    protected boolean outputWritten;
    private boolean internalHeaderSettable;
    private boolean outputFlushed;
    private boolean finishedOutput;
    private boolean dummyResponse = true;
    private IExtendedResponse extResponse;

    public StoredResponse() {
        super(new DummyResponse());
        this.init();
    }

    public StoredResponse(boolean isInclude) {
        super(new DummyResponse());
        this.isInclude = isInclude;
        this.init();
    }

    public StoredResponse(IExtendedResponse extResponse, boolean isInclude) {
        super((HttpServletResponse)((Object)extResponse));
        this.extResponse = extResponse;
        this.dummyResponse = false;
        this.isInclude = isInclude;
        this.init();
    }

    private void init() {
        if (this.dummyResponse) {
            this._header = new StoredHeader();
        }
        if (!this.isInclude) {
            this.setContentType("text/html");
            this._encoding = _defaultEncoding;
            this._locale = this._defaultLocale = Locale.getDefault();
        }
    }

    private void initOutputStream() {
        this._bbOut = new ByteBufferOutputStream();
        this._out = new SRTOutputStream();
        this._out.init(this._bbOut);
        this._bbOut.setObserver(this);
    }

    @Override
    public boolean writerObtained() {
        return this._writerObtained;
    }

    @Override
    public boolean outputStreamObtained() {
        return this._outputStreamObtained;
    }

    @Override
    public void addCookie(Cookie cookie) {
        if (!this.dummyResponse) {
            super.addCookie(cookie);
        } else if (this.isInclude) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "addCookie", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "addCookie cookie --> " + cookie.getName());
            }
        } else {
            Cookie[] newCookies = new Cookie[this._cookies.length + 1];
            System.arraycopy(this._cookies, 0, newCookies, 0, this._cookies.length);
            newCookies[this._cookies.length] = cookie;
            this._cookies = newCookies;
        }
    }

    @Override
    public IResponse getIResponse() {
        if (!this.dummyResponse) {
            return this.extResponse.getIResponse();
        }
        return null;
    }

    @Override
    public ServletOutputStream getOutputStream() throws IllegalStateException, IOException {
        if (this._writerObtained) {
            throw new IllegalStateException("Writer as already been obtained for this Response object");
        }
        if (this._outputStreamObtained) {
            return this._out;
        }
        this.initOutputStream();
        this._outputStreamObtained = true;
        this.fireOutputStreamRetrievedEvent(this._out);
        return this._out;
    }

    @Override
    public void setContentLength(int len) {
        if (!this.dummyResponse) {
            super.setContentLength(len);
        } else if (this.isInclude) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setContentLength", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "setContentLength length --> " + len);
            }
        } else {
            this.setIntHeader("content-length", len);
        }
    }

    @Override
    public void setContentType(String type) {
        if (!this.dummyResponse) {
            super.setContentType(type);
        } else if (this.isInclude) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setContentType", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "setContentType type --> " + type);
            }
        } else {
            this.setHeader("content-type", type);
        }
    }

    @Override
    public void setBufferSize(int size) throws IllegalStateException {
        if (this._writer != null) {
            this._writer.flush();
        }
        if (this._bbOut != null) {
            this._bbOut.reset();
        }
        if (this.outputWritten) {
            throw new IllegalStateException("Cannot set buffer size after write");
        }
        if (!this.dummyResponse) {
            super.setBufferSize(size);
        } else {
            this.bufferSize = size;
        }
    }

    @Override
    public int getBufferSize() {
        if (!this.dummyResponse) {
            return super.getBufferSize();
        }
        return this.bufferSize;
    }

    @Override
    public void flushBuffer() throws IOException {
        this.flushBuffer(true);
    }

    @Override
    public void flushBuffer(boolean flushToWire) throws IOException {
        if (this._writer != null) {
            this._writer.flush();
        }
        if (this._out != null) {
            this._out.flush();
        }
        this.isCommitted = true;
    }

    @Override
    public boolean isCommitted() {
        return this.isCommitted;
    }

    @Override
    public void reset() throws IllegalStateException {
        if (this.isCommitted) {
            throw new IllegalStateException("Response cannot be reset after it has been committed");
        }
        if (!this.dummyResponse) {
            super.reset();
        }
        if (this._writer != null) {
            this._writer.flush();
        }
        if (this._bbOut != null) {
            this._bbOut.reset();
        }
        this.isCommitted = false;
    }

    @Override
    public Vector[] getHeaderTable() {
        if (!this.dummyResponse) {
            return this.extResponse.getHeaderTable();
        }
        return this.headerTable;
    }

    @Override
    public void addSessionCookie(Cookie cookie) {
        if (this.dummyResponse) {
            if (this.isInclude) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "addSessionCookie", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "addSessionCookie cookie --> " + cookie);
                }
                throw new IllegalStateException("cannot add session from a stored/async response");
            }
            throw new IllegalStateException("This method is not supported, use HttpServletResponse.addCookie(Cookie cookie) instead");
        }
        this.extResponse.addSessionCookie(cookie);
    }

    @Override
    public void setLocale(Locale loc) {
        if (!this.dummyResponse) {
            super.setLocale(loc);
        } else if (this.isInclude) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setLocale", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "setLocale locale --> " + loc);
            }
        } else {
            this._locale = loc;
            this.setCharacterEncoding(EncodingUtils.getEncodingFromLocale(this._locale));
        }
    }

    @Override
    public void setCharacterEncoding(String encoding) {
        if (!this.dummyResponse) {
            super.setCharacterEncoding(encoding);
        } else if (this.isInclude) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setCharacterEncoding", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "setCharacterEncoding encoding --> " + encoding);
            }
        } else {
            if (encoding != null) {
                if (encoding.startsWith("\"") || encoding.startsWith("'")) {
                    encoding = encoding.substring(1);
                }
                if (encoding.endsWith("\"") || encoding.endsWith("'")) {
                    encoding = encoding.substring(0, encoding.length() - 1);
                }
            }
            this._encoding = encoding;
        }
    }

    @Override
    public Locale getLocale() {
        if (!this.dummyResponse) {
            return super.getLocale();
        }
        return this._locale;
    }

    @Override
    public void addDateHeader(String name, long date) {
        if (!this.dummyResponse) {
            super.addDateHeader(name, date);
        } else if (this.isInclude && TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "addDateHeader", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "name->" + name + ", date->" + date);
        }
    }

    @Override
    public void addHeader(String name, String value) {
        if (!this.dummyResponse) {
            super.addHeader(name, value);
        } else if (this.isInclude && TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "addHeader", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "name->" + name + ", value->" + value);
        }
    }

    @Override
    public void addIntHeader(String name, int value) {
        if (!this.dummyResponse) {
            super.addIntHeader(name, value);
        } else if (this.isInclude && TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "addIntHeader", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "name->" + name + ", value->" + value);
        }
    }

    @Override
    public void setHeader(String name, String value) {
        this.setHeader(name, value, true);
    }

    @Override
    public void setInternalHeader(String name, String value) {
        if (!this.internalHeaderSettable) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setInternalHeader", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "name->" + name + ", value->" + value);
            }
        } else {
            this.setHeader(name, value, false);
        }
    }

    @Override
    public void setHeader(String name, String value, boolean checkInclude) {
        if (checkInclude && this.isInclude) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setHeader", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "name->" + name + ", value->" + value + ", checkInclude->" + checkInclude);
            }
        } else if (!this.dummyResponse) {
            this.extResponse.setHeader(name, value, false);
            if (name.equalsIgnoreCase("content-type")) {
                this._encoding = super.getCharacterEncoding();
            }
        } else {
            this._header.setHeader(name, value);
            if (name.toLowerCase().equals("content-type")) {
                String val;
                int index;
                if (value != null && (index = (val = value.toLowerCase()).indexOf("charset=")) != -1) {
                    String encoding = val.substring(index + 8);
                    if (encoding.startsWith("\"") || encoding.startsWith("'")) {
                        encoding = encoding.substring(1);
                    }
                    if (encoding.endsWith("\"") || encoding.endsWith("'")) {
                        encoding = encoding.substring(0, encoding.length() - 1);
                    }
                    this.setCharacterEncoding(encoding);
                    value = val.substring(0, index + 8) + encoding;
                }
                this._contentType = value;
            }
        }
    }

    @Override
    public void setIntHeader(String name, int value) {
        if (this.isInclude) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setIntHeader", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "name->" + name + ", value->" + value);
            }
        } else {
            this._header.setIntHeader(name, value);
        }
    }

    @Override
    public void setDateHeader(String name, long value) {
        if (this.isInclude) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setDateHeader", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "name->" + name + ", value->" + value);
            }
        } else {
            this._header.setDateHeader(name, value);
        }
    }

    @Override
    public boolean containsHeader(String name) {
        if (!this.dummyResponse) {
            return super.containsHeader(name);
        }
        if (!this.isInclude && this._header != null) {
            return this._header.containsHeader(name);
        }
        if (this.headerTable != null) {
            for (int i = 0; i < this.headerTable.length; ++i) {
                if (!this.headerTable[i].contains(name)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public PrintWriter getWriter() throws IOException, IllegalStateException {
        if (this._outputStreamObtained) {
            throw new IllegalStateException("OutputStream already obtained for this Response object");
        }
        if (this._writerObtained) {
            return this._writer;
        }
        this.initOutputStream();
        OutputStreamWriter _outWriter = null;
        try {
            String encoding = this.getCharacterEncoding();
            _outWriter = encoding == null ? new OutputStreamWriter(this._out) : new OutputStreamWriter((OutputStream)this._out, encoding);
        }
        catch (UnsupportedEncodingException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.websphere.servlet.response.StoredResponse.getWriter", "248", this);
            _outWriter = new OutputStreamWriter(this._out);
        }
        this._writer = new PrintWriter(_outWriter);
        _outWriter = null;
        this._writerObtained = true;
        this.fireWriterRetrievedEvent(this._writer);
        return this._writer;
    }

    @Override
    public void setStatus(int sc) {
        if (this.isInclude) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setStatus", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "status->" + sc);
            }
        } else {
            this._statusCode = sc;
        }
    }

    @Override
    public void setStatus(int sc, String message) {
        if (this.isInclude) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setStatus", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "status->" + sc + ", message->" + message);
            }
        } else {
            this._statusCode = sc;
            this._statusMessage = message;
        }
    }

    @Override
    public void sendError(int sc) throws IOException {
        if (!this.dummyResponse) {
            super.sendError(sc);
        } else if (this.isInclude) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "sendError", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "status->" + sc);
            }
        } else {
            this._error = new ResponseErrorReport();
            this._error.setErrorCode(sc);
        }
    }

    @Override
    public void sendError(int sc, String message) throws IOException {
        if (!this.dummyResponse) {
            super.sendError(sc, message);
        } else if (this.isInclude) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "sendError", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "status->" + sc + ", message->" + message);
            }
        } else {
            this._error = new ResponseErrorReport(message);
            this._error.setErrorCode(sc);
        }
    }

    @Override
    public String encodeURL(String url) {
        if (!this.dummyResponse) {
            return super.encodeURL(url);
        }
        return url;
    }

    @Override
    public String encodeUrl(String url) {
        if (!this.dummyResponse) {
            return super.encodeUrl(url);
        }
        return this.encodeUrl(url);
    }

    @Override
    public void sendRedirect(String uri) throws IOException {
        if (this.isInclude) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "sendRedirect", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "uri->" + uri);
            }
        } else {
            this._redirectURI = uri;
        }
    }

    @Override
    public void sendRedirect303(String uri) throws IOException {
        if (this.isInclude) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "sendRedirect303", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "uri->" + uri);
            }
        } else {
            this._redirectURI = uri;
        }
    }

    @Override
    public String encodeRedirectURL(String url) {
        if (!this.dummyResponse) {
            return super.encodeRedirectURL(url);
        }
        return url;
    }

    @Override
    public String encodeRedirectUrl(String url) {
        if (!this.dummyResponse) {
            return super.encodeRedirectUrl(url);
        }
        return url;
    }

    protected void finishOutput(boolean toByteArray) throws IOException {
        if (!this.finishedOutput) {
            this.finishedOutput = true;
            if (this._writer != null) {
                this._writer.flush();
            }
            if (this._out != null) {
                this._out.close();
                this._bbOut.flushBuffer();
                if (toByteArray) {
                    this._outputBuffer = this._bbOut.toByteArray();
                }
                this._bbList = this._bbOut.getByteBufferList();
            }
        }
    }

    @Override
    public void finish() throws IOException {
        this._finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _finish() throws IOException {
        if (this._isFinished) {
            return;
        }
        StoredResponse storedResponse = this;
        synchronized (storedResponse) {
            if (this._isFinished) {
                return;
            }
            this._isFinished = true;
            this.finishOutput(true);
            if (!this.isInclude && this._outputBuffer != null) {
                this.setContentLength(this._outputBuffer.length);
            }
            if (this._header != null) {
                this._lastModified = this._header.getDateHeader("last-modified");
            }
            this._writer = null;
            this._out = null;
            this._bbOut = null;
        }
    }

    public void close() throws IOException {
        this._finish();
    }

    public byte[] getOutputBuffer() throws IOException {
        this.finishOutput(true);
        return this._outputBuffer;
    }

    public List<WsByteBuffer> getByteBufferList() throws IOException {
        this.finishOutput(false);
        return this._bbList;
    }

    public String getOutputBufferAsString() throws IOException {
        byte[] buffer = this.getOutputBuffer();
        if (buffer != null) {
            return new String(buffer, this.getCharacterEncoding());
        }
        return null;
    }

    public Enumeration getHeaderNames() {
        if (this._header != null && this.headerTable != null) {
            InnerEnumeration innerEnum = new InnerEnumeration(this._header.getHeaderNames(), this.headerTable[0].elements());
            return innerEnum;
        }
        if (this.headerTable != null) {
            return this.headerTable[0].elements();
        }
        if (this._header != null) {
            return this._header.getHeaderNames();
        }
        return null;
    }

    public Enumeration getAddedHeaderNames() {
        if (this._header != null) {
            return this._header.getHeaderNames();
        }
        return null;
    }

    public String getHeader(String name) {
        if (this._header != null) {
            return this._header.getHeader(name);
        }
        return null;
    }

    public int getIntHeader(String name) {
        if (this._header != null) {
            return this._header.getIntHeader(name);
        }
        return -1;
    }

    public long getDateHeader(String name) {
        if (this._header != null) {
            return this._header.getDateHeader(name);
        }
        return -1L;
    }

    public boolean containsError() {
        return this._error != null;
    }

    public ServletErrorReport getError() {
        return this._error;
    }

    public String getErrorMessage() {
        if (this.containsError()) {
            return this.getError().getMessage();
        }
        return null;
    }

    public int getErrorStatusCode() {
        if (!this.containsError()) {
            throw new IllegalStateException("sendError() was not called");
        }
        return this.getError().getErrorCode();
    }

    @Override
    public int getStatusCode() {
        return this._statusCode;
    }

    public String getStatusMessage() {
        return this._statusMessage;
    }

    public String getRedirectURI() {
        if (!this.isRedirected()) {
            throw new IllegalStateException("sendRedirect() was not called");
        }
        return this._redirectURI;
    }

    public boolean isRedirected() {
        return this._redirectURI != null;
    }

    @Override
    public String getCharacterEncoding() {
        if (!this.dummyResponse) {
            return super.getCharacterEncoding();
        }
        return this._encoding;
    }

    @Override
    public String getContentType() {
        if (!this.dummyResponse) {
            return super.getContentType();
        }
        return this._contentType;
    }

    public Cookie[] getCookies() {
        return this._cookies;
    }

    public long getLastModified() {
        return this._lastModified;
    }

    public boolean isExpired() {
        return false;
    }

    public void transferResponse(HttpServletResponse target) throws IOException {
        this._finish();
        if (this.containsError()) {
            String message = this.getErrorMessage();
            int sc = this.getErrorStatusCode();
            if (message == null) {
                target.sendError(sc);
            } else {
                target.sendError(sc, message);
            }
        } else if (this.isRedirected()) {
            Cookie[] cookies = this.getCookies();
            for (int i = 0; i < cookies.length; ++i) {
                target.addCookie(cookies[i]);
            }
            target.sendRedirect(this.getRedirectURI());
        } else {
            ServletOutputStream out;
            if (this.getStatusMessage() == null) {
                target.setStatus(this.getStatusCode());
            } else {
                target.setStatus(this.getStatusCode(), this.getStatusMessage());
            }
            this._header.transferHeader(target);
            Cookie[] cookies = this.getCookies();
            for (int i = 0; i < cookies.length; ++i) {
                target.addCookie(cookies[i]);
            }
            try {
                out = target.getOutputStream();
            }
            catch (IllegalStateException i) {
                while (!(target instanceof StoredResponse)) {
                    while (target instanceof HttpServletResponseWrapper) {
                        target = (HttpServletResponse)((HttpServletResponseWrapper)target).getResponse();
                    }
                    while (target instanceof HttpServletResponseProxy) {
                        target = ((HttpServletResponseProxy)target).getProxiedHttpServletResponse();
                    }
                    while (target instanceof IncludedResponse) {
                        target = ((IncludedResponse)target).getProxiedHttpServletResponse();
                    }
                    if (!(target instanceof SRTServletResponse)) continue;
                    target.getWriter().write(this.getOutputBufferAsString().toCharArray());
                    return;
                }
                StoredResponse s = (StoredResponse)target;
                out = s._out;
            }
            out.write(this.getOutputBuffer());
        }
    }

    @Override
    public void resetBuffer() {
        if (this._writer != null) {
            this._writer.flush();
        }
        if (this._bbOut != null) {
            this._bbOut.reset();
        }
    }

    @Override
    public void fireOutputStreamRetrievedEvent(ServletOutputStream sos) {
        if (this.outputMethodListener != null) {
            this.outputMethodListener.notifyOutputStreamRetrieved(sos);
        }
    }

    @Override
    public void fireWriterRetrievedEvent(PrintWriter pw) {
        if (this.outputMethodListener != null) {
            this.outputMethodListener.notifyWriterRetrieved(pw);
        }
    }

    @Override
    public void registerOutputMethodListener(IOutputMethodListener listener) {
        this.outputMethodListener = listener;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void initForNextResponse(IResponse res) {
    }

    @Override
    public void start() {
    }

    public void setInclude(boolean isInclude) {
        this.isInclude = true;
    }

    public void setInternalHeaderSettable(boolean internalHeaderSettable) {
        this.internalHeaderSettable = internalHeaderSettable;
    }

    public void buildResponseData(IExtendedResponse response) {
        this.headerTable = (Vector[])response.getHeaderTable().clone();
        this.buildWriterData(response);
        this._contentType = response.getContentType();
        this._locale = response.getLocale();
        this._statusCode = response.getStatusCode();
    }

    public void buildWriterData(IExtendedResponse response) {
        this.isCommitted = response.isCommitted();
        this._encoding = response.getCharacterEncoding();
    }

    @Override
    public void alertClose() {
    }

    @Override
    public void alertException() {
    }

    @Override
    public void alertFirstFlush() {
        this.isCommitted = true;
    }

    @Override
    public void alertFirstWrite() {
        this.outputWritten = true;
    }

    private class InnerEnumeration
    implements Enumeration {
        private Enumeration enum1;
        private Enumeration enum2;

        public InnerEnumeration(Enumeration enum1, Enumeration enum2) {
            this.enum1 = enum1;
            this.enum2 = enum2;
        }

        public boolean hasMoreElements() {
            return this.enum1.hasMoreElements() || this.enum2.hasMoreElements();
        }

        public Object nextElement() {
            if (this.enum1.hasMoreElements()) {
                return this.enum1.nextElement();
            }
            if (this.enum2.hasMoreElements()) {
                return this.enum2.nextElement();
            }
            throw new NoSuchElementException();
        }
    }
}

