/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.servlet.filter;

import com.ibm.websphere.servlet.filter.ChainedRequest;
import com.ibm.websphere.servlet.response.StoredResponse;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ChainedResponse
extends StoredResponse {
    private static final long serialVersionUID = 3256438097326520118L;
    private static final String AUTO_XFER_HEADERS_ATTR = "com.ibm.websphere.servlet.filter.ChainedResponse.auto_transfer_headers";
    private HttpServletRequest _req;
    private HttpServletResponse _resp;

    public ChainedResponse(HttpServletRequest req, HttpServletResponse resp) {
        this._req = req;
        this._resp = resp;
        this.setResponse(resp);
    }

    public HttpServletRequest getChainedRequest() throws IOException, ServletException {
        String value;
        String name;
        if (super.containsError()) {
            throw super.getError();
        }
        ChainedRequest req = new ChainedRequest(this, this._req);
        Hashtable headers = this.getAutoTransferringHeaders();
        Enumeration names = headers.keys();
        while (names.hasMoreElements()) {
            name = (String)names.nextElement();
            value = (String)headers.get(name);
            req.setHeader(name, value);
        }
        names = this.getHeaderNames();
        while (names.hasMoreElements()) {
            name = (String)names.nextElement();
            value = this.getHeader(name);
            req.setHeader(name, value);
        }
        return req;
    }

    public String encodeRedirectURL(String url) {
        return this._resp.encodeRedirectURL(url);
    }

    public String encodeRedirectUrl(String url) {
        return this._resp.encodeRedirectUrl(url);
    }

    public String encodeURL(String url) {
        return this._resp.encodeURL(url);
    }

    public String encodeUrl(String url) {
        return this._resp.encodeUrl(url);
    }

    public void setAutoTransferringHeader(String name, String value) {
        Hashtable headers = this.getAutoTransferringHeaders();
        headers.put(name, value);
    }

    public HttpServletResponse getProxiedHttpServletResponse() {
        return this._resp;
    }

    private Hashtable getAutoTransferringHeaders() {
        Hashtable headers = (Hashtable)this._req.getAttribute(AUTO_XFER_HEADERS_ATTR);
        if (headers == null) {
            headers = new Hashtable();
            this._req.setAttribute(AUTO_XFER_HEADERS_ATTR, headers);
        }
        return headers;
    }
}

