/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.servlet.event;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.servlet.event.ServletEvent;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.util.ServletUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class ServletInvocationEvent
extends ServletEvent {
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.websphere.servlet.event");
    private static final String CLASS_NAME = "com.ibm.websphere.servlet.event.ServletInvocationEvent";
    private ServletRequest _req;
    private ServletResponse _resp;

    public ServletInvocationEvent(Object source, ServletContext context, String servletName, String servletClassName, ServletRequest req, ServletResponse resp) {
        super(source, context, servletName, servletClassName);
        this._req = req;
        this._resp = resp;
    }

    public String getRequestURL() {
        HttpServletRequest httpReq = this.getRequest();
        if (httpReq == null) {
            return null;
        }
        return httpReq.getRequestURL().toString();
    }

    public abstract long getResponseTime();

    public HttpServletRequest getRequest() {
        ServletRequest sReq = null;
        if (this._req == null) {
            return null;
        }
        try {
            sReq = ServletUtil.unwrapRequest(this._req);
        }
        catch (RuntimeException re) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getRequest", "Caught RuntimeException unwrapping the request", re);
            }
            return null;
        }
        if (sReq instanceof HttpServletRequest) {
            return (HttpServletRequest)sReq;
        }
        return null;
    }

    public HttpServletResponse getResponse() {
        ServletResponse sRes = null;
        if (this._resp == null) {
            return null;
        }
        try {
            sRes = ServletUtil.unwrapResponse(this._resp);
        }
        catch (RuntimeException re) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getResponse", "Caught RuntimeException unwrapping the response", re);
            }
            return null;
        }
        if (sRes instanceof HttpServletResponse) {
            return (HttpServletResponse)sRes;
        }
        return null;
    }

    public void setRequest(HttpServletRequest req) {
        this._req = req;
    }

    public void setResponse(HttpServletResponse res) {
        this._resp = res;
    }
}

