/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.servlet.error;

import com.ibm.ws.webcontainer.servlet.DefaultErrorReporter;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.ServletException;

public class ServletErrorReport
extends ServletException {
    private static final long serialVersionUID = 4048795645651465012L;
    public static final String ATTRIBUTE_NAME = "ErrorReport";
    private String _servletName;
    private int _statusCode;

    public ServletErrorReport() {
    }

    public ServletErrorReport(String message) {
        super(message);
    }

    public ServletErrorReport(String message, Throwable rootCause) {
        super(message, rootCause);
    }

    public ServletErrorReport(Throwable rootCause) {
        super(rootCause);
    }

    public String getMessage() {
        return DefaultErrorReporter.encodeChars(super.getMessage());
    }

    public String getUnencodedMessage() {
        return super.getMessage();
    }

    public String getMessageAsHTML() {
        return "Error " + this.getErrorCode() + ": " + this.getMessage();
    }

    public String getStackTraceAsString() {
        return this.getStackTrace(this);
    }

    public int getErrorCode() {
        return this._statusCode;
    }

    public String getTargetServletName() {
        return this._servletName;
    }

    public void setErrorCode(int sc) {
        this._statusCode = sc;
    }

    protected void setTargetServletName(String servletName) {
        this._servletName = servletName;
    }

    protected String getStackTrace(Throwable th) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        th.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    public Throwable getCause() {
        return this.getRootCause();
    }

    public String getExceptionType() {
        Throwable temp;
        String exceptionType = null;
        Throwable rootCause = this;
        while ((temp = ((ServletException)rootCause).getRootCause()) != null && (rootCause = temp) instanceof ServletException) {
        }
        exceptionType = rootCause != null ? rootCause.getClass().getName() : this.getClass().getName();
        return exceptionType;
    }
}

