/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.security.auth.callback;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.callback.WSCredTokenCallbackImpl;
import com.ibm.websphere.security.auth.callback.WSRealmNameCallbackImpl;
import com.ibm.ws.security.common.auth.util.CredentialsHelper;
import com.ibm.wsspi.security.auth.callback.WSAppContextCallback;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class WSCallbackHandlerImpl
implements CallbackHandler {
    private String userName;
    private String realm;
    private String password;
    private byte[] credToken;
    private Map appContext;
    private static final TraceComponent tc = Tr.register(WSCallbackHandlerImpl.class, null, "com.ibm.ejs.resources.security");

    public WSCallbackHandlerImpl(String userName, String password) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSCallbackHandlerImpl(userName = \"" + userName + "\", password = \"********\")");
        }
        this.userName = userName;
        this.password = password;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSCallbackHandlerImpl(userName, password)");
        }
    }

    public WSCallbackHandlerImpl(String userName, String realmName, String password) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSCallbackHandlerImpl(userName = \"" + userName + "\", password = \"********\", realmName = \"" + realmName + "\")");
        }
        this.userName = userName;
        this.password = password;
        this.realm = realmName;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSCallbackHandlerImpl(userName, password)");
        }
    }

    public WSCallbackHandlerImpl(String userName, String realmName, String password, Map appContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSCallbackHandlerImpl(userName = \"" + userName + "\", password = \"********\", realmName = \"" + realmName + "\", appContext = \"" + appContext + "\")");
        }
        this.userName = userName;
        this.password = password;
        this.realm = realmName;
        this.appContext = appContext;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSCallbackHandlerImpl(userName, password)");
        }
    }

    public WSCallbackHandlerImpl(byte[] credToken) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSCallbackHandlerImpl(credToken)");
        }
        this.credToken = CredentialsHelper.copyCredToken(credToken);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSCallbackHandlerImpl(credToken)");
        }
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        int len = 0;
        if (callbacks == null || (len = callbacks.length) == 0) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "handle(callbacks = \"{ }\")");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handle(callbacks)");
            }
            return;
        }
        if (tc.isEntryEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("{ ");
            for (int i = 0; i < len; ++i) {
                sb.append(callbacks[i].getClass().getName());
                if (i >= len - 1) continue;
                sb.append(", ");
            }
            sb.append(" }");
            Tr.entry(tc, "handle(callbacks = \"" + sb.toString() + "\")");
        }
        for (int i = 0; i < len; ++i) {
            Callback c = callbacks[i];
            if (c instanceof NameCallback) {
                ((NameCallback)c).setName(this.userName);
                continue;
            }
            if (c instanceof PasswordCallback) {
                ((PasswordCallback)c).setPassword(this.password == null ? null : this.password.toCharArray());
                continue;
            }
            if (c instanceof WSCredTokenCallbackImpl) {
                ((WSCredTokenCallbackImpl)c).setCredToken(this.credToken);
                continue;
            }
            if (c instanceof WSRealmNameCallbackImpl) {
                ((WSRealmNameCallbackImpl)c).setRealmName(this.realm);
                continue;
            }
            if (c instanceof WSAppContextCallback) {
                ((WSAppContextCallback)c).setContext(this.appContext);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Un-use handle(callbacks = \"" + callbacks[i].getClass().getName() + "\")");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handle(callbacks)");
        }
    }
}

