/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.pmi.stat;

import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.stat.Statistic;
import java.io.Serializable;

public abstract class StatisticImpl
implements Statistic,
Serializable {
    public static final long serialVersionUID = 1358353157061734347L;
    int id;
    long startTime = 0L;
    long lastSampleTime = 0L;
    transient boolean enabled = true;
    transient boolean sync = false;
    transient Object syncObj = new Object();
    transient PmiDataInfo dataInfo = null;

    public StatisticImpl(int id) {
        this.id = id;
        this.lastSampleTime = this.startTime = System.currentTimeMillis();
    }

    public StatisticImpl(int id, String name, String unit, String description, long startTime, long lastSampleTime) {
        this.id = id;
        this.startTime = startTime;
        this.lastSampleTime = lastSampleTime;
        startTime = System.currentTimeMillis();
    }

    public String getName() {
        if (this.dataInfo != null) {
            return this.dataInfo.getName();
        }
        return null;
    }

    public String getUnit() {
        if (this.dataInfo != null) {
            return this.dataInfo.getUnit();
        }
        return null;
    }

    public String getDescription() {
        if (this.dataInfo != null) {
            return this.dataInfo.getDescription();
        }
        return null;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getLastSampleTime() {
        return this.lastSampleTime;
    }

    public void enable(int level) {
        this.sync = level >= 15;
        if (!this.enabled) {
            this.enabled = true;
            this.reset();
        }
    }

    public void disable() {
        this.enabled = false;
        this.sync = false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void reset() {
        this.lastSampleTime = this.startTime = System.currentTimeMillis();
    }

    public void setDataInfo(PmiModuleConfig config2) {
        if (config2 != null) {
            this.dataInfo = config2.getDataInfo(this.id);
        }
    }

    public void setDataInfo(PmiDataInfo info) {
        this.dataInfo = info;
    }

    public void setLastSampleTime(long lastSampleTime) {
        this.lastSampleTime = lastSampleTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public int getId() {
        return this.id;
    }

    public PmiDataInfo getDataInfo() {
        return this.dataInfo;
    }

    public String toXML() {
        return null;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuffer str = new StringBuffer();
        str.append(indent);
        str.append("id=");
        str.append(this.id);
        str.append(" name=");
        str.append(this.getName());
        str.append(" description=");
        str.append(this.getDescription());
        str.append(" unit=");
        str.append(this.getUnit());
        str.append(" startTime=");
        str.append(this.startTime);
        return str.toString();
    }

    public abstract void update(Statistic var1);

    public abstract Statistic delta(Statistic var1);

    public abstract void combine(Statistic var1);

    public abstract void resetOnClient(Statistic var1);
}

