/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.pmi.reqmetrics;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.pmi.reqmetrics.PmiReqMetricsXfc;
import java.util.ArrayList;
import java.util.Properties;

public class PmiReqMetrics {
    public static final String IDENTITY = "identity";
    public static final int EJB_COMPONENT_ID = 0;
    public static final int SERVLET_COMPONENT_ID = 1;
    public static final int JDBC_COMPONENT_ID = 2;
    public static final int WEB_SERVICES_PROVIDER_ID = 3;
    public static final int WEB_SERVICES_REQUESTOR_ID = 4;
    public static final int ASYNC_BEANS_COMPONENT_ID = 5;
    public static final int NAMING_COMPONENT_ID = 6;
    public static final int SERVLETFILTER_COMPONENT_ID = 7;
    public static final int JMS_MDB_ID = 8;
    public static final int JMS_SEND_RECEIVE_ID = 9;
    public static final int WEB_SERVICES_COMPONENT_ID = 3;
    public static final int JMS_COMPONENT_ID = 8;
    public static final String[] COMP_NAMES = new String[]{"EJB", "URI", "JDBC", "Web Services", "Web Services", "AsyncBeans", "JNDI", "Servlet Filter", "JMS", "JMS"};
    private static final String[] ejb_ctxnames = new String[]{"EJBName", "ApplicationName", "ModuleName", "EJB name"};
    private static final String[] uri_ctxnames = new String[]{"URI", "Port", "QueryString"};
    private static final String[] webservices_provider_ctxnames = new String[]{"WsdlPort", "Operation", "Transport", "NameSpace", "InputMessage"};
    private static final String[] webservices_requestor_ctxnames = new String[]{"WsdlPort", "Operation", "Transport", "Parameters"};
    private static final String[] asyncbeans_ctxnames = new String[]{"Type", "ClassName"};
    private static final String[] naming_ctxnames = new String[]{"JNDIName"};
    private static final String[] servletfilter_ctxnames = new String[]{"FilterName"};
    private static final String[] jms_mdb_ctxnames = new String[]{"DestinationName", "MessageSelector", "Provider"};
    private static final String[] jms_send_receive_ctxnames = new String[]{"ClassName", "MethodName"};
    public static final int ASYNC_BEANS_NOTHING = -1;
    public static final int ASYNC_BEANS_WORK = 0;
    public static final int ASYNC_BEANS_ALARM = 1;
    public static final int ASYNC_BEANS_DEFERRED_EXECUTION = 2;
    public static final int ASYNC_BEANS_DAEMON = 3;
    public static final int INBOUND = 1;
    public static final int OUTBOUND = 2;
    public static final int INPROCESS = 3;
    public static final int BLOCKED = 4;
    public static final int BINDTHREAD = 5;
    public static final int INBOUND_ONTHREAD = 10;
    public static final int TRAN_DETAIL_LEVEL_NONE = 0;
    public static final int TRAN_DETAIL_LEVEL_PERF = 1;
    public static final int TRAN_DETAIL_LEVEL_BASIC = 2;
    public static final int TRAN_DETAIL_LEVEL_EXTENDED = 3;
    public static final int TRAN_DETAIL_LEVEL_UNKNOWN = -1;
    public static final int RM_ARM_GOOD = 0;
    public static final int RM_ARM_ABORT = 1;
    public static final int RM_ARM_FAILED = 2;
    public static final int RM_ARM_UNKNOWN = -1;
    public static final String URI_FILTER_TYPE = "URI";
    public static final String SOURCE_IP_FILTER_TYPE = "SOURCE_IP";
    public static final String EJB_FILTER_TYPE = "EJB";
    public static final String JMS_FILTER_TYPE = "JMS";
    public static final String WEB_SREVICES_FILTER_TYPE = "WEB_SERVICES";
    private static final TraceComponent tc = Tr.register(PmiReqMetrics.class.getName(), "pmi.rm", "com.ibm.ws.pmi.reqmetrics.reqmetrics");
    private static PmiReqMetricsXfc _instance = null;
    private static boolean _rmEnabled = false;
    private static boolean _rmReadyToEnable = false;
    private static ArrayList compRegistration = new ArrayList();

    public static Object updateBegin(int regId, String type, String detail) {
        return PmiReqMetrics.reqStart(null, regId, 2, new String[]{detail});
    }

    public static Object updateBegin(Object ctx, int regId, String type, String detail) {
        return PmiReqMetrics.reqStart(ctx, regId, 2, new String[]{detail});
    }

    public static void updateEnd(Object ctx, int regId, int status) {
        PmiReqMetrics.reqStop(ctx, regId, 2, status);
    }

    public static Object setInboundCorrelators(int regId, String[] correlators) {
        return PmiReqMetrics.setInboundCorrelators(null, regId, correlators, true);
    }

    public static Object setInboundCorrelators(Object context, int regId, String[] correlators, boolean filterPassed) {
        if (!_rmEnabled || _instance == null) {
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setInboundCorrelators: context=" + context + ", regId=" + regId + ", correlators=" + correlators);
            if (correlators != null) {
                for (int i = 0; i < correlators.length; ++i) {
                    Tr.debug(tc, "setInboundCorrelators " + i + ": " + correlators[i]);
                }
            }
        }
        if (regId < 0 || regId >= compRegistration.size()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "setInboundCorrelators, request metrics cannot instrument this transaction since the component id" + regId + " is unknown");
            }
            return null;
        }
        return _instance.setInboundCorrelators(context, regId, correlators, filterPassed);
    }

    public static Object reqStart(int regId, String requestType, String reqDetail) {
        if (!_rmEnabled || _instance == null) {
            return null;
        }
        if (regId < 0 || regId >= compRegistration.size()) {
            Tr.debug(tc, "reqStart, request metrics cannot instrument this transaction since the component id" + regId + " is unknown");
            return null;
        }
        if (_instance.isComponentEnabled(regId)) {
            return _instance.reqStart(null, regId, 1, null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "reqStart: this component " + regId + " is disabled for request metrics instrumentation");
        }
        return null;
    }

    public static Object reqStart(int regId, int reqScope, String reqDetail, String[] contextData) {
        return PmiReqMetrics.reqStart(null, regId, reqScope, contextData);
    }

    public static Object reqStart(Object context, int regId, int reqScope, String reqDetail, String[] contextData, String[] correlators) {
        if (!_rmEnabled || _instance == null) {
            return null;
        }
        if (correlators != null) {
            context = PmiReqMetrics.setInboundCorrelators(regId, correlators);
        }
        return PmiReqMetrics.reqStart(context, regId, reqScope, contextData);
    }

    public static Object reqStart(int regId, int reqScope, String[] contextData) {
        return PmiReqMetrics.reqStart(null, regId, reqScope, contextData);
    }

    public static Object reqStart(Object context, int regId, int reqScope, String[] contextData) {
        if (!_rmEnabled || _instance == null) {
            return null;
        }
        if (regId < 0 || regId >= compRegistration.size()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "reqStart, request metrics cannot instrument this transaction since registration id " + regId + " is unknown");
            }
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            StringBuffer strBuf1 = new StringBuffer();
            if (contextData != null) {
                for (int i = 0; i < contextData.length; ++i) {
                    strBuf1.append(contextData[i]).append(",");
                }
            }
            Tr.debug(tc, "reqStart, context=" + context + ", regId=" + regId + ", reqScope=" + reqScope + ", contextData=" + strBuf1.toString());
        }
        try {
            if (reqScope == 10) {
                reqScope = 1;
            }
            return _instance.reqStart(context, regId, reqScope, contextData);
        }
        catch (Exception ex) {
            Tr.warning(tc, "PMRM0108E", new Object[]{"reqStop"});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    public static Object setArrivalTime(int regId) {
        return null;
    }

    public static Object setArrivalTime(Object context, int regId) {
        return context;
    }

    public static void reqStop(Object ctx, int regId, int status) {
        PmiReqMetrics.reqStop(ctx, regId, 1, status, null);
    }

    public static void reqStop(Object ctx, int regId, int reqScope, int status) {
        PmiReqMetrics.reqStop(ctx, regId, reqScope, status, null);
    }

    public static void reqStop(Object ctx, int regId, int reqScope, int status, Properties detailInfo) {
        block9: {
            if (!_rmEnabled || _instance == null) {
                return;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                if (detailInfo != null) {
                    Tr.debug(tc, "reqStop, context=" + ctx + ", regId=" + regId + ", reqScope=" + reqScope + ", status=" + status + ", detailInfo=" + detailInfo.toString());
                } else {
                    Tr.debug(tc, "reqStop, context=" + ctx + ", regId=" + regId + ", reqScope=" + reqScope + ", status=" + status + ", detailInfo=null");
                }
            }
            if (regId < 0 || regId >= compRegistration.size()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "reqStop, request metrics cannot instrument this transaction since the component id" + regId + " is unknown");
                }
                return;
            }
            try {
                if (reqScope == 10) {
                    reqScope = 1;
                }
                _instance.reqStop(ctx, regId, reqScope, status, detailInfo);
            }
            catch (Exception ex) {
                Tr.warning(tc, "PMRM0108E", new Object[]{"reqStop"});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block9;
                ex.printStackTrace();
            }
        }
    }

    public static Object bindThread(int regId, String reqType, String reqDetail) {
        if (!_rmEnabled || _instance == null) {
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "bindThread: regId=" + regId + ", type=" + reqType + ", detail=" + reqDetail);
        }
        if (regId < 0 || regId >= compRegistration.size()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "bindThread, request metrics cannot instrument this transaction since the component id" + regId + " is unknown");
            }
            return null;
        }
        if (_instance.isComponentEnabled(regId)) {
            return _instance.bindThread(regId, reqType, reqDetail);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "bindThread: this component " + regId + " is disabled for request metrics instrumentation");
        }
        return null;
    }

    public static Object bindThread(Object ctx, int regId, String reqType, String reqDetail) {
        if (!_rmEnabled || _instance == null) {
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "bindThread: regId=" + regId + ", type=" + reqType + ", detail=" + reqDetail);
        }
        if (regId < 0 || regId >= compRegistration.size()) {
            Tr.debug(tc, "bindThread, request metrics cannot instrument this transaction since the component id" + regId + " is unknown");
            return null;
        }
        if (_instance.isComponentEnabled(regId)) {
            return _instance.bindThread(ctx, regId, reqType, reqDetail);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "bindThread: this component " + regId + " is disabled for request metrics instrumentation");
        }
        return null;
    }

    public static void unbindThread(Object context, int regId, int status) {
        if (!_rmEnabled || _instance == null) {
            return;
        }
        if (regId < 0 || regId >= compRegistration.size()) {
            Tr.debug(tc, "unbindThread, request metrics cannot instrument this transaction since the component id" + regId + " is unknown");
            return;
        }
        if (!_instance.isComponentEnabled(regId)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "unbindThread: this component " + regId + " is disabled for request metrics instrumentation");
            }
            return;
        }
        _instance.unbindThread(context, regId, status);
    }

    public static byte[] getArmCorrelator() {
        if (!_rmEnabled || _instance == null) {
            return null;
        }
        byte[] armCorrelator = null;
        if (_instance != null) {
            armCorrelator = _instance.getArmCorrelator(null);
        }
        return armCorrelator;
    }

    public static byte[] getArmCorrelator(Object context) {
        if (!_rmEnabled || _instance == null) {
            return null;
        }
        byte[] armCorrelator = null;
        if (_instance != null) {
            armCorrelator = _instance.getArmCorrelator(context);
        }
        return armCorrelator;
    }

    public static String getArmCorrelatorInString(Object context) {
        if (!_rmEnabled || _instance == null) {
            return null;
        }
        String armCorrelator = null;
        if (_instance != null) {
            armCorrelator = _instance.getArmCorrelatorInString(context);
        }
        return armCorrelator;
    }

    public static String[] getCorrelatorsInString(Object context) {
        if (!_rmEnabled || _instance == null) {
            return null;
        }
        return _instance.getCorrelatorsInString(context);
    }

    public static boolean isReadyToEnable() {
        return _rmReadyToEnable;
    }

    public static boolean isEnabled() {
        return _rmEnabled;
    }

    public static boolean isARMEnabled() {
        if (!_rmEnabled || _instance == null) {
            return false;
        }
        return _instance.isARMEnabled();
    }

    public static int getTranDetailLevel(int regId) {
        if (!_rmEnabled || _instance == null) {
            return 0;
        }
        return PmiReqMetrics.getTranDetailLevel(null, regId);
    }

    public static int getTranDetailLevel(Object context, int regId) {
        if (!_rmEnabled) {
            return 0;
        }
        if (regId < 0 || regId >= compRegistration.size()) {
            Tr.debug(tc, "reqStart, request metrics cannot instrument this transaction since registration id " + regId + " is unknown");
            return 0;
        }
        if (_instance == null) {
            return 0;
        }
        return _instance.getTranDetailLevel(context, regId);
    }

    public static boolean isComponentEnabled(int regId) {
        if (!_rmEnabled) {
            return false;
        }
        if (_instance == null) {
            return false;
        }
        return _instance.isComponentEnabled(regId);
    }

    public static boolean isComponentEnabled(int regId, int reqScope) {
        if (!_rmEnabled) {
            return false;
        }
        if (_instance == null) {
            return false;
        }
        if (reqScope == 10) {
            reqScope = 1;
        }
        return _instance.isComponentEnabled(regId, reqScope);
    }

    public static boolean isPassCorrelatorToDB() {
        if (!_rmEnabled || _instance == null) {
            return false;
        }
        return _instance.isPassCorrelatorToDB();
    }

    public static synchronized void setInstance(Object instance) {
        if (instance == null || !(instance instanceof PmiReqMetricsXfc)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "setInstance: null or wrong instance is passed");
            }
            return;
        }
        _instance = (PmiReqMetricsXfc)instance;
        _rmReadyToEnable = true;
        for (int i = 0; i < compRegistration.size(); ++i) {
            ComponentInfo info = (ComponentInfo)compRegistration.get(i);
            _instance.register(info.componentName, info.identity, info.contextNames);
        }
    }

    public static synchronized void setEnable(boolean enable) {
        _rmEnabled = enable;
    }

    public static synchronized int register(String compName, Properties identity, String[] contextNames) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            StringBuffer strBuf1 = new StringBuffer();
            if (contextNames != null) {
                for (int i = 0; i < contextNames.length; ++i) {
                    strBuf1.append(contextNames[i]).append(",");
                }
            }
            Tr.debug(tc, "register: compName=" + compName + ", identity=" + identity + ", contextNames=" + strBuf1.toString());
        }
        if (_instance != null) {
            int regId = _instance.register(compName, identity, contextNames);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "register (done), new compName=" + compName + ", regId=" + regId);
            }
            if (regId == compRegistration.size()) {
                compRegistration.add(new ComponentInfo(compName, identity, contextNames));
            }
            return regId;
        }
        ComponentInfo info = new ComponentInfo(compName, identity, contextNames);
        compRegistration.add(info);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "register (to be done): compName=" + compName + ", regId=" + (compRegistration.size() - 1));
        }
        return compRegistration.size() - 1;
    }

    public static synchronized int registerComponent(String compName, String[] contextNames) {
        return PmiReqMetrics.register(compName, null, contextNames);
    }

    public static Object getRMContext(boolean useCurrent) {
        if (!_rmEnabled || _instance == null) {
            return null;
        }
        Object ctx = _instance.getRMContext(useCurrent);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getRMContext useCurrent=" + useCurrent + ", ctx=" + ctx);
        }
        return ctx;
    }

    public static void setRMContext(Object contextObj) {
        if (!_rmEnabled || _instance == null) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setRMContext contextObj=" + contextObj);
        }
        _instance.setRMContext(contextObj);
    }

    public static void setRMContextPoolSize(int minSize, int maxSize) {
        if (!_rmEnabled || _instance == null) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setRMContextPoolSize minSize=" + minSize + ", maxSize=" + maxSize);
        }
        _instance.setRMContextPoolSize(minSize, maxSize);
    }

    public static boolean isFilterPassed(String filterType, String valueToCheck) {
        if (!_rmEnabled || _instance == null) {
            return false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "isFilterPassed, filterType=" + filterType + ", valueToCheck=" + valueToCheck);
        }
        return _instance.isFilterPassed(filterType, valueToCheck);
    }

    static {
        PmiReqMetrics.register(COMP_NAMES[0], null, ejb_ctxnames);
        PmiReqMetrics.register(COMP_NAMES[1], null, uri_ctxnames);
        PmiReqMetrics.register(COMP_NAMES[2], null, null);
        Properties props1 = new Properties();
        props1.put(IDENTITY, "Provider");
        PmiReqMetrics.register(COMP_NAMES[3], props1, webservices_provider_ctxnames);
        Properties props2 = new Properties();
        props2.put(IDENTITY, "Requestor");
        PmiReqMetrics.register(COMP_NAMES[4], props2, webservices_requestor_ctxnames);
        PmiReqMetrics.register(COMP_NAMES[5], null, asyncbeans_ctxnames);
        PmiReqMetrics.register(COMP_NAMES[6], null, naming_ctxnames);
        PmiReqMetrics.register(COMP_NAMES[7], null, servletfilter_ctxnames);
        Properties props3 = new Properties();
        props3.put(IDENTITY, "");
        PmiReqMetrics.register(COMP_NAMES[8], props3, jms_mdb_ctxnames);
        Properties props4 = new Properties();
        props4.put(IDENTITY, "send/receive");
        PmiReqMetrics.register(COMP_NAMES[9], props4, jms_send_receive_ctxnames);
    }

    static class ComponentInfo {
        String componentName;
        Properties identity;
        String[] contextNames;

        ComponentInfo(String compName, Properties idProps, String[] ctxNames) {
            this.componentName = compName;
            this.identity = idProps;
            this.contextNames = ctxNames;
        }
    }
}

