/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.pmi.extutils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.pmi.PmiJmxMapper;
import com.ibm.websphere.pmi.extutils.AdminUtil;
import com.ibm.websphere.pmi.extutils.MultipleObjectNamesExistException;
import com.ibm.websphere.pmi.stat.MBeanStatDescriptor;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.PmiRegistry;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class AdminUtilSrvImpl
implements AdminUtil {
    private AdminService as = null;
    private HashMap pmiDescToMbeanDesc = new HashMap();
    private HashMap mbeanDescToPmiDesc = new HashMap();
    private HashMap objectNameCache = new HashMap();
    private static final int BUFFER_LENGTH = 64;
    private static final TraceComponent tc = Tr.register(AdminUtilSrvImpl.class, null, "com.ibm.ws.pmi.properties.PMIMessages");

    public AdminUtilSrvImpl() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AdminUtilSrvImpl");
        }
        this.as = AdminServiceFactory.getAdminService();
        if (this.as != null) {
            PmiRegistry.nodeName = this.as.getNodeName();
            PmiRegistry.serverName = this.as.getProcessName();
        }
    }

    public ObjectName findObjectName(String name, String type, String node, String process) throws MultipleObjectNamesExistException {
        ObjectName queriedName;
        String processName;
        String processType;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findObjectName: type=" + type + ", name=" + name);
        }
        StringBuffer oName = new StringBuffer(64);
        oName.append("WebSphere:*");
        if (name != null) {
            oName.append(",name=").append(name);
        }
        if ((processType = AdminServiceFactory.getAdminService().getProcessType()).equals("NodeAgent")) {
            processName = AdminServiceFactory.getAdminService().getProcessName();
            String nodeName = AdminServiceFactory.getAdminService().getNodeName();
            oName.append(",process=").append(processName);
            oName.append(",node=").append(nodeName);
        } else if (processType.equals("DeploymentManager")) {
            processName = AdminServiceFactory.getAdminService().getProcessName();
            String nodeName = AdminServiceFactory.getAdminService().getNodeName();
            oName.append(",node=").append(nodeName);
            oName.append(",process=").append(processName);
        }
        if (type != null) {
            oName.append(",type=").append(type);
        }
        if ((queriedName = this.queryName(oName.toString())) == null && tc.isDebugEnabled()) {
            Tr.warning(tc, "PMI0018W", "findObjectName " + oName.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findObjectName(String name,String type, String node, String process)");
        }
        return queriedName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName findObjectName(String mbeanIdentifier, String node, String process) {
        ObjectName objectName;
        String nodeName;
        String processName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findObjectName: mbeanIdentifier=" + mbeanIdentifier);
        }
        StringBuffer oName = new StringBuffer(64);
        oName.append("WebSphere:*,mbeanIdentifier=").append(mbeanIdentifier);
        String processType = AdminServiceFactory.getAdminService().getProcessType();
        if (processType.equals("NodeAgent")) {
            processName = AdminServiceFactory.getAdminService().getProcessName();
            nodeName = AdminServiceFactory.getAdminService().getNodeName();
            oName.append(",process=").append(processName);
            oName.append(",node=").append(nodeName);
        } else if (processType.equals("DeploymentManager")) {
            processName = AdminServiceFactory.getAdminService().getProcessName();
            nodeName = AdminServiceFactory.getAdminService().getNodeName();
            oName.append(",node=").append(nodeName);
            oName.append(",process=").append(processName);
        }
        try {
            ObjectName queriedName;
            objectName = queriedName = this.queryName(oName.toString());
            return objectName;
        }
        catch (MultipleObjectNamesExistException e) {
            objectName = null;
            return objectName;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "findObjectName(String mbeanIdentifier)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectName queryName(String oNameString) throws MultipleObjectNamesExistException {
        if (oNameString == null) {
            return null;
        }
        ObjectName queriedName = (ObjectName)this.objectNameCache.get(oNameString);
        if (queriedName == null) {
            Set oSet = null;
            oSet = this.findObjectNamesInServer(oNameString);
            if (oSet == null || oSet.size() == 0) {
                return null;
            }
            if (oSet.size() > 1) {
                throw new MultipleObjectNamesExistException("AdminUtilImpl:findObjectName - Supplied parameters were insuffient to make the ObjectName unique: query string= " + oNameString);
            }
            queriedName = (ObjectName)oSet.iterator().next();
            if (queriedName != null) {
                HashMap hashMap = this.objectNameCache;
                synchronized (hashMap) {
                    this.objectNameCache.put(oNameString, queriedName);
                }
            }
        }
        return queriedName;
    }

    private Set findObjectNamesInServer(String oName) {
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "findObjectNamesInServer(StringBuffer oName)");
            }
            if (this.as != null) {
                try {
                    Set s = this.as.queryNames(new ObjectName(oName), null);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "findObjectNamesInServer(StringBuffer oName)");
                    }
                    return s;
                }
                catch (MalformedObjectNameException mone) {
                    FFDCFilter.processException((Throwable)mone, "com.ibm.websphere.pmi.extutils.findObjectNamesInServer", "191", this);
                    if (tc.isDebugEnabled()) {
                        Tr.error(tc, "PMI0016W", mone);
                    }
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, "com.ibm.websphere.pmi.extutils.findObjectNamesInServer", "196", this);
                    if (!tc.isDebugEnabled()) break block8;
                    Tr.error(tc, "PMI0016W", ex);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findObjectNamesInServer(StringBuffer oName)");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName[] findObjectNames(String name, String type, String node, String process) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findObjectNames(String name,String type,String node,String process)");
        }
        StringBuffer oNameQuery = new StringBuffer(64);
        oNameQuery.append("WebSphere:*");
        if (name != null) {
            oNameQuery.append(",name=").append(name);
        }
        if (type != null) {
            oNameQuery.append(",type=").append(type);
        }
        ObjectName[] queriedNames = null;
        Set oSet = null;
        oSet = this.findObjectNamesInServer(oNameQuery.toString());
        if (oSet == null || oSet.size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.warning(tc, "PMI0018W", "findObjectNames " + oNameQuery.toString());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "findObjectNames(String name,String type,String node,String process)");
            }
            return null;
        }
        queriedNames = new ObjectName[oSet.size()];
        int i = 0;
        Iterator it = oSet.iterator();
        while (it.hasNext()) {
            queriedNames[i] = (ObjectName)it.next();
            ++i;
        }
        for (i = 0; i < queriedNames.length; ++i) {
            oNameQuery = new StringBuffer(64);
            oNameQuery.append("WebSphere:*name=");
            if (name == null) {
                oNameQuery.append(queriedNames[i].getKeyProperty("name"));
            } else {
                oNameQuery.append(name);
            }
            oNameQuery.append(",type=");
            if (type == null) {
                oNameQuery.append(queriedNames[i].getKeyProperty("type"));
            } else {
                oNameQuery.append(type);
            }
            oNameQuery.append(",node=");
            if (node == null) {
                oNameQuery.append(queriedNames[i].getKeyProperty("node"));
            } else {
                oNameQuery.append(node);
            }
            oNameQuery.append(",process=");
            if (process == null) {
                oNameQuery.append(queriedNames[i].getKeyProperty("process"));
            } else {
                oNameQuery.append(process);
            }
            if (this.objectNameCache.containsKey(oNameQuery.toString())) continue;
            HashMap hashMap = this.objectNameCache;
            synchronized (hashMap) {
                this.objectNameCache.put(oNameQuery.toString(), queriedNames[i]);
                continue;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findObjectNames(String name,String type,String node,String process)");
        }
        return queriedNames;
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) {
        return null;
    }

    public Object getAttribute(ObjectName oName, String attributeName) {
        return null;
    }

    public AdminClient getAdminClient() {
        return null;
    }

    public AdminService getAdminService() {
        return this.as;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMapping(String nodeName, String serverName, DataDescriptor dd, MBeanStatDescriptor msd) {
        if (dd != null && msd != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setMapping: dd.toString()=" + dd.toString() + ", msd.toString=" + msd.toString());
            }
            String ddKey = PmiJmxMapper.StringArrayToString(dd.getPath());
            HashMap hashMap = this.pmiDescToMbeanDesc;
            synchronized (hashMap) {
                this.pmiDescToMbeanDesc.put(ddKey, msd);
            }
            String mBeanKey = msd.getIdentifier();
            HashMap hashMap2 = this.mbeanDescToPmiDesc;
            synchronized (hashMap2) {
                this.mbeanDescToPmiDesc.put(mBeanKey, dd);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setMapping: dd=" + dd.toString() + ", mBeanKey=" + mBeanKey);
            }
        }
    }

    public DataDescriptor mBeanDescToPmiDesc_get(MBeanStatDescriptor msd) {
        if (msd == null) {
            return null;
        }
        String key = msd.getIdentifier();
        DataDescriptor dd = (DataDescriptor)this.mbeanDescToPmiDesc.get(key);
        if (dd != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cache HIT 1 msd=" + key);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "MISS, msd=" + key);
        }
        return dd;
    }

    public MBeanStatDescriptor pmiDescToMBeanDesc_get(String nodeName, String serverName, DataDescriptor dd) {
        String ddStringPath = PmiJmxMapper.StringArrayToString(dd.getPath());
        MBeanStatDescriptor msd = (MBeanStatDescriptor)this.pmiDescToMbeanDesc.get(ddStringPath);
        if (msd != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cache HIT 1 dd=" + ddStringPath);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "MISS, dd=" + ddStringPath);
        }
        return msd;
    }
}

