/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.repository;

import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.repository.Document;
import com.ibm.websphere.management.repository.RepositoryInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;

public class DocumentContentSource
implements Serializable {
    private static final long serialVersionUID = -8662410128695608386L;
    private Document document;
    private InputStream source;
    private long lastModified = 0L;

    public DocumentContentSource(Document doc, InputStream src) {
        this.setDocument(doc);
        if (src != null) {
            this.setSource(src);
        }
    }

    public DocumentContentSource(Document doc, byte[] data) {
        this.setDocument(doc);
        if (data != null) {
            this.setSource(data);
        }
    }

    public DocumentContentSource(Document doc, File file) {
        this.setDocument(doc);
        if (file != null) {
            this.setSource(file);
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public InputStream getSource() {
        return this.source;
    }

    public void setSource(InputStream source) {
        this.source = source;
        this.lastModified = 0L;
    }

    public void setSource(byte[] data) {
        this.setSource(new ByteArrayInputStream(data));
    }

    public void setSource(File file) {
        try {
            this.setSource(new RepositoryInputStream(file));
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.websphere.management.repository.DocumentContentSource.setSource", "116", this);
            this.source = null;
        }
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long t) {
        if (t >= 0L) {
            this.lastModified = t;
        }
    }
}

