/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.filetransfer.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.filetransfer.FileTransferConfig;
import com.ibm.websphere.management.filetransfer.client.FileTransferClient;
import com.ibm.websphere.management.filetransfer.client.FileTransferOptions;
import com.ibm.websphere.management.filetransfer.client.TransferFailedException;
import com.ibm.websphere.management.repository.RepositoryTempInputStream;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.repository.TempFileInputStream;
import com.ibm.ws.util.ImplFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class FileDownloadInputStream
extends RepositoryTempInputStream
implements Serializable {
    private static final long serialVersionUID = 6521346973672823614L;
    private boolean isInputStreamDeserialized = false;
    private static TraceComponent tc = Tr.register(FileDownloadInputStream.class, "Admin", "com.ibm.ws.management.resources.fileservice");
    FileTransferOptions options = (FileTransferOptions)ImplFactory.loadImplFromKey(FileTransferOptions.class);
    FileTransferConfig ftConfig;

    public FileDownloadInputStream() {
        this.options.setCompress(true);
        this.options.setDeleteSourceOnCompletion(true);
    }

    public FileDownloadInputStream(File file) {
        this();
        this.tempfile = file;
    }

    public FileTransferOptions getOptions() {
        return this.options;
    }

    public void setOptions(FileTransferOptions options) {
        this.options = options;
    }

    public FileTransferConfig getFileTransferConfig() {
        return this.ftConfig;
    }

    public void setFileTransferConfig(FileTransferConfig config2) {
        this.ftConfig = config2;
    }

    public void setCompress(boolean compress) {
        this.options.setCompress(compress);
    }

    public void setDeleteSourceOnCompletion(boolean delete) {
        this.options.setDeleteSourceOnCompletion(delete);
    }

    public boolean isCompress() {
        return this.options.isCompress();
    }

    public boolean isDeleteSourceOnCompletion() {
        return this.options.isDeleteSourceOnCompletion();
    }

    public void connect() throws IOException {
        try {
            if (this.remoteStream == null) {
                if (AdminHelper.getPlatformHelper().isServantJvm()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "FileDownload: Servant", this.tempfile);
                    }
                    this.remoteStream = new TempFileInputStream(this.tempfile);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "FileDownload: Remote Client", this.srcPath);
                    }
                    FileTransferClient client = (FileTransferClient)ImplFactory.loadImplFromKey(FileTransferClient.class);
                    client.setFileTransferConfig(this.ftConfig);
                    this.remoteStream = client.downloadFile(this.srcPath, this.options);
                }
            }
        }
        catch (TransferFailedException e) {
            Manager.Ffdc.log(e, this, "com.ibm.websphere.management.filetransfer.client.FileDownloadInputStream.connect", "203", this);
            throw new IOException(e.getMessage());
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.websphere.management.filetransfer.client.FileDownloadInputStream.connect", "204", this);
            throw new IOException(e.getMessage());
        }
        if (this.remoteStream == null) {
            IOException e = new IOException("Failed to download file: " + this.srcPath);
            Manager.Ffdc.log(e, this, "com.ibm.websphere.management.filetransfer.client.FileDownloadInputStream.connect", "205", this);
            throw e;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            if (this.remoteStream != null) {
                this.remoteStream.close();
            }
            out.defaultWriteObject();
        }
        catch (IOException e) {
            Manager.Ffdc.log(e, this, "com.ibm.websphere.management.filetransfer.client.FileDownloadInputStream.writeObject", "317", this);
            Tr.service(tc, "ADFS0119", e);
            throw e;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            in.defaultReadObject();
            this.isInputStreamDeserialized = true;
        }
        catch (IOException e) {
            Manager.Ffdc.log(e, this, "com.ibm.websphere.management.filetransfer.client.FileDownloadInputStream.readObject", "330", this);
            Tr.service(tc, "ADFS0119", e);
            throw e;
        }
    }

    public InputStream getStream() throws FileNotFoundException {
        Tr.entry(tc, "Entering FileDownloadInputStream.getStream ");
        try {
            if (this.isInputStreamDeserialized) {
                this.connect();
            } else {
                super.getStream();
            }
        }
        catch (Throwable t) {
            Manager.Ffdc.log(t, this, "com.ibm.websphere.management.filetransfer.client.FileDownloadInputStream.getStream", "151", this);
            if (t instanceof FileNotFoundException) {
                throw (FileNotFoundException)t;
            }
            throw new FileNotFoundException("File download failed: " + t.toString());
        }
        Tr.exit(tc, "Exiting FileDownloadInputStream.getStream ");
        return this.remoteStream;
    }
}

