/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.fileservice;

import java.io.Serializable;

public class RemoteFile
implements Serializable {
    private static final long serialVersionUID = 2268200531415934166L;
    public static final String NORMAL_FILE = "NormalFile";
    public static final String DIRECTORY = "Directory";
    public static final String ROOT = "Root";
    public static final String EAR_FILE = "EARFILE";
    public static final String EJBJAR_FILE = "EJBJAR_FILE";
    public static final String WAR_FILE = "WAR_FILE";
    public static final String RAR_FILE = "RAR_FILE";
    public static final String SAR_FILE = "SAR_FILE";
    public static final String CLASS_FILE = "CLASS_FILE";
    public static final String ZIP_FILE = "ZIP_FILE";
    private String name = null;
    private String absPath = null;
    private String type = null;
    private boolean hidden = false;
    private String parentDirectory = null;
    private String separator = null;

    public final String getName() {
        return this.name;
    }

    public final String getPath() {
        return this.absPath;
    }

    public final String getAbsolutePath() {
        return this.absPath;
    }

    public final String getType() {
        if (this.type == null) {
            return null;
        }
        if (this.type.equals(NORMAL_FILE) && this.absPath.endsWith(".war")) {
            return WAR_FILE;
        }
        if (this.type.equals(NORMAL_FILE) && this.absPath.endsWith(".ear")) {
            return EAR_FILE;
        }
        if (this.type.equals(NORMAL_FILE) && this.absPath.endsWith(".jar")) {
            return EJBJAR_FILE;
        }
        if (this.type.equals(NORMAL_FILE) && this.absPath.endsWith(".rar")) {
            return RAR_FILE;
        }
        if (this.type.equals(NORMAL_FILE) && this.absPath.endsWith(".sar")) {
            return SAR_FILE;
        }
        if (this.type.equals(NORMAL_FILE) && this.absPath.endsWith(".class")) {
            return CLASS_FILE;
        }
        if (this.type.equals(NORMAL_FILE) && this.absPath.endsWith(".zip")) {
            return ZIP_FILE;
        }
        return this.type;
    }

    public boolean isDirectory() {
        if (this.getType() == null) {
            return false;
        }
        return this.getType().equals(DIRECTORY);
    }

    public boolean isNormalFile() {
        if (this.getType() == null) {
            return false;
        }
        return this.getType().equals(NORMAL_FILE);
    }

    public final boolean isHidden() {
        return this.hidden;
    }

    public final String getParentDirectory() {
        return this.parentDirectory;
    }

    public boolean isRoot() {
        return this.getParentDirectory() == null;
    }

    public final String getSeparator() {
        return this.separator;
    }

    public String toString() {
        return this.getAbsolutePath();
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final void setAbsolutePath(String absPath) {
        this.absPath = absPath;
    }

    public final void setType(String type) {
        this.type = type;
    }

    public final void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public final void setParentDirectory(String parentDir) {
        this.parentDirectory = parentDir;
    }

    public final void setSeparator(String separator) {
        this.separator = separator;
    }

    public String dump() {
        StringBuffer b = new StringBuffer();
        b.append("name:").append(this.name);
        b.append(",absPath:").append(this.absPath);
        b.append(",type:").append(this.type);
        b.append(",hidden:").append(this.hidden);
        b.append(",parentDirectory:").append(this.parentDirectory);
        b.append(",separator:").append(this.separator);
        return b.toString();
    }
}

